/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.extensions;

import java.io.Serializable;
import matlabcontrol.MatlabInvocationException;
import matlabcontrol.MatlabProxy;
import matlabcontrol.extensions.MatlabNumericArray;

public class MatlabTypeConverter {
    private final MatlabProxy _proxy;

    public MatlabTypeConverter(MatlabProxy proxy) {
        this._proxy = proxy;
    }

    public MatlabNumericArray getNumericArray(String arrayName) throws MatlabInvocationException {
        ArrayInfo info = this._proxy.invokeAndWait(new GetArrayCallable(arrayName));
        return new MatlabNumericArray(info.real, info.imaginary, info.lengths);
    }

    public void setNumericArray(String arrayName, MatlabNumericArray array) throws MatlabInvocationException {
        this._proxy.invokeAndWait(new SetArrayCallable(arrayName, array));
    }

    public String toString() {
        return "[" + this.getClass().getName() + " proxy=" + this._proxy + "]";
    }

    private static class SetArrayCallable
    implements MatlabProxy.MatlabThreadCallable<Object>,
    Serializable {
        private static final long serialVersionUID = -7403498224028558628L;
        private final String _arrayName;
        private final double[] _realArray;
        private final double[] _imaginaryArray;
        private final int[] _lengths;

        private SetArrayCallable(String arrayName, MatlabNumericArray array) {
            this._arrayName = arrayName;
            this._realArray = array.getRealLinearArray();
            this._imaginaryArray = array.getImaginaryLinearArray();
            this._lengths = array.getLengths();
        }

        @Override
        public Object call(MatlabProxy.MatlabThreadProxy proxy) throws MatlabInvocationException {
            String realArray = (String)proxy.returningEval("genvarname('" + this._arrayName + "_real', who);", 1)[0];
            proxy.setVariable(realArray, this._realArray);
            String imagArray = null;
            if (this._imaginaryArray != null) {
                imagArray = (String)proxy.returningEval("genvarname('" + this._arrayName + "_imag', who);", 1)[0];
                proxy.setVariable(imagArray, this._imaginaryArray);
            }
            StringBuilder evalStatement = new StringBuilder(this._arrayName + " = reshape(" + realArray);
            if (this._imaginaryArray != null) {
                evalStatement.append(" + " + imagArray + " * i");
            }
            for (int length : this._lengths) {
                evalStatement.append(", " + length);
            }
            evalStatement.append(");");
            proxy.eval(evalStatement.toString());
            proxy.eval("clear " + realArray + ";");
            proxy.eval("clear " + imagArray + ";");
            return null;
        }
    }

    private static class ArrayInfo
    implements Serializable {
        private static final long serialVersionUID = 4464014916120235711L;
        private final double[] real;
        private final double[] imaginary;
        private final int[] lengths;

        public ArrayInfo(double[] real, double[] imaginary, int[] lengths) {
            this.real = real;
            this.imaginary = imaginary;
            this.lengths = lengths;
        }
    }

    private static class GetArrayCallable
    implements MatlabProxy.MatlabThreadCallable<ArrayInfo>,
    Serializable {
        private static final long serialVersionUID = -1269094288040717603L;
        private final String _arrayName;

        public GetArrayCallable(String arrayName) {
            this._arrayName = arrayName;
        }

        @Override
        public ArrayInfo call(MatlabProxy.MatlabThreadProxy proxy) throws MatlabInvocationException {
            Object realObject = proxy.returningEval("real(" + this._arrayName + ");", 1)[0];
            double[] realValues = (double[])realObject;
            boolean isReal = ((boolean[])proxy.returningEval("isreal(" + this._arrayName + ");", 1)[0])[0];
            double[] imaginaryValues = null;
            if (!isReal) {
                Object imaginaryObject = proxy.returningEval("imag(" + this._arrayName + ");", 1)[0];
                imaginaryValues = (double[])imaginaryObject;
            }
            double[] size = (double[])proxy.returningEval("size(" + this._arrayName + ");", 1)[0];
            int[] lengths = new int[size.length];
            for (int i = 0; i < size.length; ++i) {
                lengths[i] = (int)size[i];
            }
            return new ArrayInfo(realValues, imaginaryValues, lengths);
        }
    }
}

