/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.link;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class ArrayUtils {
    private static final Map<Class<?>, Character> PRIMITIVE_TO_BINARY_NAME;
    private static final Map<Class<?>, ArrayContainmentOperation<?>> CONTAINMENT_OPERATIONS;

    private ArrayUtils() {
    }

    static <T> T deepCopy(T array) {
        Object copy;
        if (array == null) {
            copy = null;
        } else if (array.getClass().isArray()) {
            if (array.getClass().getComponentType().isArray()) {
                int arrayLength = Array.getLength(array);
                copy = Array.newInstance(array.getClass().getComponentType(), arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    Array.set(copy, i, ArrayUtils.deepCopy(Array.get(array, i)));
                }
            } else {
                int arrayLength = Array.getLength(array);
                copy = Array.newInstance(array.getClass().getComponentType(), arrayLength);
                System.arraycopy(array, 0, copy, 0, arrayLength);
            }
        } else {
            throw new IllegalArgumentException("Input not an array: " + array.getClass().getCanonicalName());
        }
        return (T)copy;
    }

    static int getNumberOfElements(int[] dimensions) {
        int size = 0;
        for (int length : dimensions) {
            if (size == 0) {
                size = length;
                continue;
            }
            if (length == 0) continue;
            size *= length;
        }
        return size;
    }

    static int multidimensionalIndicesToLinearIndex(int[] dimensions, int[] indices) {
        int linearIndex = 0;
        int accumSize = 1;
        for (int i = 0; i < dimensions.length; ++i) {
            linearIndex += accumSize * indices[i];
            accumSize *= dimensions[i];
        }
        return linearIndex;
    }

    static int multidimensionalIndicesToLinearIndex(int[] dimensions, int row, int column) {
        return column * dimensions[0] + row;
    }

    static int multidimensionalIndicesToLinearIndex(int numRows, int row, int column) {
        return column * numRows + row;
    }

    static int multidimensionalIndicesToLinearIndex(int[] dimensions, int row, int column, int page) {
        return page * (dimensions[0] * dimensions[1]) + column * dimensions[0] + row;
    }

    static int checkedMultidimensionalIndicesToLinearIndex(int[] dimensions, int row, int column, int[] pages) {
        if (dimensions.length != pages.length + 2) {
            throw new IllegalArgumentException("Array has " + dimensions.length + " dimension(s), it cannot be indexed into using " + (pages.length + 2) + " indices");
        }
        if (row >= dimensions[0]) {
            throw new ArrayIndexOutOfBoundsException("[" + row + "] is out of bounds for dimension 0 where the length is " + dimensions[0]);
        }
        if (column >= dimensions[1]) {
            throw new ArrayIndexOutOfBoundsException("[" + column + "] is out of bounds for dimension 1 where the length is " + dimensions[1]);
        }
        for (int i = 0; i < pages.length; ++i) {
            if (pages[i] < dimensions[i + 2]) continue;
            throw new ArrayIndexOutOfBoundsException("[" + pages[i] + "] is out of bounds for dimension " + (i + 2) + " where the length is " + dimensions[i + 2]);
        }
        int linearIndex = 0;
        int accumSize = 1;
        linearIndex += accumSize * row;
        linearIndex += (accumSize *= dimensions[0]) * column;
        accumSize *= dimensions[1];
        for (int i = 0; i < pages.length; ++i) {
            linearIndex += accumSize * pages[i];
            accumSize *= dimensions[i + 2];
        }
        return linearIndex;
    }

    static int checkedMultidimensionalIndicesToLinearIndex(int numRows, int numCols, int row, int column) {
        if (row >= numRows) {
            throw new ArrayIndexOutOfBoundsException("[" + row + "] is out of bounds for dimension 0 where the length is " + numRows);
        }
        if (column >= numCols) {
            throw new ArrayIndexOutOfBoundsException("[" + column + "] is out of bounds for dimension 1 where the length is " + numCols);
        }
        return column * numRows + row;
    }

    static int checkedMultidimensionalIndicesToLinearIndex(int[] dimensions, int row, int column) {
        if (row >= dimensions[0]) {
            throw new ArrayIndexOutOfBoundsException("[" + row + "] is out of bounds for dimension 0 where the length is " + dimensions[0]);
        }
        if (column >= dimensions[1]) {
            throw new ArrayIndexOutOfBoundsException("[" + column + "] is out of bounds for dimension 1 where the length is " + dimensions[1]);
        }
        return column * dimensions[0] + row;
    }

    static int checkedMultidimensionalIndicesToLinearIndex(int[] dimensions, int row, int column, int page) {
        if (row >= dimensions[0]) {
            throw new ArrayIndexOutOfBoundsException("[" + row + "] is out of bounds for dimension 0 where the length is " + dimensions[0]);
        }
        if (column >= dimensions[1]) {
            throw new ArrayIndexOutOfBoundsException("[" + column + "] is out of bounds for dimension 1 where the length is " + dimensions[1]);
        }
        if (page >= dimensions[2]) {
            throw new ArrayIndexOutOfBoundsException("[" + column + "] is out of bounds for dimension 2 where the length is " + dimensions[2]);
        }
        return page * (dimensions[0] * dimensions[1]) + column * dimensions[0] + row;
    }

    static int[] linearIndexToMultidimensionalIndices(int[] dimensions, int linearIndex) {
        int[] indices = new int[dimensions.length];
        if (dimensions.length == 1) {
            indices[0] = linearIndex;
        } else {
            int pageSize = dimensions[0] * dimensions[1];
            int pageNumber = linearIndex / pageSize;
            int indexInPage = linearIndex % pageSize;
            indices[0] = indexInPage % dimensions[0];
            indices[1] = indexInPage / dimensions[0];
            int accumSize = 1;
            for (int dim = 2; dim < dimensions.length; ++dim) {
                indices[dim] = pageNumber / accumSize % dimensions[dim];
                accumSize *= dimensions[dim];
            }
        }
        return indices;
    }

    static Class<?> getBaseComponentType(Class<?> type) {
        while (type.isArray()) {
            type = type.getComponentType();
        }
        return type;
    }

    static int getNumberOfDimensions(Class<?> type) {
        int numDim = 0;
        while (type.isArray()) {
            ++numDim;
            type = type.getComponentType();
        }
        return numDim;
    }

    static int[] computeBoundingDimensions(Object array) {
        int arrayLength;
        int[] maxLengths = new int[ArrayUtils.getNumberOfDimensions(array.getClass())];
        maxLengths[0] = arrayLength = Array.getLength(array);
        if (array.getClass().getComponentType().isArray()) {
            for (int i = 0; i < arrayLength; ++i) {
                int[] childLengths = ArrayUtils.computeBoundingDimensions(Array.get(array, i));
                for (int j = 0; j < childLengths.length; ++j) {
                    maxLengths[j + 1] = Math.max(maxLengths[j + 1], childLengths[j]);
                }
            }
        }
        return maxLengths;
    }

    static Class<?> getArrayClass(Class<?> componentType, int rank) {
        String binaryName = componentType.isPrimitive() ? ArrayUtils.getPrimitiveArrayBinaryName(componentType, rank) : ArrayUtils.getObjectArrayBinaryName(componentType, rank);
        try {
            return Class.forName(binaryName, false, componentType.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not create array class\nComponent Type (Canonical Name): " + componentType.getCanonicalName() + "\nComponent Type (Name): " + componentType.getName() + "\nRank: " + rank + "\nArray Class Binary Name: " + binaryName, e);
        }
    }

    private static String getPrimitiveArrayBinaryName(Class<?> componentType, int rank) {
        char[] nameChars = new char[rank + 1];
        for (int i = 0; i < rank; ++i) {
            nameChars[i] = 91;
        }
        nameChars[nameChars.length - 1] = PRIMITIVE_TO_BINARY_NAME.get(componentType).charValue();
        return new String(nameChars);
    }

    private static String getObjectArrayBinaryName(Class<?> componentType, int rank) {
        String componentName = componentType.getName();
        int componentNameLength = componentName.length();
        char[] nameChars = new char[componentNameLength + rank + 2];
        for (int i = 0; i < rank; ++i) {
            nameChars[i] = 91;
        }
        nameChars[rank] = 76;
        System.arraycopy(componentName.toCharArray(), 0, nameChars, rank + 1, componentNameLength);
        nameChars[nameChars.length - 1] = 59;
        return new String(nameChars);
    }

    static int hashCode(Object array) {
        int hashCode;
        if (array == null) {
            hashCode = 0;
        } else if (array instanceof byte[]) {
            hashCode = Arrays.hashCode((byte[])array);
        } else if (array instanceof short[]) {
            hashCode = Arrays.hashCode((short[])array);
        } else if (array instanceof int[]) {
            hashCode = Arrays.hashCode((int[])array);
        } else if (array instanceof long[]) {
            hashCode = Arrays.hashCode((long[])array);
        } else if (array instanceof float[]) {
            hashCode = Arrays.hashCode((float[])array);
        } else if (array instanceof double[]) {
            hashCode = Arrays.hashCode((double[])array);
        } else if (array instanceof boolean[]) {
            hashCode = Arrays.hashCode((boolean[])array);
        } else if (array instanceof char[]) {
            hashCode = Arrays.hashCode((char[])array);
        } else if (array instanceof Object[]) {
            hashCode = Arrays.hashCode((Object[])array);
        } else {
            throw new IllegalArgumentException("value provided is not array, class: " + array.getClass().getCanonicalName());
        }
        return hashCode;
    }

    static boolean equals(Object array1, Object array2) {
        boolean equal = false;
        if (array1 == array2) {
            equal = true;
        } else if (array1 != null && array2 != null && array1.getClass().equals(array2.getClass())) {
            if (array1 instanceof byte[] && array2 instanceof byte[]) {
                equal = Arrays.equals((byte[])array1, (byte[])array2);
            } else if (array1 instanceof short[] && array2 instanceof short[]) {
                equal = Arrays.equals((short[])array1, (short[])array2);
            } else if (array1 instanceof int[] && array2 instanceof int[]) {
                equal = Arrays.equals((int[])array1, (int[])array2);
            } else if (array1 instanceof long[] && array2 instanceof long[]) {
                equal = Arrays.equals((long[])array1, (long[])array2);
            } else if (array1 instanceof float[] && array2 instanceof float[]) {
                equal = Arrays.equals((float[])array1, (float[])array2);
            } else if (array1 instanceof double[] && array2 instanceof double[]) {
                equal = Arrays.equals((double[])array1, (double[])array2);
            } else if (array1 instanceof boolean[] && array2 instanceof boolean[]) {
                equal = Arrays.equals((boolean[])array1, (boolean[])array2);
            } else if (array1 instanceof char[] && array2 instanceof char[]) {
                equal = Arrays.equals((char[])array1, (char[])array2);
            } else if (array1 instanceof Object[] && array2 instanceof Object[]) {
                equal = Arrays.equals((Object[])array1, (Object[])array2);
            } else {
                throw new IllegalArgumentException("One or more of the values provided are not an array\narray1 class: " + array1.getClass() + "\narray2 class: " + array2.getClass());
            }
        }
        return equal;
    }

    static boolean containsNonDefaultValue(Object array) {
        if (array == null) {
            throw new NullPointerException("array may not be null");
        }
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("value provided is not an array, class: " + array.getClass());
        }
        ArrayContainmentOperation<?> operation = array.getClass().getComponentType().isPrimitive() ? CONTAINMENT_OPERATIONS.get(array.getClass().getComponentType()) : CONTAINMENT_OPERATIONS.get(Object[].class);
        boolean contains = operation.containsNonDefaultValue(array);
        return contains;
    }

    static {
        HashMap<Class<Object>, Object> map = new HashMap<Class<Object>, Object>();
        map.put(Byte.TYPE, Character.valueOf('B'));
        map.put(Short.TYPE, Character.valueOf('S'));
        map.put(Integer.TYPE, Character.valueOf('I'));
        map.put(Long.TYPE, Character.valueOf('J'));
        map.put(Float.TYPE, Character.valueOf('F'));
        map.put(Double.TYPE, Character.valueOf('D'));
        map.put(Boolean.TYPE, Character.valueOf('Z'));
        map.put(Character.TYPE, Character.valueOf('C'));
        PRIMITIVE_TO_BINARY_NAME = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(byte[].class, new ByteArrayContainmentOperation());
        map.put(short[].class, new ShortArrayContainmentOperation());
        map.put(int[].class, new IntArrayContainmentOperation());
        map.put(long[].class, new LongArrayContainmentOperation());
        map.put(float[].class, new FloatArrayContainmentOperation());
        map.put(double[].class, new DoubleArrayContainmentOperation());
        map.put(boolean[].class, new BooleanArrayContainmentOperation());
        map.put(char[].class, new CharArrayContainmentOperation());
        map.put(Object[].class, new ObjectArrayContainmentOperation());
        CONTAINMENT_OPERATIONS = Collections.unmodifiableMap(map);
    }

    private static class ObjectArrayContainmentOperation
    implements ArrayContainmentOperation<Object[]> {
        private static final Object DEFAULT_VAL = null;

        private ObjectArrayContainmentOperation() {
        }

        @Override
        public boolean containsNonDefaultValue(Object[] array) {
            boolean contains = false;
            for (Object val : array) {
                if (val == DEFAULT_VAL) continue;
                contains = true;
                break;
            }
            return contains;
        }
    }

    private static class CharArrayContainmentOperation
    implements ArrayContainmentOperation<char[]> {
        private static final char DEFAULT_VAL = '\u0000';

        private CharArrayContainmentOperation() {
        }

        @Override
        public boolean containsNonDefaultValue(char[] array) {
            boolean contains = false;
            for (char val : array) {
                if (val == '\u0000') continue;
                contains = true;
                break;
            }
            return contains;
        }
    }

    private static class BooleanArrayContainmentOperation
    implements ArrayContainmentOperation<boolean[]> {
        private static final boolean DEFAULT_VAL = false;

        private BooleanArrayContainmentOperation() {
        }

        @Override
        public boolean containsNonDefaultValue(boolean[] array) {
            boolean contains = false;
            for (boolean val : array) {
                if (!val) continue;
                contains = true;
                break;
            }
            return contains;
        }
    }

    private static class DoubleArrayContainmentOperation
    implements ArrayContainmentOperation<double[]> {
        private static final double DEFAULT_VAL = 0.0;

        private DoubleArrayContainmentOperation() {
        }

        @Override
        public boolean containsNonDefaultValue(double[] array) {
            boolean contains = false;
            for (double val : array) {
                if (val == 0.0) continue;
                contains = true;
                break;
            }
            return contains;
        }
    }

    private static class FloatArrayContainmentOperation
    implements ArrayContainmentOperation<float[]> {
        private static final float DEFAULT_VAL = 0.0f;

        private FloatArrayContainmentOperation() {
        }

        @Override
        public boolean containsNonDefaultValue(float[] array) {
            boolean contains = false;
            for (float val : array) {
                if (val == 0.0f) continue;
                contains = true;
                break;
            }
            return contains;
        }
    }

    private static class LongArrayContainmentOperation
    implements ArrayContainmentOperation<long[]> {
        private static final long DEFAULT_VAL = 0L;

        private LongArrayContainmentOperation() {
        }

        @Override
        public boolean containsNonDefaultValue(long[] array) {
            boolean contains = false;
            for (long val : array) {
                if (val == 0L) continue;
                contains = true;
                break;
            }
            return contains;
        }
    }

    private static class IntArrayContainmentOperation
    implements ArrayContainmentOperation<int[]> {
        private static final int DEFAULT_VAL = 0;

        private IntArrayContainmentOperation() {
        }

        @Override
        public boolean containsNonDefaultValue(int[] array) {
            boolean contains = false;
            for (int val : array) {
                if (val == 0) continue;
                contains = true;
                break;
            }
            return contains;
        }
    }

    private static class ShortArrayContainmentOperation
    implements ArrayContainmentOperation<short[]> {
        private static final short DEFAULT_VAL = 0;

        private ShortArrayContainmentOperation() {
        }

        @Override
        public boolean containsNonDefaultValue(short[] array) {
            boolean contains = false;
            for (short val : array) {
                if (val == 0) continue;
                contains = true;
                break;
            }
            return contains;
        }
    }

    private static class ByteArrayContainmentOperation
    implements ArrayContainmentOperation<byte[]> {
        private static final byte DEFAULT_VAL = 0;

        private ByteArrayContainmentOperation() {
        }

        @Override
        public boolean containsNonDefaultValue(byte[] array) {
            boolean contains = false;
            for (byte val : array) {
                if (val == 0) continue;
                contains = true;
                break;
            }
            return contains;
        }
    }

    private static interface ArrayContainmentOperation<T> {
        public boolean containsNonDefaultValue(T var1);
    }
}

