/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.link;

import java.lang.reflect.Array;
import java.util.Arrays;
import matlabcontrol.link.ArrayLinearizer;
import matlabcontrol.link.ArrayMultidimensionalizer;
import matlabcontrol.link.ArrayUtils;
import matlabcontrol.link.BaseArray;

class FullArray<L, T>
extends BaseArray<L, T> {
    final int[] _dimensions;
    private final int _numberOfElements;
    final Class<?> _baseComponentType;
    final Class<L> _linearArrayType;
    final Class<T> _outputArrayType;
    final L _real;
    final L _imag;
    private Boolean _hasImaginaryValues = null;
    private Integer _hashCode = null;

    FullArray(Class<L> linearArrayType, L real, L imag, int[] dimensions) {
        this._dimensions = dimensions;
        this._numberOfElements = ArrayUtils.getNumberOfElements(this._dimensions);
        this._real = linearArrayType.cast(real);
        this._imag = linearArrayType.cast(imag);
        this._baseComponentType = linearArrayType.getComponentType();
        this._linearArrayType = linearArrayType;
        this._outputArrayType = ArrayUtils.getArrayClass(this._baseComponentType, dimensions.length);
    }

    FullArray(Class<L> linearArrayType, T real, T imag) {
        if (real == null) {
            throw new NullPointerException("Real array may not be null");
        }
        this._baseComponentType = linearArrayType.getComponentType();
        this._linearArrayType = linearArrayType;
        this._outputArrayType = real.getClass();
        Class<?> realClass = real.getClass();
        if (!realClass.isArray()) {
            throw new IllegalArgumentException("Real array is not an array, type: " + realClass.getCanonicalName());
        }
        Class<?> realBaseComponentType = ArrayUtils.getBaseComponentType(realClass);
        if (!realBaseComponentType.equals(this._baseComponentType)) {
            throw new IllegalArgumentException("Real array is not an array of the required class\nRequired base component type: " + this._baseComponentType.getCanonicalName() + "\nProvided base component type: " + realBaseComponentType.getCanonicalName());
        }
        if (imag != null && !imag.getClass().equals(realClass)) {
            throw new IllegalArgumentException("Imaginary array is not of the same class as the real array\nReal array class: " + realClass.getCanonicalName() + "\nImaginary array class: " + imag.getClass().getCanonicalName());
        }
        this._dimensions = new int[ArrayUtils.getNumberOfDimensions(this._outputArrayType)];
        int[] realDimensions = ArrayUtils.computeBoundingDimensions(real);
        for (int i = 0; i < realDimensions.length; ++i) {
            this._dimensions[i] = Math.max(this._dimensions[i], realDimensions[i]);
        }
        if (imag != null) {
            int[] imagDimensions = ArrayUtils.computeBoundingDimensions(imag);
            for (int i = 0; i < imagDimensions.length; ++i) {
                this._dimensions[i] = Math.max(this._dimensions[i], imagDimensions[i]);
            }
        }
        this._numberOfElements = ArrayUtils.getNumberOfElements(this._dimensions);
        this._real = this._linearArrayType.cast(ArrayLinearizer.linearize(real, this._dimensions));
        if (imag != null) {
            this._imag = this._linearArrayType.cast(ArrayLinearizer.linearize(imag, this._dimensions));
        } else {
            this._imag = null;
            this._hasImaginaryValues = false;
        }
    }

    @Override
    int getNumberOfElements() {
        return this._numberOfElements;
    }

    @Override
    int getLengthOfDimension(int dimension) {
        if (dimension >= this._dimensions.length || dimension < 0) {
            throw new IllegalArgumentException(dimension + " is not a dimension of this array. This array has " + this.getNumberOfDimensions() + " dimensions");
        }
        return this._dimensions[dimension];
    }

    @Override
    int getNumberOfDimensions() {
        return this._dimensions.length;
    }

    @Override
    boolean isReal() {
        if (this._hasImaginaryValues == null) {
            this._hasImaginaryValues = ArrayUtils.containsNonDefaultValue(this._imag);
        }
        return this._hasImaginaryValues == false;
    }

    @Override
    T toRealArray() {
        return this._outputArrayType.cast(ArrayMultidimensionalizer.multidimensionalize(this._real, this._dimensions));
    }

    @Override
    T toImaginaryArray() {
        T array = this.isReal() ? this._outputArrayType.cast(Array.newInstance(this._baseComponentType, this._dimensions)) : this._outputArrayType.cast(ArrayMultidimensionalizer.multidimensionalize(this._imag, this._dimensions));
        return array;
    }

    @Override
    boolean isSparse() {
        return false;
    }

    int getLinearIndex(int row, int column) {
        return ArrayUtils.checkedMultidimensionalIndicesToLinearIndex(this._dimensions, row, column);
    }

    int getLinearIndex(int row, int column, int page) {
        return ArrayUtils.checkedMultidimensionalIndicesToLinearIndex(this._dimensions, row, column, page);
    }

    int getLinearIndex(int row, int column, int[] pages) {
        return ArrayUtils.checkedMultidimensionalIndicesToLinearIndex(this._dimensions, row, column, pages);
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (this == obj) {
            equal = true;
        } else if (obj != null && this.getClass().equals(obj.getClass())) {
            FullArray other = (FullArray)obj;
            if (this.hashCode() == other.hashCode() && this._baseComponentType.equals(other._baseComponentType) && (this.isReal() && other.isReal() || !this.isReal() && !other.isReal()) && Arrays.equals(this._dimensions, other._dimensions)) {
                equal = ArrayUtils.equals(this._real, other._real) && ArrayUtils.equals(this._imag, other._imag);
            }
        }
        return equal;
    }

    public int hashCode() {
        if (this._hashCode == null) {
            int hashCode = 7;
            hashCode = 97 * hashCode + this._baseComponentType.hashCode();
            hashCode = 97 * hashCode + ArrayUtils.hashCode(this._real);
            hashCode = 97 * hashCode + ArrayUtils.hashCode(this._imag);
            hashCode = 97 * hashCode + Arrays.hashCode(this._dimensions);
            this._hashCode = hashCode;
        }
        return this._hashCode;
    }
}

