/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.link;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import matlabcontrol.MatlabInvocationException;
import matlabcontrol.MatlabOperations;
import matlabcontrol.MatlabProxy;
import matlabcontrol.link.ArrayLinearizer;
import matlabcontrol.link.ArrayMultidimensionalizer;
import matlabcontrol.link.ClassInfo;
import matlabcontrol.link.InvocationInfo;
import matlabcontrol.link.LinkingException;
import matlabcontrol.link.MatlabFunction;
import matlabcontrol.link.MatlabFunctionHandle;
import matlabcontrol.link.MatlabNumber;
import matlabcontrol.link.MatlabNumberArray;
import matlabcontrol.link.MatlabReturns;
import matlabcontrol.link.MatlabType;
import matlabcontrol.link.MatlabVariable;
import matlabcontrol.link.UnassignableReturnException;
import matlabcontrol.link.UnsupportedReturnException;

public class Linker {
    private Linker() {
    }

    static MatlabOperations getLinkedMatlabOperations(MatlabProxy proxy) {
        if (proxy == null) {
            throw new NullPointerException("proxy may not be null");
        }
        Class<MatlabOperations> opsClass = MatlabOperations.class;
        MatlabOperations operations = (MatlabOperations)Proxy.newProxyInstance(opsClass.getClassLoader(), new Class[]{opsClass}, (InvocationHandler)new MatlabFunctionInvocationHandler(proxy, opsClass, new ConcurrentHashMap()));
        return operations;
    }

    public static <T> T link(Class<T> functionInterface, MatlabProxy proxy) {
        if (!functionInterface.isInterface()) {
            throw new LinkingException(functionInterface.getCanonicalName() + " is not an interface");
        }
        if (proxy == null) {
            throw new NullPointerException("proxy may not be null");
        }
        ConcurrentHashMap<Method, InvocationInfo> resolvedInfo = new ConcurrentHashMap<Method, InvocationInfo>();
        for (Method method : functionInterface.getMethods()) {
            MatlabFunction annotation = method.getAnnotation(MatlabFunction.class);
            if (annotation == null) {
                throw new LinkingException(method + " is not annotated with " + MatlabFunction.class.getCanonicalName());
            }
            Linker.checkExceptions(method);
            resolvedInfo.put(method, InvocationInfo.getInvocationInfo(method, annotation));
        }
        Object functionProxy = Proxy.newProxyInstance(functionInterface.getClassLoader(), new Class[]{functionInterface}, (InvocationHandler)new MatlabFunctionInvocationHandler(proxy, functionInterface, resolvedInfo));
        return (T)functionProxy;
    }

    private static void checkExceptions(Method method) {
        Type[] genericExceptions;
        boolean assignable = false;
        for (Type exception : genericExceptions = method.getGenericExceptionTypes()) {
            if (!(exception instanceof Class) || !((Class)exception).isAssignableFrom(MatlabInvocationException.class)) continue;
            assignable = true;
        }
        if (!assignable) {
            throw new LinkingException(method + " is not capable of throwing " + MatlabInvocationException.class.getCanonicalName() + " or does so with generics");
        }
    }

    private static class CustomFunctionInvocation
    implements MatlabProxy.MatlabThreadCallable<FunctionResult>,
    Serializable {
        private static final long serialVersionUID = -7108052527648813829L;
        private final InvocationInfo _functionInfo;
        private final Object[] _args;
        private static final Map<String, Class<?>> MATLAB_TO_JAVA_PRIMITIVE;

        private CustomFunctionInvocation(InvocationInfo functionInfo, Object[] args) {
            this._functionInfo = functionInfo;
            this._args = args;
        }

        @Override
        public FunctionResult call(MatlabProxy.MatlabThreadProxy proxy) throws MatlabInvocationException {
            FunctionResult result;
            try {
                result = new FunctionResult(this.invoke(proxy));
            }
            catch (RuntimeException e) {
                result = new FunctionResult(e);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Object[] invoke(MatlabOperations ops) throws MatlabInvocationException {
            String initialDir = null;
            if (this._functionInfo.containingDirectory != null) {
                initialDir = (String)ops.returningFeval("pwd", 1, new Object[0])[0];
                if (initialDir.equals(this._functionInfo.containingDirectory)) {
                    initialDir = null;
                } else {
                    ops.feval("cd", this._functionInfo.containingDirectory);
                }
            }
            ArrayList<String> variablesToClear = new ArrayList<String>();
            StringBuilder functionStr = new StringBuilder();
            functionStr.append(this._functionInfo.name + "(");
            List<String> parameterNames = this.generateNames(ops, "param_", this._args.length);
            for (int i = 0; i < this._args.length; ++i) {
                String name = parameterNames.get(i);
                variablesToClear.add(name);
                CustomFunctionInvocation.setReturnValue(ops, name, this._args[i]);
                functionStr.append(name);
                if (i == this._args.length - 1) continue;
                functionStr.append(", ");
            }
            functionStr.append(");");
            List<String> returnNames = null;
            if (this._functionInfo.returnTypes.length != 0) {
                returnNames = this.generateNames(ops, "return_", this._functionInfo.returnTypes.length);
                StringBuilder returnStr = new StringBuilder();
                returnStr.append("[");
                for (int i = 0; i < returnNames.size(); ++i) {
                    String name;
                    ClassInfo returnInfo = ClassInfo.getInfo(this._functionInfo.returnTypes[i]);
                    if (returnInfo.isVoid) {
                        name = "~";
                    } else {
                        name = returnNames.get(i);
                        variablesToClear.add(name);
                    }
                    returnStr.append(name);
                    if (i == returnNames.size() - 1) continue;
                    returnStr.append(", ");
                }
                returnStr.append("] = ");
                functionStr.insert(0, returnStr);
            }
            ops.eval(functionStr.toString());
            ArrayList<String> variablesToKeep = new ArrayList<String>();
            Object[] returnValues = new Object[this._functionInfo.returnTypes.length];
            for (int i = 0; i < returnValues.length; ++i) {
                ClassInfo returnInfo = ClassInfo.getInfo(this._functionInfo.returnTypes[i]);
                if (returnInfo.isVoid) {
                    returnValues[i] = null;
                    continue;
                }
                if (this._functionInfo.returnTypes[i].equals(MatlabVariable.class)) {
                    MatlabVariable.MatlabVariableGetter getter = new MatlabVariable.MatlabVariableGetter();
                    getter.getInMatlab(ops, returnNames.get(i));
                    returnValues[i] = getter;
                    variablesToKeep.add(returnNames.get(i));
                    continue;
                }
                returnValues[i] = CustomFunctionInvocation.getReturnValue(ops, returnNames.get(i), returnInfo, this._functionInfo.returnTypeParameters[i], variablesToClear);
            }
            variablesToClear.removeAll(variablesToKeep);
            Object[] objectArray = returnValues;
            try {
                if (!variablesToClear.isEmpty()) {
                    StringBuilder clearCmd = new StringBuilder();
                    clearCmd.append("clear ");
                    for (int i = 0; i < variablesToClear.size(); ++i) {
                        clearCmd.append((String)variablesToClear.get(i));
                        if (i == variablesToClear.size() - 1) continue;
                        clearCmd.append(" ");
                    }
                    ops.eval(clearCmd.toString());
                }
                if (initialDir == null) return objectArray;
            }
            catch (Throwable throwable) {
                if (initialDir == null) throw throwable;
                ops.feval("cd", initialDir);
                throw throwable;
            }
            ops.feval("cd", initialDir);
            return objectArray;
            catch (Throwable throwable) {
                try {
                    if (!variablesToClear.isEmpty()) {
                        StringBuilder clearCmd = new StringBuilder();
                        clearCmd.append("clear ");
                        for (int i = 0; i < variablesToClear.size(); ++i) {
                            clearCmd.append((String)variablesToClear.get(i));
                            if (i == variablesToClear.size() - 1) continue;
                            clearCmd.append(" ");
                        }
                        ops.eval(clearCmd.toString());
                    }
                    if (initialDir == null) throw throwable;
                }
                catch (Throwable throwable2) {
                    if (initialDir == null) throw throwable2;
                    ops.feval("cd", initialDir);
                    throw throwable2;
                }
                ops.feval("cd", initialDir);
                throw throwable;
            }
        }

        private static void setReturnValue(MatlabOperations ops, String name, Object arg) throws MatlabInvocationException {
            if (arg == null) {
                ops.eval(name + " = [];");
            } else if (arg instanceof MatlabType.MatlabTypeSetter) {
                ((MatlabType.MatlabTypeSetter)arg).setInMatlab(ops, name);
            } else if (ClassInfo.getInfo(arg.getClass()).isBuiltinNumeric) {
                Number number = (Number)arg;
                if (number instanceof Byte) {
                    ops.eval(name + "=int8(" + number.byteValue() + ");");
                } else if (number instanceof Short) {
                    ops.eval(name + "=int16(" + number.shortValue() + ");");
                } else if (number instanceof Integer) {
                    ops.eval(name + "=int32(" + number.intValue() + ");");
                } else if (number instanceof Long) {
                    ops.eval(name + "=int64(" + number.longValue() + ");");
                } else if (number instanceof Float) {
                    ops.setVariable(name, new float[]{number.floatValue()});
                } else if (number instanceof Double) {
                    ops.setVariable(name, new double[]{number.doubleValue()});
                }
            } else {
                MatlabValueSetter.setInMatlab(ops, name, arg);
            }
        }

        private static Object getReturnValue(MatlabOperations ops, String returnName, ClassInfo returnInfo, Class<?>[] returnParams, List<String> variablesToClear) throws MatlabInvocationException {
            Object returnValue;
            if (CustomFunctionInvocation.isFoo(ops, "isempty", returnName)) {
                returnValue = null;
            } else if (CustomFunctionInvocation.isFoo(ops, "isjava", returnName)) {
                returnValue = MatlabValueReceiver.receiveValue(ops, variablesToClear, returnName);
            } else {
                String type = (String)ops.returningEval("class(" + returnName + ");", 1)[0];
                if (type.equals("function_handle")) {
                    MatlabFunctionHandle.MatlabFunctionHandleGetter getter = new MatlabFunctionHandle.MatlabFunctionHandleGetter();
                    getter.getInMatlab(ops, returnName);
                    returnValue = getter;
                } else if (MATLAB_TO_JAVA_PRIMITIVE.containsKey(type)) {
                    ArrayMultidimensionalizer.PrimitiveArrayGetter getter;
                    boolean isScalar = CustomFunctionInvocation.isFoo(ops, "isscalar", returnName);
                    boolean keepLinear = false;
                    if (!isScalar) {
                        if (MatlabNumberArray.class.isAssignableFrom(returnInfo.describedClass)) {
                            ClassInfo returnParamInfo = ClassInfo.getInfo(returnParams[0]);
                            keepLinear = returnParamInfo.arrayDimensions == 1 && CustomFunctionInvocation.isFoo(ops, "isvector", returnName);
                        } else {
                            boolean bl = keepLinear = returnInfo.arrayDimensions == 1 && CustomFunctionInvocation.isFoo(ops, "isvector", returnName);
                        }
                    }
                    if (type.equals("logical")) {
                        if (isScalar) {
                            returnValue = MatlabValueReceiver.receiveValue(ops, variablesToClear, returnName);
                        } else {
                            getter = new ArrayMultidimensionalizer.PrimitiveArrayGetter(true, keepLinear);
                            getter.getInMatlab(ops, returnName);
                            returnValue = getter;
                        }
                    } else if (type.equals("char")) {
                        if (Character.TYPE.equals(returnInfo.describedClass) || Character.class.equals(returnInfo.describedClass) || Character.TYPE.equals(returnInfo.baseComponentType)) {
                            if (isScalar) {
                                returnValue = MatlabValueReceiver.receiveValue(ops, variablesToClear, returnName);
                            } else {
                                getter = new ArrayMultidimensionalizer.PrimitiveArrayGetter(true, keepLinear);
                                getter.getInMatlab(ops, returnName);
                                returnValue = getter;
                            }
                        } else {
                            returnValue = MatlabValueReceiver.receiveValue(ops, variablesToClear, returnName);
                        }
                    } else {
                        boolean isReal = CustomFunctionInvocation.isFoo(ops, "isreal", returnName);
                        if (isScalar) {
                            if (isReal && returnInfo.isBuiltinNumeric) {
                                returnValue = MatlabValueReceiver.receiveValue(ops, variablesToClear, returnName);
                            } else {
                                MatlabNumber.MatlabNumberGetter getter2 = new MatlabNumber.MatlabNumberGetter();
                                getter2.getInMatlab(ops, returnName);
                                returnValue = getter2;
                            }
                        } else if (isReal && returnInfo.isArray && returnInfo.baseComponentType.isPrimitive() && ClassInfo.getInfo(returnInfo.baseComponentType).isBuiltinNumeric) {
                            ArrayMultidimensionalizer.PrimitiveArrayGetter getter3 = new ArrayMultidimensionalizer.PrimitiveArrayGetter(true, keepLinear);
                            getter3.getInMatlab(ops, returnName);
                            returnValue = getter3;
                        } else {
                            MatlabNumberArray.MatlabNumberArrayGetter getter4 = new MatlabNumberArray.MatlabNumberArrayGetter(keepLinear);
                            getter4.getInMatlab(ops, returnName);
                            returnValue = getter4;
                        }
                    }
                } else {
                    throw new UnsupportedReturnException("Unsupported MATLAB type: " + type);
                }
            }
            return returnValue;
        }

        private static boolean isFoo(MatlabOperations ops, String function, String var) throws MatlabInvocationException {
            return ((boolean[])ops.returningEval(function + "(" + var + ");", 1)[0])[0];
        }

        private List<String> generateNames(MatlabOperations ops, String root, int amount) throws MatlabInvocationException {
            HashSet<String> takenNames = new HashSet<String>(Arrays.asList((String[])ops.returningEval("who", 1)[0]));
            ArrayList<String> generatedNames = new ArrayList<String>();
            int genSequenence = 0;
            while (generatedNames.size() != amount) {
                String generatedName = root + genSequenence;
                while (takenNames.contains(generatedName)) {
                    generatedName = root + ++genSequenence;
                }
                ++genSequenence;
                generatedNames.add(generatedName);
            }
            return generatedNames;
        }

        static {
            HashMap<String, Class<Serializable>> map = new HashMap<String, Class<Serializable>>();
            map.put("int8", Byte.TYPE);
            map.put("int16", Short.TYPE);
            map.put("int32", Integer.TYPE);
            map.put("int64", Long.TYPE);
            map.put("single", Float.TYPE);
            map.put("double", Double.TYPE);
            map.put("logical", Boolean.TYPE);
            map.put("char", Character.TYPE);
            MATLAB_TO_JAVA_PRIMITIVE = Collections.unmodifiableMap(map);
        }

        private static class MatlabValueReceiver {
            private Object _value = null;

            private MatlabValueReceiver() {
            }

            private static Object receiveValue(MatlabOperations ops, List<String> variablesToClear, String variableName) throws MatlabInvocationException {
                String receiverName = (String)ops.returningEval("genvarname('receiver_', who);", 1)[0];
                MatlabValueReceiver receiver = new MatlabValueReceiver();
                ops.setVariable(receiverName, receiver);
                variablesToClear.add(receiverName);
                ops.eval(receiverName + ".set(" + variableName + ");");
                return receiver._value;
            }

            public void set(Object val) {
                this._value = val;
            }
        }

        private static class MatlabValueSetter {
            private final Object _value;

            private static void setInMatlab(MatlabOperations ops, String variableName, Object value) throws MatlabInvocationException {
                MatlabValueSetter setter = new MatlabValueSetter(value);
                ops.setVariable(variableName, setter);
                ops.eval(variableName + " = " + variableName + ".getValue();");
            }

            private MatlabValueSetter(Object value) {
                this._value = value;
            }

            public Object getValue() {
                return this._value;
            }
        }
    }

    private static class FunctionResult
    implements Serializable {
        private static final long serialVersionUID = -5636384730122824487L;
        private final Object[] returnArgs;
        private final RuntimeException thrownException;

        FunctionResult(Object[] returnArgs) {
            this.returnArgs = returnArgs;
            this.thrownException = null;
        }

        FunctionResult(RuntimeException thrownException) {
            this.returnArgs = null;
            this.thrownException = thrownException;
        }
    }

    private static class MatlabFunctionInvocationHandler
    implements InvocationHandler {
        private final MatlabProxy _proxy;
        private final Class<?> _interface;
        private final ConcurrentMap<Method, InvocationInfo> _invocationsInfo;
        private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_AUTOBOXED;

        private MatlabFunctionInvocationHandler(MatlabProxy proxy, Class<?> functionInterface, ConcurrentMap<Method, InvocationInfo> invocationInfo) {
            this._proxy = proxy;
            this._interface = functionInterface;
            this._invocationsInfo = invocationInfo;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] args) throws MatlabInvocationException {
            Object result = method.getDeclaringClass().equals(Object.class) ? this.invokeObjectMethod(method, args) : (method.getDeclaringClass().equals(MatlabOperations.class) ? this.invokeMatlabOperationsMethod(method, args) : this.invokeUserInterfaceMethod(method, args));
            return result;
        }

        private Object invokeObjectMethod(Method method, Object[] args) {
            Object result;
            if (method.getName().equals("toString")) {
                result = "[Linked " + this._interface.getCanonicalName() + " info=" + this._invocationsInfo + "]";
            } else if (method.getName().equals("equals")) {
                Object other = args[0];
                if (other != null && Proxy.isProxyClass(other.getClass()) && Proxy.getInvocationHandler(other) instanceof MatlabFunctionInvocationHandler) {
                    InvocationHandler handler = Proxy.getInvocationHandler(other);
                    result = this._interface.equals(((MatlabFunctionInvocationHandler)handler)._interface);
                } else {
                    result = false;
                }
            } else if (method.getName().equals("hashCode")) {
                result = this._interface.hashCode();
            } else {
                throw new UnsupportedOperationException(method + " not supported");
            }
            return result;
        }

        private Object invokeMatlabOperationsMethod(Method method, Object[] args) throws MatlabInvocationException {
            Object result;
            Class<?> methodReturn = method.getReturnType();
            if (method.getName().equals("eval")) {
                InvocationInfo info = new InvocationInfo("eval", null, new Class[0], new Class[0][0]);
                result = this.invokeMatlabFunction(info, false, args, methodReturn);
            } else if (method.getName().equals("returningEval")) {
                int nargout = (Integer)args[1];
                Object[] returnTypes = new Class[nargout];
                Arrays.fill(returnTypes, Object.class);
                InvocationInfo info = new InvocationInfo("eval", null, (Class<?>[])returnTypes, new Class[nargout][0]);
                result = this.invokeMatlabFunction(info, false, new Object[]{args[0]}, methodReturn);
            } else if (method.getName().equals("feval")) {
                Object[] functionArgs = (Object[])args[1];
                Object[] firstLevelArgs = new Object[functionArgs.length + 1];
                firstLevelArgs[0] = args[0];
                System.arraycopy(functionArgs, 0, firstLevelArgs, 1, functionArgs.length);
                InvocationInfo info = new InvocationInfo("feval", null, new Class[0], new Class[0][0]);
                result = this.invokeMatlabFunction(info, false, firstLevelArgs, methodReturn);
            } else if (method.getName().equals("returningFeval")) {
                Object[] functionArgs = (Object[])args[2];
                Object[] firstLevelArgs = new Object[functionArgs.length + 1];
                firstLevelArgs[0] = args[0];
                System.arraycopy(functionArgs, 0, firstLevelArgs, 1, functionArgs.length);
                int nargout = (Integer)args[1];
                Object[] returnTypes = new Class[nargout];
                Arrays.fill(returnTypes, Object.class);
                InvocationInfo info = new InvocationInfo("feval", null, (Class<?>[])returnTypes, new Class[nargout][0]);
                result = this.invokeMatlabFunction(info, false, firstLevelArgs, methodReturn);
            } else if (method.getName().equals("getVariable")) {
                InvocationInfo info = new InvocationInfo("eval", null, new Class[]{Object.class}, new Class[1][0]);
                result = ((Object[])this.invokeMatlabFunction(info, false, args, methodReturn))[0];
            } else if (method.getName().equals("setVariable")) {
                InvocationInfo info = new InvocationInfo("assignin", null, new Class[0], new Class[0][0]);
                result = this.invokeMatlabFunction(info, false, new Object[]{"base", args[0], args[1]}, methodReturn);
            } else {
                throw new UnsupportedOperationException(method + " not supported");
            }
            return result;
        }

        private Object invokeUserInterfaceMethod(Method method, Object[] args) throws MatlabInvocationException {
            Object varArgs;
            InvocationInfo info = (InvocationInfo)this._invocationsInfo.get(method);
            if (args == null) {
                args = new Object[]{};
            }
            if (method.isVarArgs() && args.length > 0 && (varArgs = args[args.length - 1]).getClass().isArray()) {
                int varArgLength = Array.getLength(varArgs);
                Object[] allArgs = new Object[args.length + varArgLength - 1];
                System.arraycopy(args, 0, allArgs, 0, args.length - 1);
                for (int i = 0; i < varArgLength; ++i) {
                    Object arg;
                    allArgs[i + args.length - 1] = arg = Array.get(varArgs, i);
                }
                args = allArgs;
            }
            return this.invokeMatlabFunction(info, true, args, method.getReturnType());
        }

        private Object invokeMatlabFunction(InvocationInfo info, boolean userDefined, Object[] args, Class<?> methodReturn) throws MatlabInvocationException {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                ClassInfo argInfo = ClassInfo.getInfo(args[i].getClass());
                if (argInfo.isMatlabType) {
                    args[i] = ((MatlabType)args[i]).getSetter();
                    continue;
                }
                if (!argInfo.isPrimitiveArray) continue;
                args[i] = ArrayLinearizer.getSetter(args[i]);
            }
            FunctionResult result = this._proxy.invokeAndWait(new CustomFunctionInvocation(info, args));
            if (result.thrownException != null) {
                result.thrownException.fillInStackTrace();
                throw result.thrownException;
            }
            Object[] returnValues = result.returnArgs;
            for (int i = 0; i < returnValues.length; ++i) {
                if (!(returnValues[i] instanceof MatlabType.MatlabTypeGetter)) continue;
                returnValues[i] = ((MatlabType.MatlabTypeGetter)returnValues[i]).retrieve();
            }
            Object toReturn = userDefined ? this.processReturnValues(info, returnValues, methodReturn) : returnValues;
            return toReturn;
        }

        private Object processReturnValues(InvocationInfo info, Object[] result, Class<?> methodReturn) {
            Object toReturn;
            if (result.length == 0) {
                toReturn = result;
            } else if (result.length == 1) {
                toReturn = this.validateAssignability(result[0], info.returnTypes[0], info.returnTypeParameters[0]);
            } else {
                for (int i = 0; i < result.length; ++i) {
                    result[i] = this.validateAssignability(result[i], info.returnTypes[i], info.returnTypeParameters[0]);
                }
                toReturn = MatlabReturns.getMaxReturn(result);
            }
            return toReturn;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Object validateAssignability(Object value, Class<?> returnType, Class<?>[] returnTypeParameters) {
            if (value == null) {
                if (!returnType.isPrimitive()) return null;
                throw new UnassignableReturnException("Return type is primitive and cannot be assigned null\nReturn type: " + MatlabFunctionInvocationHandler.toClassString(returnType, returnTypeParameters));
            }
            if (returnType.isPrimitive()) {
                Class<?> autoboxedClass = PRIMITIVE_TO_AUTOBOXED.get(returnType);
                if (!autoboxedClass.equals(value.getClass())) throw new UnassignableReturnException("Return type cannot be assigned the value returned\nReturn type: " + MatlabFunctionInvocationHandler.toClassString(returnType, returnTypeParameters) + "\nValue type:  " + MatlabFunctionInvocationHandler.toClassString(value));
                return value;
            }
            if (!returnType.isAssignableFrom(value.getClass())) {
                throw new UnassignableReturnException("Return type cannot be assigned the value returned\nReturn type: " + MatlabFunctionInvocationHandler.toClassString(returnType, returnTypeParameters) + "\nValue type:  " + MatlabFunctionInvocationHandler.toClassString(value));
            }
            if (!MatlabNumberArray.class.isAssignableFrom(returnType)) return value;
            if (((MatlabNumberArray)value).getOutputArrayType().equals(returnTypeParameters[0])) return value;
            throw new UnassignableReturnException("Return type cannot be assigned the value returned\nReturn type: " + MatlabFunctionInvocationHandler.toClassString(returnType, returnTypeParameters) + "\nValue type:  " + MatlabFunctionInvocationHandler.toClassString(value));
        }

        private static String toClassString(Class<?> returnType, Class<?>[] returnTypeParameters) {
            StringBuilder classString = new StringBuilder();
            classString.append(returnType.getCanonicalName());
            if (returnTypeParameters.length != 0) {
                classString.append("<");
                for (int i = 0; i < returnTypeParameters.length; ++i) {
                    classString.append(returnTypeParameters[i].getCanonicalName());
                    if (i == returnTypeParameters.length - 1) continue;
                    classString.append(", ");
                }
                classString.append(">");
            }
            return classString.toString();
        }

        private static String toClassString(Object obj) {
            String classString;
            if (obj == null) {
                classString = "null";
            } else if (MatlabNumberArray.class.isAssignableFrom(obj.getClass())) {
                MatlabNumberArray array = (MatlabNumberArray)obj;
                classString = array.getClass().getCanonicalName() + "<" + array.getOutputArrayType().getCanonicalName() + ">";
            } else {
                classString = obj.getClass().getCanonicalName();
            }
            return classString;
        }

        static {
            HashMap<Class<Serializable>, Class> map = new HashMap<Class<Serializable>, Class>();
            map.put(Byte.TYPE, Byte.class);
            map.put(Short.TYPE, Short.class);
            map.put(Integer.TYPE, Integer.class);
            map.put(Long.TYPE, Long.class);
            map.put(Double.TYPE, Double.class);
            map.put(Float.TYPE, Float.class);
            map.put(Boolean.TYPE, Boolean.class);
            map.put(Character.TYPE, Character.class);
            PRIMITIVE_TO_AUTOBOXED = Collections.unmodifiableMap(map);
        }
    }
}

