/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.link;

import java.util.HashSet;
import matlabcontrol.MatlabInvocationException;
import matlabcontrol.MatlabOperations;
import matlabcontrol.link.MatlabType;

public final class MatlabFunctionHandle
extends MatlabType {
    private final String _function;

    public MatlabFunctionHandle(String functionName) {
        if (functionName == null) {
            throw new NullPointerException("MATLAB function name may not be null");
        }
        if (functionName.isEmpty()) {
            throw new IllegalArgumentException("Invalid MATLAB function name; may not be an empty String");
        }
        if (functionName.startsWith("@")) {
            MatlabFunctionHandle.checkAnonymousFunction(functionName);
        } else {
            MatlabFunctionHandle.checkFunctionName(functionName);
        }
        this._function = functionName;
    }

    private static void checkAnonymousFunction(String function) {
        char[] functionChars = function.toCharArray();
        if (functionChars.length < 2 || functionChars[1] != '(') {
            throw new IllegalArgumentException("Invalid anonymous MATLAB function: " + function + "\n@ must be followed with (");
        }
        int closingParenIndex = function.indexOf(")");
        if (closingParenIndex == -1) {
            throw new IllegalArgumentException("Invalid anonymous MATLAB function: " + function + "\nMust terminate the argument list with )");
        }
        String argsString = function.substring(2, closingParenIndex);
        String[] args = argsString.isEmpty() ? new String[]{} : argsString.split(", ");
        HashSet<String> seenArgs = new HashSet<String>();
        for (String arg : args) {
            if (seenArgs.contains(arg = arg.trim())) {
                throw new IllegalArgumentException("Invalid anonymous MATLAB function: " + function + "\nInvalid argument name: " + arg + "\nArgument names must be unique");
            }
            seenArgs.add(arg);
            char[] argsChars = arg.toCharArray();
            if (!Character.isLetter(argsChars[0])) {
                throw new IllegalArgumentException("Invalid anonymous MATLAB function: " + function + "\nInvalid argument name: " + arg + "\nArgument must begin with a letter");
            }
            for (char element : argsChars) {
                if (Character.isLetter(element) || Character.isDigit(element) || element == '_') continue;
                throw new IllegalArgumentException("Invalid anonymous MATLAB function: " + function + "\nInvalid argument name: " + arg + "\nArgument must consist only of letters, numbers, and underscores");
            }
        }
        String body = function.substring(closingParenIndex + 1, function.length());
        if (body.trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid anonymous MATLAB function: " + function + "\nAnonymous function must have a body");
        }
    }

    private static void checkFunctionName(String functionName) {
        char[] nameChars = functionName.toCharArray();
        if (!Character.isLetter(nameChars[0])) {
            throw new IllegalArgumentException("Invalid MATLAB function name: " + functionName + "\nFunction name must begin with a letter");
        }
        for (char element : nameChars) {
            if (Character.isLetter(element) || Character.isDigit(element) || element == '_') continue;
            throw new IllegalArgumentException("Invalid MATLAB function name: " + functionName + "\nFunction name must consist only of letters, numbers, and underscores");
        }
    }

    public String toString() {
        return "[" + this.getClass().getName() + " functionName=" + this._function + "]";
    }

    @Override
    MatlabType.MatlabTypeSetter getSetter() {
        return new MatlabFunctionHandlerSetter(this._function);
    }

    static class MatlabFunctionHandleGetter
    implements MatlabType.MatlabTypeGetter<MatlabFunctionHandle> {
        private static final long serialVersionUID = 4448554689248088229L;
        private String _function;
        private boolean _retrieved = false;

        MatlabFunctionHandleGetter() {
        }

        @Override
        public MatlabFunctionHandle retrieve() {
            if (this._retrieved) {
                return new MatlabFunctionHandle(this._function);
            }
            throw new IllegalStateException("MatlabFunctionHandle cannot be deserialized until the data has been retrieved from MATLAB");
        }

        @Override
        public void getInMatlab(MatlabOperations ops, String variableName) throws MatlabInvocationException {
            this._function = (String)ops.returningEval("func2str(" + variableName + ");", 1)[0];
            this._retrieved = true;
        }
    }

    private static class MatlabFunctionHandlerSetter
    implements MatlabType.MatlabTypeSetter {
        private static final long serialVersionUID = 1909686398012439080L;
        private final String _function;

        public MatlabFunctionHandlerSetter(String function) {
            this._function = function;
        }

        @Override
        public void setInMatlab(MatlabOperations ops, String variableName) throws MatlabInvocationException {
            if (this._function.startsWith("@")) {
                ops.eval(variableName + " = " + this._function + ";");
            } else {
                ops.eval(variableName + " = @" + this._function + ";");
            }
        }
    }
}

