/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.link;

import java.util.Arrays;
import matlabcontrol.link.MatlabInt16;
import matlabcontrol.link.MatlabNumberArray;

public class MatlabInt16Array<T>
extends MatlabNumberArray<short[], T> {
    MatlabInt16Array(short[] real, short[] imag, int[] lengths) {
        super(short[].class, real, imag, lengths);
    }

    public static <T> MatlabInt16Array<T> getInstance(T real, T imaginary) {
        return new MatlabInt16Array<T>(real, imaginary);
    }

    private MatlabInt16Array(T real, T imaginary) {
        super(short[].class, real, imaginary);
    }

    public MatlabInt16 getElementAtLinearIndex(int index) {
        return new MatlabInt16(((short[])this._real)[index], this._imag == null ? (short)0 : ((short[])this._imag)[index]);
    }

    public MatlabInt16 getElementAtIndices(int row, int column, int ... pages) {
        int linearIndex = this.getLinearIndex(row, column, pages);
        return new MatlabInt16(((short[])this._real)[linearIndex], this._imag == null ? (short)0 : ((short[])this._imag)[linearIndex]);
    }

    @Override
    boolean equalsRealArray(short[] other) {
        return Arrays.equals((short[])this._real, other);
    }

    @Override
    boolean equalsImaginaryArray(short[] other) {
        return Arrays.equals((short[])this._imag, other);
    }

    @Override
    int hashReal() {
        return Arrays.hashCode((short[])this._real);
    }

    @Override
    int hashImaginary() {
        return Arrays.hashCode((short[])this._imag);
    }

    @Override
    boolean containsNonZero(short[] array) {
        boolean contained = false;
        for (short val : array) {
            if (val == 0) continue;
            contained = true;
            break;
        }
        return contained;
    }
}

