/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.link;

import matlabcontrol.MatlabInvocationException;
import matlabcontrol.MatlabOperations;
import matlabcontrol.link.MatlabType;

public final class MatlabVariable
extends MatlabType {
    private final String _name;

    public MatlabVariable(String name) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Invalid MATLAB variable name: " + name);
        }
        char[] nameChars = name.toCharArray();
        if (!Character.isLetter(nameChars[0])) {
            throw new IllegalArgumentException("Invalid MATLAB variable name: " + name);
        }
        for (char element : nameChars) {
            if (Character.isLetter(element) || Character.isDigit(element) || element == '_') continue;
            throw new IllegalArgumentException("Invalid MATLAB variable name: " + name);
        }
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return "[" + this.getClass().getName() + " name=" + this._name + "]";
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof MatlabVariable) {
            MatlabVariable other = (MatlabVariable)obj;
            equal = other._name.equals(this._name);
        }
        return equal;
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    @Override
    MatlabType.MatlabTypeSetter getSetter() {
        return new MatlabVariableSetter(this._name);
    }

    private static class MatlabVariableSetter
    implements MatlabType.MatlabTypeSetter {
        private static final long serialVersionUID = -2208485477826441076L;
        private final String _name;

        private MatlabVariableSetter(String name) {
            this._name = name;
        }

        @Override
        public void setInMatlab(MatlabOperations ops, String variableName) throws MatlabInvocationException {
            ops.eval(variableName + " = " + this._name + ";");
        }
    }

    static class MatlabVariableGetter
    implements MatlabType.MatlabTypeGetter<MatlabVariable> {
        private static final long serialVersionUID = 7724337165919355824L;
        private String _name;
        private boolean _retrieved;

        MatlabVariableGetter() {
        }

        @Override
        public MatlabVariable retrieve() {
            if (!this._retrieved) {
                throw new IllegalStateException("variable not retrieved");
            }
            return new MatlabVariable(this._name);
        }

        @Override
        public void getInMatlab(MatlabOperations ops, String variableName) throws MatlabInvocationException {
            this._name = variableName;
            this._retrieved = true;
        }
    }
}

