/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.link;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import matlabcontrol.link.ArrayUtils;
import matlabcontrol.link.BaseArray;

class SparseArray<L>
extends BaseArray<L, L[]> {
    private final int[] _linearIndices;
    private final int[] _rowIndices;
    private final int[] _colIndices;
    final L _realValues;
    final L _imagValues;
    private Integer _hashCode = null;
    private final Class<?> _baseComponentType;
    private final Class<L[]> _outputArrayType;
    private final int _numRows;
    private final int _numCols;
    private static final Map<Class<?>, SparseArrayFillOperation<?>> SPARSE_FILL_OPERATIONS;

    SparseArray(Class<L> linearArrayType, int[] linearIndices, int[] rowIndices, int[] colIndices, L real, L imag, int numRows, int numCols) {
        this._numRows = numRows;
        this._numCols = numCols;
        this._baseComponentType = linearArrayType.getComponentType();
        this._outputArrayType = ArrayUtils.getArrayClass(this._baseComponentType, 2);
        this._linearIndices = linearIndices;
        this._rowIndices = rowIndices;
        this._colIndices = colIndices;
        this._realValues = linearArrayType.cast(real);
        this._imagValues = linearArrayType.cast(imag);
    }

    SparseArray(Class<L> linearArrayType, int[] rowIndices, int[] colIndices, L realValues, L imagValues, int numRows, int numCols) {
        SparseArray.validateUserSuppliedParameters(linearArrayType, rowIndices, colIndices, realValues, imagValues);
        this._baseComponentType = linearArrayType.getComponentType();
        this._outputArrayType = ArrayUtils.getArrayClass(this._baseComponentType, 2);
        Map<SparseKey, SparseValue> sparseMap = SparseArray.createSparseMap(linearArrayType, rowIndices, colIndices, realValues, imagValues, numRows, numCols);
        this._numRows = numRows;
        this._numCols = numCols;
        ArrayList<SparseKey> keys = new ArrayList<SparseKey>(sparseMap.keySet());
        Collections.sort(keys);
        this._rowIndices = new int[keys.size()];
        this._colIndices = new int[keys.size()];
        this._linearIndices = new int[keys.size()];
        this._realValues = linearArrayType.cast(Array.newInstance(this._baseComponentType, keys.size()));
        this._imagValues = imagValues == null ? null : linearArrayType.cast(Array.newInstance(this._baseComponentType, keys.size()));
        for (int i = 0; i < keys.size(); ++i) {
            SparseKey key = keys.get(i);
            this._rowIndices[i] = key.row;
            this._colIndices[i] = key.col;
            this._linearIndices[i] = key.linearIndex;
            SparseValue value = sparseMap.get(key);
            SparseArray.setSparseValue(value, this._realValues, this._imagValues, i);
        }
    }

    @Override
    boolean isReal() {
        return this._imagValues == null;
    }

    @Override
    L[] toRealArray() {
        return SparseArray.sparseTo2DArray(this._outputArrayType, this._rowIndices, this._colIndices, this._realValues, this._numRows, this._numCols);
    }

    @Override
    L[] toImaginaryArray() {
        return SparseArray.sparseTo2DArray(this._outputArrayType, this._rowIndices, this._colIndices, this._imagValues, this._numRows, this._numCols);
    }

    private static <L> L[] sparseTo2DArray(Class<L[]> array2DType, int[] rowIndices, int[] colIndices, L values, int numRows, int numCols) {
        Object[] array2D = (Object[])Array.newInstance(array2DType, numRows, numCols);
        if (values != null) {
            SparseArrayFillOperation<?> fillOperation = SPARSE_FILL_OPERATIONS.get(array2DType);
            fillOperation.fill(array2D, values, rowIndices, colIndices);
        }
        return array2D;
    }

    @Override
    int getNumberOfElements() {
        return this._numCols * this._numRows;
    }

    @Override
    int getLengthOfDimension(int dimension) {
        int length;
        if (dimension == 0) {
            length = this._numRows;
        } else if (dimension == 1) {
            length = this._numCols;
        } else {
            throw new IllegalArgumentException(dimension + " is not a dimension of this array. This array has 2 dimensions");
        }
        return length;
    }

    @Override
    int getNumberOfDimensions() {
        return 2;
    }

    @Override
    boolean isSparse() {
        return true;
    }

    int getSparseIndexForLinearIndex(int linearIndex) {
        return Arrays.binarySearch(this._linearIndices, linearIndex);
    }

    int getSparseIndexForIndices(int row, int column) {
        int linearIndex = ArrayUtils.checkedMultidimensionalIndicesToLinearIndex(this._numRows, this._numCols, row, column);
        return Arrays.binarySearch(this._linearIndices, linearIndex);
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (this == obj) {
            equal = true;
        } else if (obj != null && this.getClass().equals(obj.getClass())) {
            SparseArray other = (SparseArray)obj;
            if (this.hashCode() == other.hashCode() && this._baseComponentType.equals(other._baseComponentType) && (this.isReal() && other.isReal() || !this.isReal() && !other.isReal()) && this._numRows == other._numRows && this._numCols == other._numCols && Arrays.equals(this._linearIndices, other._linearIndices)) {
                equal = ArrayUtils.equals(this._realValues, other._realValues) && ArrayUtils.equals(this._imagValues, other._imagValues);
            }
        }
        return equal;
    }

    public int hashCode() {
        if (this._hashCode == null) {
            int hashCode = 7;
            hashCode = 97 * hashCode + this._baseComponentType.hashCode();
            hashCode = 97 * hashCode + Arrays.hashCode(this._linearIndices);
            hashCode = 97 * hashCode + ArrayUtils.hashCode(this._realValues);
            hashCode = 97 * hashCode + ArrayUtils.hashCode(this._imagValues);
            hashCode = 97 * hashCode + this._numRows;
            hashCode = 97 * hashCode + this._numCols;
            this._hashCode = hashCode;
        }
        return this._hashCode;
    }

    private static Map<SparseKey, SparseValue> createSparseMap(Class<?> arrayType, int[] rowIndices, int[] colIndices, Object realValues, Object imagValues, int numRows, int numCols) {
        HashMap<SparseKey, SparseValue> sparseMap = new HashMap<SparseKey, SparseValue>();
        for (int i = 0; i < rowIndices.length; ++i) {
            int row = rowIndices[i];
            int col = colIndices[i];
            if (row >= numRows && col >= numCols) {
                throw new ArrayIndexOutOfBoundsException("row or column index is out of bounds\nrow: " + row + "\ncolumn: " + col + "\nnumRows: " + numRows + "\nnumColumns: " + numCols);
            }
            SparseKey key = new SparseKey(row, col, numRows);
            SparseValue value = SparseArray.getSparseValue(realValues, imagValues, i);
            SparseValue existingValue = sparseMap.get(key);
            if (existingValue != null && (value = SparseArray.addSparseValue(value, existingValue)).isDefaultValue()) {
                sparseMap.remove(key);
            }
            if (value.isDefaultValue()) continue;
            sparseMap.put(key, value);
        }
        return sparseMap;
    }

    private static void validateUserSuppliedParameters(Class<?> linearArrayType, int[] rowIndices, int[] colIndices, Object realValues, Object imagValues) {
        if (rowIndices == null) {
            throw new NullPointerException("rowIndices may not be null");
        }
        if (colIndices == null) {
            throw new NullPointerException("colIndices may not be null");
        }
        if (realValues == null) {
            throw new NullPointerException("realValues may not be null");
        }
        if (rowIndices.length != colIndices.length) {
            throw new IllegalArgumentException("rowIndices and colIndices have differing lengths\nrowIndices length: " + rowIndices.length + "\ncolIndices length: " + colIndices.length);
        }
        int realLength = Array.getLength(realValues);
        if (rowIndices.length != realLength) {
            throw new IllegalArgumentException("indices have differing lengths from the value arrays\nindices length: " + rowIndices.length + "\nvalue arrays length: " + realLength);
        }
        Class<?> realClass = realValues.getClass();
        if (!realClass.isArray()) {
            throw new IllegalArgumentException("realValues is not an array, type: " + realClass.getCanonicalName());
        }
        Class<?> requiredBaseComponentType = linearArrayType.getComponentType();
        Class<?> realBaseComponentType = ArrayUtils.getBaseComponentType(realClass);
        if (!realBaseComponentType.equals(requiredBaseComponentType)) {
            throw new IllegalArgumentException("realValues is not an array of the required class\nRequired base component type: " + requiredBaseComponentType.getCanonicalName() + "\nProvided base component type: " + realBaseComponentType.getCanonicalName());
        }
        if (imagValues != null) {
            if (!imagValues.getClass().equals(realClass)) {
                throw new IllegalArgumentException("imagValues is not of the same class as realValues\nrealValues class: " + realClass.getCanonicalName() + "\nimagValues class: " + imagValues.getClass().getCanonicalName());
            }
            int imagLength = Array.getLength(imagValues);
            if (realLength != imagLength) {
                throw new IllegalArgumentException("realValues and imagValues must be the same length\nrealValues length: " + realLength + "\nimagValues length: " + imagLength);
            }
        }
    }

    private static void setSparseValue(SparseValue value, Object realValues, Object imagValues, int index) {
        if (value instanceof ByteSparseValue) {
            ((byte[])realValues)[index] = ((ByteSparseValue)value).real;
            if (imagValues != null) {
                ((byte[])imagValues)[index] = ((ByteSparseValue)value).imag;
            }
        } else if (value instanceof ShortSparseValue) {
            ((short[])realValues)[index] = ((ShortSparseValue)value).real;
            if (imagValues != null) {
                ((short[])imagValues)[index] = ((ShortSparseValue)value).imag;
            }
        } else if (value instanceof IntSparseValue) {
            ((int[])realValues)[index] = ((IntSparseValue)value).real;
            if (imagValues != null) {
                ((int[])imagValues)[index] = ((IntSparseValue)value).imag;
            }
        } else if (value instanceof LongSparseValue) {
            ((long[])realValues)[index] = ((LongSparseValue)value).real;
            if (imagValues != null) {
                ((long[])imagValues)[index] = ((LongSparseValue)value).imag;
            }
        } else if (value instanceof FloatSparseValue) {
            ((float[])realValues)[index] = ((FloatSparseValue)value).real;
            if (imagValues != null) {
                ((float[])imagValues)[index] = ((FloatSparseValue)value).imag;
            }
        } else if (value instanceof DoubleSparseValue) {
            ((double[])realValues)[index] = ((DoubleSparseValue)value).real;
            if (imagValues != null) {
                ((double[])imagValues)[index] = ((DoubleSparseValue)value).imag;
            }
        } else if (value instanceof CharSparseValue) {
            ((char[])realValues)[index] = ((CharSparseValue)value).value;
        } else if (value instanceof BooleanSparseValue) {
            ((boolean[])realValues)[index] = ((BooleanSparseValue)value).value;
        } else {
            throw new IllegalArgumentException("Unsupported sparse value\nvalue: " + value + "\nrealValues: " + realValues + "\nimagValue: " + imagValues);
        }
    }

    private static SparseValue getSparseValue(Object realValues, Object imagValues, int index) {
        SparseValue value;
        if (realValues instanceof byte[]) {
            byte real = Array.getByte(realValues, index);
            byte imag = imagValues == null ? (byte)0 : Array.getByte(imagValues, index);
            value = new ByteSparseValue(real, imag);
        } else if (realValues instanceof short[]) {
            short real = Array.getShort(realValues, index);
            short imag = imagValues == null ? (short)0 : Array.getShort(imagValues, index);
            value = new ShortSparseValue(real, imag);
        } else if (realValues instanceof int[]) {
            int real = Array.getInt(realValues, index);
            int imag = imagValues == null ? 0 : Array.getInt(imagValues, index);
            value = new IntSparseValue(real, imag);
        } else if (realValues instanceof long[]) {
            long real = Array.getLong(realValues, index);
            long imag = imagValues == null ? 0L : Array.getLong(imagValues, index);
            value = new LongSparseValue(real, imag);
        } else if (realValues instanceof float[]) {
            float real = Array.getFloat(realValues, index);
            float imag = imagValues == null ? 0.0f : Array.getFloat(imagValues, index);
            value = new FloatSparseValue(real, imag);
        } else if (realValues instanceof double[]) {
            double real = Array.getDouble(realValues, index);
            double imag = imagValues == null ? 0.0 : Array.getDouble(imagValues, index);
            value = new DoubleSparseValue(real, imag);
        } else if (realValues instanceof char[]) {
            char charValue = Array.getChar(realValues, index);
            value = new CharSparseValue(charValue);
        } else if (realValues instanceof boolean[]) {
            boolean booleanValue = Array.getBoolean(realValues, index);
            value = new BooleanSparseValue(booleanValue);
        } else {
            throw new IllegalArgumentException("Cannot create sparse value for array of type: " + realValues.getClass());
        }
        return value;
    }

    private static SparseValue addSparseValue(SparseValue value1, SparseValue value2) {
        SparseValue sum;
        if (value1 instanceof ByteSparseValue && value2 instanceof ByteSparseValue) {
            sum = ((ByteSparseValue)value1).add((ByteSparseValue)value2);
        } else if (value1 instanceof ShortSparseValue && value2 instanceof ShortSparseValue) {
            sum = ((ShortSparseValue)value1).add((ShortSparseValue)value2);
        } else if (value1 instanceof IntSparseValue && value2 instanceof IntSparseValue) {
            sum = ((IntSparseValue)value1).add((IntSparseValue)value2);
        } else if (value1 instanceof LongSparseValue && value2 instanceof LongSparseValue) {
            sum = ((LongSparseValue)value1).add((LongSparseValue)value2);
        } else if (value1 instanceof FloatSparseValue && value2 instanceof FloatSparseValue) {
            sum = ((FloatSparseValue)value1).add((FloatSparseValue)value2);
        } else if (value1 instanceof DoubleSparseValue && value2 instanceof DoubleSparseValue) {
            sum = ((DoubleSparseValue)value1).add((DoubleSparseValue)value2);
        } else if (value1 instanceof CharSparseValue && value2 instanceof CharSparseValue) {
            sum = ((CharSparseValue)value1).add((CharSparseValue)value2);
        } else if (value1 instanceof BooleanSparseValue && value2 instanceof BooleanSparseValue) {
            sum = ((BooleanSparseValue)value1).add((BooleanSparseValue)value2);
        } else {
            throw new IllegalArgumentException("Cannot add " + value1 + " and " + value2);
        }
        return sum;
    }

    static {
        HashMap<Class, SparseArrayFillOperation<byte[]>> map = new HashMap<Class, SparseArrayFillOperation<byte[]>>();
        map.put(byte[][].class, new ByteArrayFillOperation());
        map.put(short[][].class, new ShortArrayFillOperation());
        map.put(int[][].class, new IntArrayFillOperation());
        map.put(long[][].class, new LongArrayFillOperation());
        map.put(float[][].class, new FloatArrayFillOperation());
        map.put(double[][].class, new DoubleArrayFillOperation());
        map.put(boolean[][].class, new BooleanArrayFillOperation());
        map.put(char[][].class, new CharArrayFillOperation());
        SPARSE_FILL_OPERATIONS = Collections.unmodifiableMap(map);
    }

    private static class BooleanSparseValue
    implements SparseValue {
        final boolean value;

        BooleanSparseValue(boolean value) {
            this.value = value;
        }

        BooleanSparseValue add(BooleanSparseValue value) {
            return new BooleanSparseValue(this.value || value.value);
        }

        @Override
        public boolean isDefaultValue() {
            return !this.value;
        }
    }

    private static class CharSparseValue
    implements SparseValue {
        final char value;

        CharSparseValue(char value) {
            this.value = value;
        }

        CharSparseValue add(CharSparseValue value) {
            return new CharSparseValue((char)(this.value + value.value));
        }

        @Override
        public boolean isDefaultValue() {
            return this.value == '\u0000';
        }
    }

    private static class DoubleSparseValue
    implements SparseValue {
        final double real;
        final double imag;

        DoubleSparseValue(double real, double imag) {
            this.real = real;
            this.imag = imag;
        }

        DoubleSparseValue add(DoubleSparseValue value) {
            return new DoubleSparseValue(this.real + value.real, this.imag + value.imag);
        }

        @Override
        public boolean isDefaultValue() {
            return this.real == 0.0 && this.imag == 0.0;
        }
    }

    private static class FloatSparseValue
    implements SparseValue {
        final float real;
        final float imag;

        FloatSparseValue(float real, float imag) {
            this.real = real;
            this.imag = imag;
        }

        FloatSparseValue add(FloatSparseValue value) {
            return new FloatSparseValue(this.real + value.real, this.imag + value.imag);
        }

        @Override
        public boolean isDefaultValue() {
            return this.real == 0.0f && this.imag == 0.0f;
        }
    }

    private static class LongSparseValue
    implements SparseValue {
        final long real;
        final long imag;

        LongSparseValue(long real, long imag) {
            this.real = real;
            this.imag = imag;
        }

        LongSparseValue add(LongSparseValue value) {
            return new LongSparseValue(this.real + value.real, this.imag + value.imag);
        }

        @Override
        public boolean isDefaultValue() {
            return this.real == 0L && this.imag == 0L;
        }
    }

    private static class IntSparseValue
    implements SparseValue {
        final int real;
        final int imag;

        IntSparseValue(int real, int imag) {
            this.real = real;
            this.imag = imag;
        }

        IntSparseValue add(IntSparseValue value) {
            return new IntSparseValue(this.real + value.real, this.imag + value.imag);
        }

        @Override
        public boolean isDefaultValue() {
            return this.real == 0 && this.imag == 0;
        }
    }

    private static class ShortSparseValue
    implements SparseValue {
        final short real;
        final short imag;

        ShortSparseValue(short real, short imag) {
            this.real = real;
            this.imag = imag;
        }

        ShortSparseValue add(ShortSparseValue value) {
            return new ShortSparseValue((short)(this.real + value.real), (short)(this.imag + value.imag));
        }

        @Override
        public boolean isDefaultValue() {
            return this.real == 0 && this.imag == 0;
        }
    }

    private static class ByteSparseValue
    implements SparseValue {
        final byte real;
        final byte imag;

        ByteSparseValue(byte real, byte imag) {
            this.real = real;
            this.imag = imag;
        }

        ByteSparseValue add(ByteSparseValue value) {
            return new ByteSparseValue((byte)(this.real + value.real), (byte)(this.imag + value.imag));
        }

        @Override
        public boolean isDefaultValue() {
            return this.real == 0 && this.imag == 0;
        }
    }

    private static interface SparseValue {
        public boolean isDefaultValue();
    }

    private static class SparseKey
    implements Comparable<SparseKey> {
        final int linearIndex;
        final int row;
        final int col;

        SparseKey(int row, int col, int numRows) {
            this.linearIndex = ArrayUtils.multidimensionalIndicesToLinearIndex(numRows, row, col);
            this.row = row;
            this.col = col;
        }

        public int hashCode() {
            return this.linearIndex;
        }

        public boolean equals(Object obj) {
            boolean equal = false;
            if (this == obj) {
                equal = true;
            } else if (obj != null && this.getClass().equals(obj.getClass())) {
                SparseKey otherKey = (SparseKey)obj;
                equal = this.linearIndex == otherKey.linearIndex;
            }
            return equal;
        }

        @Override
        public int compareTo(SparseKey other) {
            return this.linearIndex - other.linearIndex;
        }
    }

    private static class BooleanArrayFillOperation
    implements SparseArrayFillOperation<boolean[]> {
        private BooleanArrayFillOperation() {
        }

        public void fill(boolean[][] dst, boolean[] src, int[] rowIndices, int[] colIndices) {
            for (int i = 0; i < src.length; ++i) {
                dst[rowIndices[i]][colIndices[i]] = src[i];
            }
        }
    }

    private static class CharArrayFillOperation
    implements SparseArrayFillOperation<char[]> {
        private CharArrayFillOperation() {
        }

        public void fill(char[][] dst, char[] src, int[] rowIndices, int[] colIndices) {
            for (int i = 0; i < src.length; ++i) {
                dst[rowIndices[i]][colIndices[i]] = src[i];
            }
        }
    }

    private static class DoubleArrayFillOperation
    implements SparseArrayFillOperation<double[]> {
        private DoubleArrayFillOperation() {
        }

        public void fill(double[][] dst, double[] src, int[] rowIndices, int[] colIndices) {
            for (int i = 0; i < src.length; ++i) {
                dst[rowIndices[i]][colIndices[i]] = src[i];
            }
        }
    }

    private static class FloatArrayFillOperation
    implements SparseArrayFillOperation<float[]> {
        private FloatArrayFillOperation() {
        }

        public void fill(float[][] dst, float[] src, int[] rowIndices, int[] colIndices) {
            for (int i = 0; i < src.length; ++i) {
                dst[rowIndices[i]][colIndices[i]] = src[i];
            }
        }
    }

    private static class LongArrayFillOperation
    implements SparseArrayFillOperation<long[]> {
        private LongArrayFillOperation() {
        }

        public void fill(long[][] dst, long[] src, int[] rowIndices, int[] colIndices) {
            for (int i = 0; i < src.length; ++i) {
                dst[rowIndices[i]][colIndices[i]] = src[i];
            }
        }
    }

    private static class IntArrayFillOperation
    implements SparseArrayFillOperation<int[]> {
        private IntArrayFillOperation() {
        }

        public void fill(int[][] dst, int[] src, int[] rowIndices, int[] colIndices) {
            for (int i = 0; i < src.length; ++i) {
                dst[rowIndices[i]][colIndices[i]] = src[i];
            }
        }
    }

    private static class ShortArrayFillOperation
    implements SparseArrayFillOperation<short[]> {
        private ShortArrayFillOperation() {
        }

        public void fill(short[][] dst, short[] src, int[] rowIndices, int[] colIndices) {
            for (int i = 0; i < src.length; ++i) {
                dst[rowIndices[i]][colIndices[i]] = src[i];
            }
        }
    }

    private static class ByteArrayFillOperation
    implements SparseArrayFillOperation<byte[]> {
        private ByteArrayFillOperation() {
        }

        public void fill(byte[][] dst, byte[] src, int[] rowIndices, int[] colIndices) {
            for (int i = 0; i < src.length; ++i) {
                dst[rowIndices[i]][colIndices[i]] = src[i];
            }
        }
    }

    private static interface SparseArrayFillOperation<T> {
        public void fill(T[] var1, T var2, int[] var3, int[] var4);
    }
}

