/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.selfie;

import com.diffplug.selfie.BinaryFacet;
import com.diffplug.selfie.DiskSelfie;
import com.diffplug.selfie.Mode;
import com.diffplug.selfie.Selfie;
import com.diffplug.selfie.SelfieImplementationsKt;
import com.diffplug.selfie.Snapshot;
import com.diffplug.selfie.SnapshotValue;
import com.diffplug.selfie.guts.CallStack;
import com.diffplug.selfie.guts.DiskStorage;
import com.diffplug.selfie.guts.FS;
import com.diffplug.selfie.guts.LiteralString;
import com.diffplug.selfie.guts.TodoStub;
import com.diffplug.selfie.guts.TypedPath;
import com.diffplug.selfie.guts.WriteTracker_jvmKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\bH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0002J\b\u0010\u0011\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\bH\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/diffplug/selfie/BinarySelfie;", "Lcom/diffplug/selfie/DiskSelfie;", "Lcom/diffplug/selfie/BinaryFacet;", "actual", "Lcom/diffplug/selfie/Snapshot;", "disk", "Lcom/diffplug/selfie/guts/DiskStorage;", "onlyFacet", "", "<init>", "(Lcom/diffplug/selfie/Snapshot;Lcom/diffplug/selfie/guts/DiskStorage;Ljava/lang/String;)V", "actualBytes", "", "toMatchDisk", "sub", "toMatchDisk_TODO", "actualString", "toBeBase64_TODO", "toBeBase64", "expected", "toBeFile_TODO", "subpath", "toBeFile", "resolvePath", "Lcom/diffplug/selfie/guts/TypedPath;", "toBeFileImpl", "isTodo", "", "selfie-lib"})
public final class BinarySelfie
extends DiskSelfie
implements BinaryFacet {
    @NotNull
    private final String onlyFacet;

    public BinarySelfie(@NotNull Snapshot actual, @NotNull DiskStorage disk, @NotNull String onlyFacet) {
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)disk, (String)"disk");
        Intrinsics.checkNotNullParameter((Object)onlyFacet, (String)"onlyFacet");
        super(actual, disk);
        this.onlyFacet = onlyFacet;
        SnapshotValue snapshotValue = actual.subjectOrFacetMaybe(this.onlyFacet);
        if (!(snapshotValue != null ? snapshotValue.isBinary() : false)) {
            boolean bl = false;
            String string = "The facet " + this.onlyFacet + " was not found in the snapshot, or it was not a binary facet.";
            throw new IllegalStateException(string.toString());
        }
    }

    private final byte[] actualBytes() {
        return this.getActual().subjectOrFacet(this.onlyFacet).valueBinary();
    }

    @Override
    @NotNull
    public BinarySelfie toMatchDisk(@NotNull String sub) {
        Intrinsics.checkNotNullParameter((Object)sub, (String)"sub");
        super.toMatchDisk(sub);
        return this;
    }

    @Override
    @NotNull
    public BinarySelfie toMatchDisk_TODO(@NotNull String sub) {
        Intrinsics.checkNotNullParameter((Object)sub, (String)"sub");
        super.toMatchDisk_TODO(sub);
        return this;
    }

    private final String actualString() {
        return StringsKt.replace$default((String)Base64.encode$default((Base64)Base64.Default.getMime(), (byte[])this.actualBytes(), (int)0, (int)0, (int)6, null), (String)"\r", (String)"", (boolean)false, (int)4, null);
    }

    @Override
    @NotNull
    public byte[] toBeBase64_TODO() {
        SelfieImplementationsKt.access$toBeDidntMatch(null, this.actualString(), LiteralString.INSTANCE);
        return this.actualBytes();
    }

    @Override
    @NotNull
    public byte[] toBeBase64(@NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        byte[] expectedBytes = Base64.decode$default((Base64)Base64.Default.getMime(), (CharSequence)expected, (int)0, (int)0, (int)6, null);
        byte[] actualBytes = this.actualBytes();
        if (!Arrays.equals(expectedBytes, actualBytes)) {
            SelfieImplementationsKt.access$toBeDidntMatch(expected, this.actualString(), LiteralString.INSTANCE);
            return this.actualBytes();
        }
        return (byte[])SelfieImplementationsKt.access$checkSrc(Selfie.INSTANCE.getSystem$selfie_lib(), actualBytes);
    }

    @Override
    @NotNull
    public byte[] toBeFile_TODO(@NotNull String subpath) {
        Intrinsics.checkNotNullParameter((Object)subpath, (String)"subpath");
        return this.toBeFileImpl(subpath, true);
    }

    @Override
    @NotNull
    public byte[] toBeFile(@NotNull String subpath) {
        Intrinsics.checkNotNullParameter((Object)subpath, (String)"subpath");
        return this.toBeFileImpl(subpath, false);
    }

    private final TypedPath resolvePath(String subpath) {
        return Selfie.INSTANCE.getSystem$selfie_lib().getLayout().getRootFolder().resolveFile(subpath);
    }

    private final byte[] toBeFileImpl(String subpath, boolean isTodo) {
        CallStack call = WriteTracker_jvmKt.recordCall(false);
        boolean writable = Selfie.INSTANCE.getSystem$selfie_lib().getMode().canWrite$selfie_lib(isTodo, call, Selfie.INSTANCE.getSystem$selfie_lib());
        byte[] actualBytes = this.actualBytes();
        if (writable) {
            if (isTodo) {
                Selfie.INSTANCE.getSystem$selfie_lib().writeInline(TodoStub.toBeFile.createLiteral(), call);
            }
            Selfie.INSTANCE.getSystem$selfie_lib().writeToBeFile(this.resolvePath(subpath), actualBytes, call);
            return actualBytes;
        }
        if (isTodo) {
            throw FS.assertFailed$default(Selfie.INSTANCE.getSystem$selfie_lib().getFs(), "Can't call `toBeFile_TODO` in " + Mode.readonly + " mode!", null, null, 6, null);
        }
        TypedPath path = this.resolvePath(subpath);
        if (!Selfie.INSTANCE.getSystem$selfie_lib().getFs().fileExists(path)) {
            throw FS.assertFailed$default(Selfie.INSTANCE.getSystem$selfie_lib().getFs(), Selfie.INSTANCE.getSystem$selfie_lib().getMode().msgSnapshotNotFoundNoSuchFile$selfie_lib(path), null, null, 6, null);
        }
        byte[] expected = Selfie.INSTANCE.getSystem$selfie_lib().getFs().fileReadBinary(path);
        if (Arrays.equals(expected, actualBytes)) {
            return actualBytes;
        }
        throw Selfie.INSTANCE.getSystem$selfie_lib().getFs().assertFailed(Selfie.INSTANCE.getSystem$selfie_lib().getMode().msgSnapshotMismatchBinary$selfie_lib(expected, actualBytes), expected, actualBytes);
    }
}

