/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.selfie;

import com.diffplug.selfie.guts.CallStack;
import com.diffplug.selfie.guts.CommentTracker;
import com.diffplug.selfie.guts.FS;
import com.diffplug.selfie.guts.SnapshotFileLayout;
import com.diffplug.selfie.guts.SnapshotNotEqualErrorMsg;
import com.diffplug.selfie.guts.SnapshotSystem;
import com.diffplug.selfie.guts.TypedPath;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\r\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u0015\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u001d\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0019J\u001d\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\f\u0010\u001d\u001a\u00020\u0010*\u00020\u001bH\u0002J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0010H\u0002j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006 "}, d2={"Lcom/diffplug/selfie/Mode;", "", "<init>", "(Ljava/lang/String;I)V", "interactive", "readonly", "overwrite", "canWrite", "", "isTodo", "call", "Lcom/diffplug/selfie/guts/CallStack;", "system", "Lcom/diffplug/selfie/guts/SnapshotSystem;", "canWrite$selfie_lib", "msgSnapshotNotFound", "", "msgSnapshotNotFound$selfie_lib", "msgSnapshotNotFoundNoSuchFile", "file", "Lcom/diffplug/selfie/guts/TypedPath;", "msgSnapshotNotFoundNoSuchFile$selfie_lib", "msgSnapshotMismatch", "expected", "actual", "msgSnapshotMismatch$selfie_lib", "msgSnapshotMismatchBinary", "", "msgSnapshotMismatchBinary$selfie_lib", "toQuotedPrintable", "msg", "headline", "selfie-lib"})
public final class Mode
extends Enum<Mode> {
    public static final /* enum */ Mode interactive = new Mode();
    public static final /* enum */ Mode readonly = new Mode();
    public static final /* enum */ Mode overwrite = new Mode();
    private static final /* synthetic */ Mode[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    public final boolean canWrite$selfie_lib(boolean isTodo, @NotNull CallStack call, @NotNull SnapshotSystem system) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)system, (String)"system");
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                if (isTodo || system.sourceFileHasWritableComment(call)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (system.sourceFileHasWritableComment(call)) {
                    SnapshotFileLayout layout = system.getLayout();
                    TypedPath path = layout.sourcePathForCall(call.getLocation());
                    Pair<String, Integer> pair = CommentTracker.Companion.commentString(path, system.getFs());
                    String comment = (String)pair.component1();
                    int line = ((Number)pair.component2()).intValue();
                    throw FS.assertFailed$default(system.getFs(), "Selfie is in readonly mode, so `" + comment + "` is illegal at " + call.getLocation().withLine(line).ideLink(layout), null, null, 6, null);
                }
                bl = false;
                break;
            }
            case 3: {
                bl = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @NotNull
    public final String msgSnapshotNotFound$selfie_lib() {
        return this.msg("Snapshot not found");
    }

    @NotNull
    public final String msgSnapshotNotFoundNoSuchFile$selfie_lib(@NotNull TypedPath file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.msg("Snapshot not found: no such file " + file);
    }

    @NotNull
    public final String msgSnapshotMismatch$selfie_lib(@NotNull String expected, @NotNull String actual) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        return this.msg(SnapshotNotEqualErrorMsg.INSTANCE.forUnequalStrings(expected, actual));
    }

    @NotNull
    public final String msgSnapshotMismatchBinary$selfie_lib(@NotNull byte[] expected, @NotNull byte[] actual) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        return this.msgSnapshotMismatch$selfie_lib(this.toQuotedPrintable(expected), this.toQuotedPrintable(actual));
    }

    private final String toQuotedPrintable(byte[] $this$toQuotedPrintable) {
        StringBuilder sb = new StringBuilder();
        for (byte by : $this$toQuotedPrintable) {
            StringBuilder stringBuilder;
            int b = by & 0xFF;
            boolean bl = 33 <= b ? b < 127 : false;
            if (bl && b != 61) {
                stringBuilder = sb.append((char)b);
                continue;
            }
            StringBuilder stringBuilder2 = sb.append("=");
            String string = Integer.toString(b, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            stringBuilder = stringBuilder2.append(StringsKt.padStart((String)string2, (int)2, (char)'0'));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String msg(String headline) {
        Object object;
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                object = headline + "\n\u2023 update this snapshot by adding `_TODO` to the function name\n\u2023 update all snapshots in this file by adding `//selfieonce` or `//SELFIEWRITE`";
                break;
            }
            case 2: {
                object = headline;
                break;
            }
            case 3: {
                object = headline + "\n(didn't expect this to ever happen in overwrite mode)";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return object;
    }

    public static Mode[] values() {
        return (Mode[])$VALUES.clone();
    }

    public static Mode valueOf(String value) {
        return Enum.valueOf(Mode.class, value);
    }

    @NotNull
    public static EnumEntries<Mode> getEntries() {
        return $ENTRIES;
    }

    static {
        $VALUES = modeArray = new Mode[]{Mode.interactive, Mode.readonly, Mode.overwrite};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Mode.values().length];
            try {
                nArray[Mode.interactive.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.readonly.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.overwrite.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

