/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.selfie.guts;

import com.diffplug.selfie.SnapshotFileKt;
import com.diffplug.selfie.guts.EscapeLeadingWhitespace;
import com.diffplug.selfie.guts.Language;
import com.diffplug.selfie.guts.LiteralFormat;
import com.diffplug.selfie.guts.SourceFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J%\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u000bJ\u001d\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0010\u00a2\u0006\u0002\b\u000eJ\u000e\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002J\u000e\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002J\u0018\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002J\u000e\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002J\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J\u000e\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0002J\u0016\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\nJ\u0016\u0010 \u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\nJ\u0010\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u0002H\u0002J\u0010\u0010%\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u0002H\u0002J\u000e\u0010&\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002J\u000e\u0010'\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/diffplug/selfie/guts/LiteralString;", "Lcom/diffplug/selfie/guts/LiteralFormat;", "", "<init>", "()V", "encode", "value", "language", "Lcom/diffplug/selfie/guts/Language;", "encodingPolicy", "Lcom/diffplug/selfie/guts/EscapeLeadingWhitespace;", "encode$selfie_lib", "parse", "str", "parse$selfie_lib", "encodeSingleJava", "encodeSingleJavaWithDollars", "encodeSingleJavaish", "escapeDollars", "", "isControlChar", "c", "", "parseSingleJava", "sourceWithQuotes", "parseSingleJavaWithDollars", "parseSingleJavaish", "removeDollars", "encodeMultiAsSingleJava", "arg", "encodeMultiKotlin", "escapeLeadingWhitespace", "encodeMultiJava", "charLiteralRegex", "Lkotlin/text/Regex;", "inlineDollars", "source", "unescapeJava", "parseMultiJava", "parseMultiKotlin", "selfie-lib"})
@SourceDebugExtension(value={"SMAP\nLiterals.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Literals.kt\ncom/diffplug/selfie/guts/LiteralString\n+ 2 SourceFile.kt\ncom/diffplug/selfie/guts/SourceFile$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,381:1\n173#2:382\n1611#3,9:383\n1863#3:392\n1864#3:399\n1620#3:400\n1611#3,9:401\n1863#3:410\n1864#3:417\n1620#3:418\n648#4,5:393\n648#4,5:411\n1#5:398\n1#5:416\n*S KotlinDebug\n*F\n+ 1 Literals.kt\ncom/diffplug/selfie/guts/LiteralString\n*L\n148#1:382\n238#1:383,9\n238#1:392\n238#1:399\n238#1:400\n327#1:401,9\n327#1:410\n327#1:417\n327#1:418\n239#1:393,5\n328#1:411,5\n238#1:398\n327#1:416\n*E\n"})
public final class LiteralString
extends LiteralFormat<String> {
    @NotNull
    public static final LiteralString INSTANCE = new LiteralString();
    @NotNull
    private static final Regex charLiteralRegex = new Regex("\\$\\{'(\\\\?.)'\\}");

    private LiteralString() {
    }

    @Override
    @NotNull
    public String encode$selfie_lib(@NotNull String value, @NotNull Language language, @NotNull EscapeLeadingWhitespace encodingPolicy) {
        String string;
        block10: {
            block9: {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
                Intrinsics.checkNotNullParameter((Object)((Object)encodingPolicy), (String)"encodingPolicy");
                if (StringsKt.indexOf$default((CharSequence)value, (char)'\n', (int)0, (boolean)false, (int)6, null) != -1) break block9;
                switch (WhenMappings.$EnumSwitchMapping$0[language.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        string = this.encodeSingleJava(value);
                        break block10;
                    }
                    case 5: {
                        string = this.encodeSingleJavaWithDollars(value);
                        break block10;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$0[language.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    string = this.encodeMultiAsSingleJava(value);
                    break;
                }
                case 4: {
                    string = this.encodeMultiJava(value, encodingPolicy);
                    break;
                }
                case 5: {
                    string = this.encodeMultiKotlin(value, encodingPolicy);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return string;
    }

    @Override
    @NotNull
    public String parse$selfie_lib(@NotNull String str, @NotNull Language language) {
        String string;
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
                if (StringsKt.startsWith$default((String)str, (String)"\"\"\"", (boolean)false, (int)2, null)) break block10;
                switch (WhenMappings.$EnumSwitchMapping$0[language.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 4: {
                        SourceFile.Companion this_$iv = SourceFile.Companion;
                        boolean $i$f$commaDelimitedParseCleanup$selfie_lib = false;
                        string = this.parseSingleJava(SnapshotFileKt.efficientReplace(str, "\",\n\"", "\\n"));
                        break block11;
                    }
                    case 3: 
                    case 5: {
                        string = this.parseSingleJavaWithDollars(str);
                        break block11;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$0[language.ordinal()]) {
                case 1: {
                    throw new UnsupportedOperationException("Selfie doesn't support triple-quoted strings in Scala, yet - help wanted: https://github.com/diffplug/selfie/issues/106");
                }
                case 3: {
                    throw new UnsupportedOperationException("Selfie doesn't support triple-quoted strings in Groovy, yet - help wanted: https://github.com/diffplug/selfie/issues/105");
                }
                case 2: 
                case 4: {
                    string = this.parseMultiJava(str);
                    break;
                }
                case 5: {
                    string = this.parseMultiKotlin(str);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return string;
    }

    @NotNull
    public final String encodeSingleJava(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.encodeSingleJavaish(value, false);
    }

    @NotNull
    public final String encodeSingleJavaWithDollars(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.encodeSingleJavaish(value, true);
    }

    private final String encodeSingleJavaish(String value, boolean escapeDollars) {
        StringBuilder source = new StringBuilder();
        source.append("\"");
        int n = value.length();
        block9: for (int j = 0; j < n; ++j) {
            char c = value.charAt(j);
            switch (c) {
                case '\b': {
                    StringBuilder stringBuilder = source.append("\\b");
                    continue block9;
                }
                case '\n': {
                    StringBuilder stringBuilder = source.append("\\n");
                    continue block9;
                }
                case '\r': {
                    StringBuilder stringBuilder = source.append("\\r");
                    continue block9;
                }
                case '\t': {
                    StringBuilder stringBuilder = source.append("\\t");
                    continue block9;
                }
                case '\"': {
                    StringBuilder stringBuilder = source.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    StringBuilder stringBuilder = source.append("\\\\");
                    continue block9;
                }
                case '$': {
                    StringBuilder stringBuilder;
                    if (escapeDollars) {
                        stringBuilder = source.append("${'$'}");
                        continue block9;
                    }
                    stringBuilder = source.append('$');
                    continue block9;
                }
                default: {
                    StringBuilder stringBuilder;
                    if (this.isControlChar(c)) {
                        source.append("\\u");
                        String string = Integer.toString(c, CharsKt.checkRadix((int)16));
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        stringBuilder = source.append(StringsKt.padStart((String)string, (int)4, (char)'0'));
                        continue block9;
                    }
                    stringBuilder = source.append(c);
                }
            }
        }
        source.append("\"");
        String string = source.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final boolean isControlChar(char c) {
        return ('\u0000' <= c ? c < ' ' : false) || c == '\u007f';
    }

    @NotNull
    public final String parseSingleJava(@NotNull String sourceWithQuotes) {
        Intrinsics.checkNotNullParameter((Object)sourceWithQuotes, (String)"sourceWithQuotes");
        return this.parseSingleJavaish(sourceWithQuotes, false);
    }

    @NotNull
    public final String parseSingleJavaWithDollars(@NotNull String sourceWithQuotes) {
        Intrinsics.checkNotNullParameter((Object)sourceWithQuotes, (String)"sourceWithQuotes");
        return this.parseSingleJavaish(sourceWithQuotes, true);
    }

    private final String parseSingleJavaish(String sourceWithQuotes, boolean removeDollars) {
        if (!StringsKt.startsWith$default((CharSequence)sourceWithQuotes, (char)'\"', (boolean)false, (int)2, null)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!StringsKt.endsWith$default((CharSequence)sourceWithQuotes, (char)'\"', (boolean)false, (int)2, null)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        String string = sourceWithQuotes.substring(1, sourceWithQuotes.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String source = string;
        String toUnescape = removeDollars ? this.inlineDollars(source) : source;
        return this.unescapeJava(toUnescape);
    }

    @NotNull
    public final String encodeMultiAsSingleJava(@NotNull String arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)arg), (CharSequence)",\n", null, null, (int)0, null, LiteralString::encodeMultiAsSingleJava$lambda$0, (int)30, null);
    }

    @NotNull
    public final String encodeMultiKotlin(@NotNull String arg, @NotNull EscapeLeadingWhitespace escapeLeadingWhitespace) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Intrinsics.checkNotNullParameter((Object)((Object)escapeLeadingWhitespace), (String)"escapeLeadingWhitespace");
        String escapeDollars = StringsKt.replace$default((String)arg, (String)"$", (String)"${'$'}", (boolean)false, (int)4, null);
        String escapeTripleQuotes = StringsKt.replace$default((String)escapeDollars, (String)"\"\"\"", (String)"${'\"'}${'\"'}${'\"'}", (boolean)false, (int)4, null);
        String protectWhitespace = CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)escapeTripleQuotes), (CharSequence)"\n", null, null, (int)0, null, arg_0 -> LiteralString.encodeMultiKotlin$lambda$1(escapeLeadingWhitespace, arg_0), (int)30, null);
        return "\"\"\"" + protectWhitespace + "\"\"\"";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String encodeMultiJava(@NotNull String arg, @NotNull EscapeLeadingWhitespace escapeLeadingWhitespace) {
        String commonPrefix;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Intrinsics.checkNotNullParameter((Object)((Object)escapeLeadingWhitespace), (String)"escapeLeadingWhitespace");
        String escapeBackslashes = StringsKt.replace$default((String)arg, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null);
        String escapeTripleQuotes = StringsKt.replace$default((String)escapeBackslashes, (String)"\"\"\"", (String)"\\\"\\\"\\\"", (boolean)false, (int)4, null);
        String protectWhitespace = CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)escapeTripleQuotes), (CharSequence)"\n", null, null, (int)0, null, arg_0 -> LiteralString.encodeMultiJava$lambda$2(escapeLeadingWhitespace, arg_0), (int)30, null);
        Iterable iterable = StringsKt.lines((CharSequence)protectWhitespace);
        boolean $i$f$mapNotNull = false;
        void var10_8 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String string;
            block6: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                String line = (String)element$iv$iv;
                boolean bl2 = false;
                if (!StringsKt.isBlank((CharSequence)line)) {
                    String $this$takeWhile$iv = line;
                    boolean $i$f$takeWhile = false;
                    int n = $this$takeWhile$iv.length();
                    for (int index$iv = 0; index$iv < n; ++index$iv) {
                        char it = $this$takeWhile$iv.charAt(index$iv);
                        boolean bl3 = false;
                        if (CharsKt.isWhitespace((char)it)) continue;
                        String string2 = $this$takeWhile$iv;
                        int n2 = 0;
                        String string3 = string2.substring(n2, index$iv);
                        string = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        break block6;
                    }
                    string = $this$takeWhile$iv;
                } else {
                    string = null;
                }
            }
            if (string == null) continue;
            String it$iv$iv = string;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        String string = (String)((Object)CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv)));
        if (string == null) {
            string = "";
        }
        if (((CharSequence)(commonPrefix = string)).length() > 0) {
            List lines = StringsKt.lines((CharSequence)protectWhitespace);
            String last = (String)CollectionsKt.last((List)lines);
            protectWhitespace = CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, arg_0 -> LiteralString.encodeMultiJava$lambda$5(last, arg_0), (int)30, null);
        }
        return "\"\"\"\n" + protectWhitespace + "\"\"\"";
    }

    private final String inlineDollars(String source) {
        if (StringsKt.indexOf$default((CharSequence)source, (char)'$', (int)0, (boolean)false, (int)6, null) == -1) {
            return source;
        }
        return charLiteralRegex.replace((CharSequence)source, LiteralString::inlineDollars$lambda$6);
    }

    private final String unescapeJava(String source) {
        int firstEscape = StringsKt.indexOf$default((CharSequence)source, (char)'\\', (int)0, (boolean)false, (int)6, null);
        if (firstEscape == -1) {
            return source;
        }
        StringBuilder value = new StringBuilder();
        String string = source.substring(0, firstEscape);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        value.append(string);
        block11: for (int i2 = firstEscape; i2 < source.length(); ++i2) {
            Comparable<StringBuilder> comparable;
            char c = source.charAt(i2);
            if (c == '\\') {
                c = source.charAt(++i2);
                switch (c) {
                    case '\"': {
                        comparable = value.append('\"');
                        continue block11;
                    }
                    case '\\': {
                        comparable = value.append('\\');
                        continue block11;
                    }
                    case 'b': {
                        comparable = value.append('\b');
                        continue block11;
                    }
                    case 'f': {
                        comparable = value.append('\f');
                        continue block11;
                    }
                    case 'n': {
                        comparable = value.append('\n');
                        continue block11;
                    }
                    case 'r': {
                        comparable = value.append('\r');
                        continue block11;
                    }
                    case 's': {
                        comparable = value.append(' ');
                        continue block11;
                    }
                    case 't': {
                        comparable = value.append('\t');
                        continue block11;
                    }
                    case 'u': {
                        String string2 = source.substring(i2 + 1, i2 + 5);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        int code = Integer.parseInt(string2, CharsKt.checkRadix((int)16));
                        value.append((char)code);
                        comparable = i2 += 4;
                        continue block11;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown escape sequence " + c);
                    }
                }
            }
            comparable = value.append(c);
        }
        String string3 = value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String parseMultiJava(@NotNull String sourceWithQuotes) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)sourceWithQuotes, (String)"sourceWithQuotes");
        if (!StringsKt.startsWith$default((String)sourceWithQuotes, (String)"\"\"\"\n", (boolean)false, (int)2, null)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!StringsKt.endsWith$default((String)sourceWithQuotes, (String)"\"\"\"", (boolean)false, (int)2, null)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        String string = sourceWithQuotes.substring(4, sourceWithQuotes.length() - 3);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String source = string;
        List lines = StringsKt.lines((CharSequence)source);
        Iterable iterable = lines;
        boolean $i$f$mapNotNull = false;
        void var7_8 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String string2;
            block7: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                String line = (String)element$iv$iv;
                boolean bl2 = false;
                if (!StringsKt.isBlank((CharSequence)line)) {
                    String $this$takeWhile$iv = line;
                    boolean $i$f$takeWhile = false;
                    int n = $this$takeWhile$iv.length();
                    for (int index$iv = 0; index$iv < n; ++index$iv) {
                        char it = $this$takeWhile$iv.charAt(index$iv);
                        boolean bl3 = false;
                        if (CharsKt.isWhitespace((char)it)) continue;
                        String string3 = $this$takeWhile$iv;
                        int n2 = 0;
                        String string4 = string3.substring(n2, index$iv);
                        string2 = string4;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                        break block7;
                    }
                    string2 = $this$takeWhile$iv;
                } else {
                    string2 = null;
                }
            }
            if (string2 == null) continue;
            String it$iv$iv = string2;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        String string5 = (String)((Object)CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv)));
        if (string5 == null) {
            string5 = "";
        }
        String commonPrefix = string5;
        return CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, arg_0 -> LiteralString.parseMultiJava$lambda$9(commonPrefix, arg_0), (int)30, null);
    }

    @NotNull
    public final String parseMultiKotlin(@NotNull String sourceWithQuotes) {
        Intrinsics.checkNotNullParameter((Object)sourceWithQuotes, (String)"sourceWithQuotes");
        if (!StringsKt.startsWith$default((String)sourceWithQuotes, (String)"\"\"\"", (boolean)false, (int)2, null)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!StringsKt.endsWith$default((String)sourceWithQuotes, (String)"\"\"\"", (boolean)false, (int)2, null)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        String string = sourceWithQuotes.substring(3, sourceWithQuotes.length() - 3);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String source = string;
        return this.inlineDollars(source);
    }

    private static final CharSequence encodeMultiAsSingleJava$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.encodeSingleJava(it);
    }

    private static final CharSequence encodeMultiKotlin$lambda$1(EscapeLeadingWhitespace $escapeLeadingWhitespace, String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        String protectTrailingWhitespace = StringsKt.endsWith$default((String)line, (String)" ", (boolean)false, (int)2, null) ? StringsKt.dropLast((String)line, (int)1) + "${' '}" : (StringsKt.endsWith$default((String)line, (String)"\t", (boolean)false, (int)2, null) ? StringsKt.dropLast((String)line, (int)1) + "${'\\t'}" : line);
        return $escapeLeadingWhitespace.escapeLine(protectTrailingWhitespace, "${' '}", "${'\\t'}");
    }

    private static final CharSequence encodeMultiJava$lambda$2(EscapeLeadingWhitespace $escapeLeadingWhitespace, String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        String protectTrailingWhitespace = StringsKt.endsWith$default((String)line, (String)" ", (boolean)false, (int)2, null) ? StringsKt.dropLast((String)line, (int)1) + "\\s" : (StringsKt.endsWith$default((String)line, (String)"\t", (boolean)false, (int)2, null) ? StringsKt.dropLast((String)line, (int)1) + "\\t" : line);
        return $escapeLeadingWhitespace.escapeLine(protectTrailingWhitespace, "\\s", "\\t");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final CharSequence encodeMultiJava$lambda$5(String $last, String line) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (line == $last) {
            if (StringsKt.startsWith$default((String)line, (String)" ", (boolean)false, (int)2, null)) {
                object = "\\s" + StringsKt.drop((String)line, (int)1);
                return (CharSequence)object;
            } else {
                if (!StringsKt.startsWith$default((String)line, (String)"\t", (boolean)false, (int)2, null)) throw new UnsupportedOperationException("How did it end up with a common whitespace prefix?");
                object = "\\t" + StringsKt.drop((String)line, (int)1);
            }
            return (CharSequence)object;
        } else {
            object = line;
        }
        return (CharSequence)object;
    }

    private static final CharSequence inlineDollars$lambda$6(MatchResult matchResult) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        String charLiteral = (String)matchResult.getGroupValues().get(1);
        if (charLiteral.length() == 1) {
            charSequence = charLiteral;
        } else if (charLiteral.length() == 2 && charLiteral.charAt(0) == '\\') {
            String string;
            switch (charLiteral.charAt(1)) {
                case 't': {
                    string = "\t";
                    break;
                }
                case 'b': {
                    string = "\b";
                    break;
                }
                case 'n': {
                    string = "\n";
                    break;
                }
                case 'r': {
                    string = "\r";
                    break;
                }
                case '\'': {
                    string = "'";
                    break;
                }
                case '\\': {
                    string = "\\";
                    break;
                }
                case '$': {
                    string = "$";
                    break;
                }
                default: {
                    string = charLiteral;
                }
            }
            charSequence = string;
        } else {
            throw new IllegalArgumentException("Unknown character literal " + charLiteral);
        }
        return charSequence;
    }

    private static final CharSequence parseMultiJava$lambda$9(String $commonPrefix, String line) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (StringsKt.isBlank((CharSequence)line)) {
            charSequence = "";
        } else {
            String removedPrefix = ((CharSequence)$commonPrefix).length() == 0 ? line : StringsKt.removePrefix((String)line, (CharSequence)$commonPrefix);
            String removeTrailingWhitespace = ((Object)StringsKt.trimEnd((CharSequence)removedPrefix)).toString();
            String handleEscapeSequences = INSTANCE.unescapeJava(removeTrailingWhitespace);
            charSequence = handleEscapeSequences;
        }
        return charSequence;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Language.values().length];
            try {
                nArray[Language.SCALA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Language.JAVA_PRE15.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Language.GROOVY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Language.JAVA.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Language.KOTLIN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

