/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.selfie.guts;

import com.diffplug.selfie.guts.CallLocation;
import com.diffplug.selfie.guts.CallStack;
import com.diffplug.selfie.guts.FirstWrite;
import com.diffplug.selfie.guts.LiteralTodoStub;
import com.diffplug.selfie.guts.LiteralValue;
import com.diffplug.selfie.guts.SnapshotFileLayout;
import com.diffplug.selfie.guts.SourceFile;
import com.diffplug.selfie.guts.TodoStub;
import com.diffplug.selfie.guts.TypedPath;
import com.diffplug.selfie.guts.WriteTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0011"}, d2={"Lcom/diffplug/selfie/guts/InlineWriteTracker;", "Lcom/diffplug/selfie/guts/WriteTracker;", "Lcom/diffplug/selfie/guts/CallLocation;", "Lcom/diffplug/selfie/guts/LiteralValue;", "<init>", "()V", "record", "", "call", "Lcom/diffplug/selfie/guts/CallStack;", "literalValue", "layout", "Lcom/diffplug/selfie/guts/SnapshotFileLayout;", "hasWrites", "", "persistWrites", "FileLineLiteral", "selfie-lib"})
@SourceDebugExtension(value={"SMAP\nWriteTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WriteTracker.kt\ncom/diffplug/selfie/guts/InlineWriteTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,221:1\n1557#2:222\n1628#2,3:223\n*S KotlinDebug\n*F\n+ 1 WriteTracker.kt\ncom/diffplug/selfie/guts/InlineWriteTracker\n*L\n190#1:222\n190#1:223,3\n*E\n"})
public final class InlineWriteTracker
extends WriteTracker<CallLocation, LiteralValue<?>> {
    public InlineWriteTracker() {
        super(null);
    }

    public final void record(@NotNull CallStack call, @NotNull LiteralValue<?> literalValue, @NotNull SnapshotFileLayout layout) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter(literalValue, (String)"literalValue");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        this.recordInternal((Comparable)call.getLocation(), literalValue, call, layout);
        TypedPath file = layout.sourcePathForCall(call.getLocation());
        if (literalValue.getExpected() != null) {
            Object obj;
            SourceFile content = layout.parseSourceFile(file);
            try {
                obj = content.parseToBeLike(call.getLocation().getLine()).parseLiteral(literalValue.getFormat());
            }
            catch (Exception e) {
                throw new AssertionError("Error while parsing the literal at " + call.getLocation().ideLink(layout) + ". Please report this error at https://github.com/diffplug/selfie", e);
            }
            Object parsedValue = obj;
            if (!Intrinsics.areEqual(parsedValue, literalValue.getExpected())) {
                throw layout.getFs().assertFailed("Selfie cannot modify the literal at " + call.getLocation().ideLink(layout) + " because Selfie has a parsing bug. Please report this error at https://github.com/diffplug/selfie", literalValue.getExpected(), parsedValue);
            }
        }
    }

    public final boolean hasWrites() {
        return !((Map)this.getWrites$selfie_lib().get()).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public final void persistWrites(@NotNull SnapshotFileLayout layout) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        Iterable $this$map$iv = MapsKt.toList((Map)this.getWrites$selfie_lib().get());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TypedPath typedPath = layout.sourcePathForCall((CallLocation)it.getFirst());
            Intrinsics.checkNotNull((Object)typedPath);
            collection.add(new FileLineLiteral(typedPath, ((CallLocation)it.getFirst()).getLine(), (LiteralValue)((FirstWrite)it.getSecond()).getSnapshot()));
        }
        List writes = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        if (writes.isEmpty()) {
            return;
        }
        TypedPath file = ((FileLineLiteral)CollectionsKt.first((List)writes)).getFile();
        SourceFile content = layout.parseSourceFile(file);
        int deltaLineNumbers = 0;
        for (FileLineLiteral write : writes) {
            if (!Intrinsics.areEqual((Object)write.getFile(), (Object)file)) {
                layout.getFs().fileWrite(file, content.getAsString());
                file = write.getFile();
                deltaLineNumbers = 0;
                content = layout.parseSourceFile(file);
            }
            int line = write.getLine() + deltaLineNumbers;
            if (Intrinsics.areEqual(write.getLiteral().getFormat(), (Object)LiteralTodoStub.INSTANCE)) {
                Object obj = write.getLiteral().getActual();
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type com.diffplug.selfie.guts.TodoStub");
                TodoStub kind = (TodoStub)((Object)obj);
                content.replaceOnLine(line, "." + kind.name() + "_TODO(", "." + kind.name() + "(");
                continue;
            }
            deltaLineNumbers += content.parseToBeLike(line).setLiteralAndGetNewlineDelta(write.getLiteral());
        }
        layout.getFs().fileWrite(file, content.getAsString());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/diffplug/selfie/guts/InlineWriteTracker$FileLineLiteral;", "", "file", "Lcom/diffplug/selfie/guts/TypedPath;", "line", "", "literal", "Lcom/diffplug/selfie/guts/LiteralValue;", "<init>", "(Lcom/diffplug/selfie/guts/TypedPath;ILcom/diffplug/selfie/guts/LiteralValue;)V", "getFile", "()Lcom/diffplug/selfie/guts/TypedPath;", "getLine", "()I", "getLiteral", "()Lcom/diffplug/selfie/guts/LiteralValue;", "compareTo", "other", "selfie-lib"})
    private static final class FileLineLiteral
    implements Comparable<FileLineLiteral> {
        @NotNull
        private final TypedPath file;
        private final int line;
        @NotNull
        private final LiteralValue<?> literal;

        public FileLineLiteral(@NotNull TypedPath file, int line, @NotNull LiteralValue<?> literal) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(literal, (String)"literal");
            this.file = file;
            this.line = line;
            this.literal = literal;
        }

        @NotNull
        public final TypedPath getFile() {
            return this.file;
        }

        public final int getLine() {
            return this.line;
        }

        @NotNull
        public final LiteralValue<?> getLiteral() {
            return this.literal;
        }

        @Override
        public int compareTo(@NotNull FileLineLiteral other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Function1[] function1Array = new Function1[]{FileLineLiteral::compareTo$lambda$0, FileLineLiteral::compareTo$lambda$1};
            return ComparisonsKt.compareValuesBy((Object)this, (Object)other, (Function1[])function1Array);
        }

        private static final Comparable compareTo$lambda$0(FileLineLiteral it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.file;
        }

        private static final Comparable compareTo$lambda$1(FileLineLiteral it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Integer.valueOf(it.line);
        }
    }
}

