/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.selfie.junit5;

import com.diffplug.selfie.junit5.SelfieSettingsSmuggleError;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\b\u0016\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/diffplug/selfie/junit5/SelfieSettingsAPI;", "", "<init>", "()V", "allowMultipleEquivalentWritesToOneLocation", "", "getAllowMultipleEquivalentWritesToOneLocation", "()Z", "snapshotFolderName", "", "getSnapshotFolderName", "()Ljava/lang/String;", "rootFolder", "Ljava/io/File;", "getRootFolder", "()Ljava/io/File;", "otherSourceRoots", "", "getOtherSourceRoots", "()Ljava/util/List;", "javaDontUseTripleQuoteLiterals", "getJavaDontUseTripleQuoteLiterals", "Companion", "selfie-runner-junit5"})
public class SelfieSettingsAPI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> STANDARD_DIRS;

    public boolean getAllowMultipleEquivalentWritesToOneLocation() {
        return true;
    }

    @Nullable
    public String getSnapshotFolderName() {
        return null;
    }

    @NotNull
    public File getRootFolder() {
        File userDir = new File(System.getProperty("user.dir"));
        for (String standardDir : STANDARD_DIRS) {
            File candidate = FilesKt.resolve((File)userDir, (String)standardDir);
            if (!candidate.isDirectory()) continue;
            return candidate;
        }
        throw new AssertionError((Object)("Could not find a standard test directory, 'user.dir' is equal to " + userDir + ", looked in " + STANDARD_DIRS));
    }

    @NotNull
    public List<File> getOtherSourceRoots() {
        List list;
        List $this$_get_otherSourceRoots__u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        File rootDir = this.getRootFolder();
        File userDir = new File(System.getProperty("user.dir"));
        for (String standardDir : STANDARD_DIRS) {
            File candidate = FilesKt.resolve((File)userDir, (String)standardDir);
            if (!candidate.isDirectory() || Intrinsics.areEqual((Object)candidate, (Object)rootDir)) continue;
            $this$_get_otherSourceRoots__u24lambda_u240.add(candidate);
        }
        return CollectionsKt.build((List)list);
    }

    public boolean getJavaDontUseTripleQuoteLiterals() {
        return false;
    }

    static {
        Object[] objectArray = new String[]{"src/test/java", "src/test/kotlin", "src/test/groovy", "src/test/scala", "src/test/resources"};
        STANDARD_DIRS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u0014\u0010\n\u001a\u00020\b2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/diffplug/selfie/junit5/SelfieSettingsAPI$Companion;", "", "<init>", "()V", "STANDARD_DIRS", "", "", "initialize", "Lcom/diffplug/selfie/junit5/SelfieSettingsAPI;", "initialize$selfie_runner_junit5", "instantiate", "clazz", "Ljava/lang/Class;", "selfie-runner-junit5"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SelfieSettingsAPI initialize$selfie_runner_junit5() {
            try {
                String settings = System.getProperty("selfie.settings");
                if (settings != null && !StringsKt.isBlank((CharSequence)settings)) {
                    try {
                        Class<?> clazz = Class.forName(settings);
                        Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(...)");
                        return this.instantiate(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        throw new Error("The system property selfie.settings was set to " + settings + ", but that class could not be found.", e);
                    }
                }
                try {
                    Class<?> clazz = Class.forName("selfie.SelfieSettings");
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(...)");
                    return this.instantiate(clazz);
                }
                catch (ClassNotFoundException e) {
                    return new SelfieSettingsAPI();
                }
            }
            catch (Throwable e) {
                return new SelfieSettingsSmuggleError(e);
            }
        }

        private final SelfieSettingsAPI instantiate(Class<?> clazz) {
            try {
                Object obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type com.diffplug.selfie.junit5.SelfieSettingsAPI");
                return (SelfieSettingsAPI)obj;
            }
            catch (InstantiationException e) {
                throw new AssertionError("Unable to instantiate " + clazz.getName() + ", is it abstract? Does it require arguments?", e);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

