/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.base.osgi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.osgi.framework.BundleActivator;

public abstract class BundleConfig<T extends Enum<T>> {
    private final List<Entry> config = new ArrayList<Entry>();

    protected BundleConfig() {
    }

    public void add(BundleActivator activator, int state) {
        this.config.add(new Entry(activator, state));
    }

    public List<Entry> get() {
        return this.config;
    }

    public void add(List<Entry> config) {
        this.config.addAll(config);
    }

    public void add(BundleActivator activator) {
        this.add(activator, 32);
    }

    public void add(Collection<BundleActivator> config) {
        config.stream().forEach(entry -> this.add((BundleActivator)entry));
    }

    public void add(T bundle) {
        this.add(this.create(bundle), this.getDefaultState(bundle));
    }

    public void add(T ... bundles) {
        Arrays.asList(bundles).forEach(bundle -> this.add((T)bundle));
    }

    public void add(T bundle, int state) {
        this.add(this.create(bundle), state);
    }

    public abstract void applyDefault();

    protected abstract BundleActivator create(T var1);

    protected abstract int getDefaultState(T var1);

    public static class Entry {
        public final BundleActivator activator;
        public final int state;

        public Entry(BundleActivator activator, int state) {
            this.activator = activator;
            this.state = state;
        }
    }
}

