/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.base.service;

import java.io.IOError;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.osgi.service.datalocation.Location;

public class TemporaryLocation
implements Location {
    private static final String TEMP_PREFIX = "com_diffplug_spotless_extra_eclipse";
    private final URL location;
    private Location parent;

    public TemporaryLocation() {
        this(null, TemporaryLocation.createTemporaryDirectory());
    }

    private TemporaryLocation(Location parent, URL defaultValue) {
        this.location = defaultValue;
        this.parent = parent;
    }

    private static URL createTemporaryDirectory() {
        try {
            Path locationPath = Files.createTempDirectory(TEMP_PREFIX, new FileAttribute[0]);
            locationPath.toFile().deleteOnExit();
            return locationPath.toUri().toURL();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public boolean allowsDefault() {
        return false;
    }

    public URL getDefault() {
        return null;
    }

    public Location getParentLocation() {
        return this.parent;
    }

    public URL getURL() {
        return this.location;
    }

    public boolean isSet() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean setURL(URL value, boolean lock) throws IllegalStateException {
        throw new IllegalStateException("URL not modifyable.");
    }

    public boolean set(URL value, boolean lock) throws IllegalStateException, IOException {
        throw new IllegalStateException("URL not modifyable.");
    }

    public boolean set(URL value, boolean lock, String lockFilePath) throws IllegalStateException, IOException {
        throw new IllegalStateException("URL not modifyable.");
    }

    public boolean lock() throws IOException {
        return false;
    }

    public void release() {
    }

    public boolean isLocked() throws IOException {
        return false;
    }

    public Location createLocation(Location parent, URL defaultValue, boolean readonly) {
        return new TemporaryLocation(parent, defaultValue);
    }

    public URL getDataArea(String path) throws IOException {
        try {
            Path locationPath = Paths.get(this.location.toURI());
            return locationPath.resolve(path).toUri().toURL();
        }
        catch (URISyntaxException e) {
            throw new IOException("Location not correctly formatted.", e);
        }
    }
}

