/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class ConvertLegacyProject {
    public static final String OLD_NATURE = "org.codehaus.groovy.eclipse.groovyNature";
    public static final String OLD_BUILDER = "org.codehaus.groovy.eclipse.groovyBuilder";
    public static final String GROOVY_NATURE = "org.eclipse.jdt.groovy.core.groovyNature";

    public void convertProjects(IProject[] projects) {
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            this.convertProject(project);
            ++n2;
        }
    }

    public void convertProject(IProject project) {
        try {
            IProjectDescription desc = project.getDescription();
            String[] natures = desc.getNatureIds();
            LinkedList<String> newNatures = new LinkedList<String>();
            String[] stringArray = natures;
            int n = natures.length;
            int n2 = 0;
            while (n2 < n) {
                String nature = stringArray[n2];
                if (!nature.equals(OLD_NATURE) && !nature.equals(GROOVY_NATURE)) {
                    newNatures.add(nature);
                }
                ++n2;
            }
            newNatures.add(0, GROOVY_NATURE);
            desc.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
            List<ICommand> builders = Arrays.asList(desc.getBuildSpec());
            ArrayList<Object> newBuilders = new ArrayList<Object>(builders.size());
            boolean javaBuilderFound = false;
            for (ICommand builder : builders) {
                if (builder.getBuilderName().equals(OLD_BUILDER)) continue;
                newBuilders.add(builder);
                if (!builder.getBuilderName().equals("org.eclipse.jdt.core.javabuilder")) continue;
                javaBuilderFound = true;
            }
            if (!javaBuilderFound) {
                BuildCommand newCommand = new BuildCommand();
                newCommand.setBuilderName("org.eclipse.jdt.core.javabuilder");
                newBuilders.add(newCommand);
            }
            desc.setBuildSpec(newBuilders.toArray(new ICommand[newBuilders.size()]));
            project.setDescription(desc, null);
        }
        catch (CoreException e) {
            GroovyCore.logException("Exception thrown when converting for legacy project " + project.getName(), e);
        }
    }

    public IProject[] getAllOldProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> legacyProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.isAccessible() && project.hasNature(OLD_NATURE)) {
                    legacyProjects.add(project);
                }
            }
            catch (CoreException e) {
                GroovyCore.logException("Exception thrown when checking for legacy projects", e);
            }
            ++n2;
        }
        return legacyProjects.toArray(new IProject[0]);
    }
}

