/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.search;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTClassNode;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.groovy.search.EqualityVisitor;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;

public class FindAllReferencesRequestor
implements ITypeRequestor {
    private final AnnotatedNode declaration;
    private final Map<ASTNode, Integer> references;
    public static final int F_WRITE_OCCURRENCE = 1;
    public static final int F_READ_OCCURRENCE = 2;

    public Map<ASTNode, Integer> getReferences() {
        return this.references;
    }

    public FindAllReferencesRequestor(AnnotatedNode declaration) {
        this.declaration = declaration;
        this.references = new TreeMap<ASTNode, Integer>(Comparator.comparing(ASTNode::getStart));
    }

    @Override
    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        if (node.getLength() < 1) {
            return ITypeRequestor.VisitStatus.CONTINUE;
        }
        if (node instanceof AnnotatedNode && !(node instanceof ImportNode) && !(node instanceof PackageNode)) {
            ASTNode maybeDeclaration = result.declaration;
            if (maybeDeclaration == null) {
                return ITypeRequestor.VisitStatus.CONTINUE;
            }
            if (maybeDeclaration instanceof ClassNode) {
                ClassNode script;
                if (!(node instanceof ClassExpression) && !(node instanceof ClassNode)) {
                    return ITypeRequestor.VisitStatus.CONTINUE;
                }
                if (node instanceof ClassNode && (script = (ClassNode)node).isScript() && script.getNameWithoutPackage().length() != script.getLength()) {
                    return ITypeRequestor.VisitStatus.CONTINUE;
                }
                maybeDeclaration = ((ClassNode)maybeDeclaration).redirect();
            }
            if (maybeDeclaration instanceof PropertyNode && ((PropertyNode)maybeDeclaration).getField() != null) {
                maybeDeclaration = ((PropertyNode)maybeDeclaration).getField();
            }
            if (this.isEquivalent(maybeDeclaration)) {
                int flag = EqualityVisitor.checkForAssignment(node, result.enclosingAssignment) ? 1 : 2;
                this.references.put(node, flag);
            }
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }

    private boolean isEquivalent(ASTNode maybeDeclaration) {
        if (maybeDeclaration == this.declaration) {
            return true;
        }
        if (maybeDeclaration instanceof FieldNode && this.declaration instanceof FieldNode) {
            FieldNode maybeField = (FieldNode)maybeDeclaration;
            FieldNode field = (FieldNode)this.declaration;
            return maybeField.getName().equals(field.getName()) && maybeField.getDeclaringClass().equals(field.getDeclaringClass());
        }
        if (maybeDeclaration instanceof MethodNode && this.declaration instanceof MethodNode) {
            MethodNode maybeMethod = (MethodNode)maybeDeclaration;
            MethodNode method = (MethodNode)this.declaration;
            return maybeMethod.getName().equals(method.getName()) && maybeMethod.getDeclaringClass().equals(method.getDeclaringClass()) && FindAllReferencesRequestor.checkParams(maybeMethod.getOriginal().getParameters(), method.getParameters());
        }
        if (maybeDeclaration instanceof InnerClassNode && this.declaration instanceof JDTClassNode || this.declaration instanceof InnerClassNode && maybeDeclaration instanceof JDTClassNode) {
            return ((ClassNode)maybeDeclaration).getName().equals(((ClassNode)this.declaration).getName());
        }
        return false;
    }

    private static boolean checkParams(Parameter[] maybeParameters, Parameter[] parameters) {
        if (maybeParameters == null) {
            return parameters == null;
        }
        if (parameters == null) {
            return false;
        }
        if (maybeParameters.length != parameters.length) {
            return false;
        }
        int i = 0;
        while (i < parameters.length) {
            if (!FindAllReferencesRequestor.typeEquals(maybeParameters[i], parameters[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean typeEquals(Parameter maybeParameter, Parameter parameter) {
        ClassNode maybeType = maybeParameter.getType();
        ClassNode type = parameter.getType();
        if (maybeType == null) {
            return type == null;
        }
        if (type == null) {
            return false;
        }
        return maybeType.getName().equals(type.getName());
    }
}

