/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.extract;

import java.util.Map;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class VariableRenamer
extends ClassCodeVisitorSupport {
    private MultiTextEdit edits = new MultiTextEdit();
    private Map<String, String> variablesToRename;

    public MultiTextEdit rename(MethodNode method, Map<String, String> variablesToRename) {
        this.variablesToRename = variablesToRename;
        method.getCode().visit(this);
        return this.edits;
    }

    @Override
    public void visitVariableExpression(VariableExpression expression) {
        String newName;
        Variable accessedVar = expression.getAccessedVariable();
        if (accessedVar instanceof DynamicVariable && (newName = this.variablesToRename.get(accessedVar.getName())) != null) {
            this.edits.addChild((TextEdit)new ReplaceEdit(expression.getStart(), expression.getLength(), newName));
        }
    }
}

