/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner;

import java.util.LinkedHashMap;
import java.util.Stack;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.eclipse.refactoring.core.utils.ASTTools;
import org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.ASTNodeInfo;
import org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.ASTScannerPredicate;
import org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.NodeNotFoundException;
import org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.predicates.IASTNodePredicate;
import org.eclipse.jface.text.IDocument;

public class ASTScanner
extends ASTScannerPredicate {
    protected IDocument document;
    private final LinkedHashMap<ASTNode, ASTNodeInfo> astMap;
    private final Stack<ASTNode> nodeStack;

    public ASTScanner(ModuleNode rootNode, IASTNodePredicate predicate, IDocument document) {
        super(rootNode, predicate);
        this.document = document;
        this.astMap = new LinkedHashMap();
        this.nodeStack = new Stack();
    }

    public void startASTscan() {
        if (this.astMap.isEmpty()) {
            this.scanAST();
        }
    }

    public ASTNodeInfo getInfo(ASTNode node) throws NodeNotFoundException {
        ASTNodeInfo ret = this.astMap.get(node);
        if (ret != null) {
            return ret;
        }
        if (node != null) {
            throw new NodeNotFoundException(node.getText());
        }
        throw new NodeNotFoundException("node was NULL");
    }

    public LinkedHashMap<ASTNode, ASTNodeInfo> getMatchedNodes() {
        return this.astMap;
    }

    @Override
    protected void doOnPredicate(ASTNode node) {
        ASTNodeInfo info = new ASTNodeInfo();
        if (!this.nodeStack.isEmpty() && this.nodeStack.peek() != node) {
            info.setParent(this.nodeStack.peek());
        }
        if (ASTTools.hasValidPosition(node)) {
            info.setOffset(node.getStart());
            info.setLength(node.getEnd() - node.getStart());
        }
        this.astMap.put(node, info);
        this.nodeStack.push(node);
    }

    @Override
    protected void clear(ASTNode node) {
        if (!this.nodeStack.isEmpty() && this.nodeStack.peek() == node) {
            this.nodeStack.pop();
        }
    }

    public boolean hasMatches() {
        return !this.astMap.isEmpty();
    }
}

