/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.jdt.groovy.model.GroovyClassFileWorkingCopy;
import org.codehaus.jdt.groovy.model.JavaCoreUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeReferenceMatch;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.search.matching.DeclarationOfReferencedTypesPattern;
import org.eclipse.jdt.internal.core.search.matching.JavaSearchPattern;
import org.eclipse.jdt.internal.core.search.matching.TypeReferencePattern;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.text.Position;

public class TypeReferenceSearchRequestor
implements ITypeRequestor {
    private final SearchRequestor requestor;
    private final SearchParticipant participant;
    private final boolean isCamelCase;
    private final boolean isCaseSensitive;
    private final boolean findDeclaration;
    private final char[] namePattern;
    private final char[] qualificationPattern;
    private final Set<Position> acceptedPositions = new HashSet<Position>();
    private char[] cachedContents;

    public TypeReferenceSearchRequestor(TypeReferencePattern pattern, SearchRequestor requestor, SearchParticipant participant) {
        this.requestor = requestor;
        this.participant = participant;
        this.isCamelCase = (Boolean)ReflectionUtils.getPrivateField(JavaSearchPattern.class, "isCamelCase", pattern);
        this.isCaseSensitive = (Boolean)ReflectionUtils.getPrivateField(JavaSearchPattern.class, "isCaseSensitive", pattern);
        this.findDeclaration = pattern instanceof DeclarationOfReferencedTypesPattern;
        this.namePattern = this.extractArray(pattern, "simpleName");
        this.qualificationPattern = this.extractArray(pattern, "qualification");
    }

    protected final char[] extractArray(TypeReferencePattern pattern, String fieldName) {
        char[] arr = (char[])ReflectionUtils.getPrivateField(TypeReferencePattern.class, fieldName, pattern);
        if (!this.isCaseSensitive) {
            arr = CharOperation.toLowerCase(arr);
        }
        return arr;
    }

    @Override
    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        Position position;
        if (!this.hasValidSourceLocation(node)) {
            return ITypeRequestor.VisitStatus.CONTINUE;
        }
        int start = -1;
        int until = -1;
        if (node instanceof ImportNode && !this.findDeclaration && !this.isCamelCase) {
            char[] pattern;
            String name = ((ImportNode)node).getType() == null ? ((ImportNode)node).getPackageName() : ((ImportNode)node).getType().getName();
            if (this.qualificationPattern != null && this.qualifiedNameMatches(name) && this.cachedContentsAvailable(enclosingElement) && (start = CharOperation.indexOf(pattern = CharOperation.concat(this.qualificationPattern, this.namePattern, '.'), this.cachedContents, this.isCaseSensitive, node.getStart(), node.getEnd())) != -1) {
                until = (start += this.qualificationPattern.length + 1) + this.namePattern.length;
            }
        } else if (node instanceof ClassNode || node instanceof ClassExpression || node instanceof AnnotationNode) {
            ClassNode type = node instanceof ClassExpression ? ((ClassExpression)node).getType() : (node instanceof AnnotationNode ? ((AnnotationNode)node).getClassNode() : result.type);
            if (this.qualifiedNameMatches((type = GroovyUtils.getBaseType(type)).getName())) {
                boolean rangeFound = false;
                if (node instanceof ClassExpression) {
                    start = node.getStart();
                    until = node.getEnd();
                } else if (node instanceof AnnotationNode) {
                    start = type.getStart();
                    until = type.getEnd();
                } else {
                    ClassNode classNode = (ClassNode)node;
                    if (classNode.getNameEnd() <= 0) {
                        if (classNode.redirect() == classNode) {
                            rangeFound = true;
                        } else {
                            classNode = this.maybeGetComponentType(classNode);
                            start = classNode.getStart();
                            until = classNode.getEnd();
                        }
                    }
                }
                if (!rangeFound) {
                    int[] range = this.getMatchLocation(type, enclosingElement, start, until);
                    if (range != null) {
                        start = range[0];
                        until = range[1];
                    } else {
                        until = -1;
                        start = -1;
                    }
                }
            }
        }
        if (start >= 0 && until > 0 && !this.acceptedPositions.contains(position = new Position(start, until - start))) {
            this.acceptedPositions.add(position);
            IJavaElement element = enclosingElement;
            if (enclosingElement.getOpenable() instanceof GroovyClassFileWorkingCopy) {
                element = ((GroovyClassFileWorkingCopy)enclosingElement.getOpenable()).convertToBinary(enclosingElement);
            }
            try {
                this.requestor.acceptSearchMatch(this.createMatch(result, element, start, until));
            }
            catch (CoreException e) {
                Util.log(e, "Error accepting search match for " + element);
            }
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }

    protected TypeReferenceMatch createMatch(TypeLookupResult result, IJavaElement enclosingElement, int start, int end) {
        IType type;
        IJavaElement element = enclosingElement;
        if (this.findDeclaration && (type = JavaCoreUtil.findType(GroovyUtils.getBaseType(result.type).getName(), enclosingElement)) != null) {
            element = type;
        }
        return new TypeReferenceMatch(element, this.getAccuracy(result.confidence), start, end - start, false, this.participant, element.getResource());
    }

    private boolean hasValidSourceLocation(ASTNode node) {
        ASTNode astNodeWithSourceLocation = node instanceof ClassNode ? this.maybeGetComponentType((ClassNode)node) : node;
        return astNodeWithSourceLocation.getEnd() > 0;
    }

    private ClassNode maybeGetComponentType(ClassNode orig) {
        ClassNode componentType;
        if (orig.getComponentType() != null && (componentType = orig.getComponentType()).getColumnNumber() != -1) {
            return componentType;
        }
        return orig;
    }

    private String[] splitQualifierAndSimpleName(String fullyQualifiedName) {
        int i = fullyQualifiedName.lastIndexOf(36);
        if (i < 0) {
            i = fullyQualifiedName.lastIndexOf(46);
        }
        return new String[]{i <= 0 ? "" : fullyQualifiedName.substring(0, i).replace('$', '.'), fullyQualifiedName.substring(i + 1)};
    }

    private boolean qualifiedNameMatches(String fullyQualifiedName) {
        String[] tuple = this.splitQualifierAndSimpleName(fullyQualifiedName);
        String name = tuple[1];
        String qualifier = tuple[0];
        boolean match = this.unqualifiedNameMatches(name);
        if (match) {
            match = this.isCamelCase ? CharOperation.camelCaseMatch(this.qualificationPattern, qualifier.toCharArray()) : CharOperation.match(this.qualificationPattern, qualifier.toCharArray(), this.isCaseSensitive);
        }
        if (!match && this.namePattern != null && this.qualificationPattern != null && qualifier.length() > this.namePattern.length + this.qualificationPattern.length) {
            char[] q = qualifier.toCharArray();
            int qualEnd = this.qualificationPattern.length;
            int nameEnd = this.qualificationPattern.length + this.namePattern.length + 1;
            if (!(q[qualEnd] != '.' && q[qualEnd] != '$' || q.length != nameEnd && q[nameEnd] != '.' && q[nameEnd] != '$' || !CharOperation.match(CharOperation.concat(this.qualificationPattern, this.namePattern, '?'), q, this.isCaseSensitive))) {
                match = true;
            }
        }
        return match;
    }

    private boolean unqualifiedNameMatches(String unqualifiedName) {
        boolean match = true;
        match = this.isCamelCase ? CharOperation.camelCaseMatch(this.namePattern, unqualifiedName.toCharArray()) : CharOperation.match(this.namePattern, unqualifiedName.toCharArray(), this.isCaseSensitive);
        return match;
    }

    private int[] getMatchLocation(ClassNode node, IJavaElement elem, int maybeStart, int maybeEnd) {
        if (maybeEnd > 0 && this.cachedContentsAvailable(elem)) {
            return this.getMatchLocation0(node.getName(), maybeStart, maybeEnd);
        }
        return null;
    }

    private int[] getMatchLocation0(String possiblyQualifiedName, int maybeStart, int maybeEnd) {
        String[] tuple = this.splitQualifierAndSimpleName(possiblyQualifiedName);
        String simpleName = tuple[1];
        if (simpleName.length() <= maybeEnd - maybeStart && this.unqualifiedNameMatches(simpleName)) {
            int until;
            int start = CharOperation.indexOf(possiblyQualifiedName.toCharArray(), this.cachedContents, this.isCaseSensitive, maybeStart, maybeEnd + 1);
            if (start != -1) {
                until = start + possiblyQualifiedName.length();
            } else {
                start = CharOperation.indexOf(simpleName.toCharArray(), this.cachedContents, this.isCaseSensitive, maybeStart, maybeEnd + 1);
                until = start + simpleName.length();
            }
            if (start != -1) {
                return new int[]{start, until};
            }
        } else if (tuple[0].length() > 0) {
            return this.getMatchLocation0(tuple[0], maybeStart, maybeEnd);
        }
        return null;
    }

    private boolean cachedContentsAvailable(IJavaElement elem) {
        CompilationUnit unit;
        if (this.cachedContents == null && (unit = (CompilationUnit)elem.getAncestor(5)) != null) {
            this.cachedContents = unit.getContents();
        }
        return this.cachedContents != null;
    }

    private boolean shouldAlwaysBeAccurate() {
        return this.requestor.getClass().getPackage().getName().indexOf("refactoring") != -1;
    }

    private int getAccuracy(TypeLookupResult.TypeConfidence confidence) {
        return this.shouldAlwaysBeAccurate() || confidence == TypeLookupResult.TypeConfidence.EXACT ? 0 : 1;
    }
}

