/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.compiler;

import groovy.lang.GroovySystem;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.codehaus.groovy.eclipse.chooser.CompilerChooser;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.frameworkadapter.util.SpecifiedVersion;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.groovy.core.Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class CompilerUtils {
    public static String getGroovyVersion() {
        return GroovySystem.getVersion();
    }

    public static Bundle getActiveGroovyBundle() {
        return CompilerChooser.getInstance().getActiveBundle();
    }

    public static SpecifiedVersion getActiveGroovyVersion() {
        return CompilerChooser.getInstance().getActiveSpecifiedVersion();
    }

    public static Version getBundleVersion(SpecifiedVersion version) {
        return CompilerChooser.getInstance().getAssociatedVersion(version);
    }

    public static boolean isGroovyVersionDisabledOrMissing(SpecifiedVersion version) {
        return CompilerUtils.getActiveGroovyVersion() == version;
    }

    public static SortedSet<SpecifiedVersion> getAllGroovyVersions() {
        SpecifiedVersion[] versions = CompilerChooser.getInstance().getAllSpecifiedVersions();
        TreeSet<SpecifiedVersion> allVersions = new TreeSet<SpecifiedVersion>();
        SpecifiedVersion[] specifiedVersionArray = versions;
        int n = versions.length;
        int n2 = 0;
        while (n2 < n) {
            SpecifiedVersion version = specifiedVersionArray[n2];
            allVersions.add(version);
            ++n2;
        }
        return allVersions;
    }

    public static IStatus switchVersions(SpecifiedVersion fromVersion, SpecifiedVersion toVersion) {
        try {
            CompilerChooser.getInstance().storeVersion(toVersion);
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            GroovyCore.logException(e.getMessage(), e);
            return new Status(4, "org.codehaus.groovy.eclipse.core", String.valueOf(e.getMessage()) + "\n\nSee the error log for more information.", (Throwable)e);
        }
    }

    public static String getDotGroovyLocation() {
        String home = System.getProperty("user.home");
        if (home != null) {
            home = String.valueOf(home) + "/.groovy";
        }
        return home;
    }

    private static String getDotGroovyLibLocation() {
        String home = CompilerUtils.getDotGroovyLocation();
        if (home != null) {
            home = String.valueOf(home) + "/lib";
        }
        return home;
    }

    public static SpecifiedVersion getCompilerLevel(IProject project) {
        String groovyCompilerLevelStr;
        SpecifiedVersion version = SpecifiedVersion.UNSPECIFIED;
        if (GroovyNature.hasGroovyNature(project) && (groovyCompilerLevelStr = Activator.getDefault().getGroovyCompilerLevel(project)) != null) {
            version = SpecifiedVersion.findVersionFromString((String)groovyCompilerLevelStr);
        }
        return version;
    }

    public static SpecifiedVersion getWorkspaceCompilerLevel() {
        String groovyVersion = CompilerUtils.getGroovyVersion();
        int dotIndex = groovyVersion.lastIndexOf(46);
        if (dotIndex > 0) {
            groovyVersion = groovyVersion.substring(0, dotIndex);
        }
        return SpecifiedVersion.findVersionFromString((String)groovyVersion);
    }

    public static void setCompilerLevel(IProject project, SpecifiedVersion projectLevel) {
        CompilerUtils.setCompilerLevel(project, projectLevel, false);
    }

    public static void setCompilerLevel(IProject project, SpecifiedVersion projectLevel, boolean assertCompatible) {
        Activator.getDefault().setGroovyCompilerLevel(project, projectLevel.versionName);
        if (assertCompatible) {
            if (CompilerUtils.projectVersionMatchesWorkspaceVersion(projectLevel)) {
                CompilerUtils.removeCompilermMismatchProblem(project);
            } else {
                CompilerUtils.addCompilerMismatchError(project, projectLevel);
            }
        }
    }

    public static void addCompilerMismatchError(IProject project, SpecifiedVersion projectLevel) {
        try {
            SpecifiedVersion workspaceLevel = CompilerUtils.getWorkspaceCompilerLevel();
            IMarker marker = project.getProject().createMarker("org.codehaus.groovy.eclipse.core.compilerMismatch");
            marker.setAttribute("message", (Object)("Groovy: compiler mismatch: project level is " + projectLevel.toReadableVersionString() + ", workspace level is " + workspaceLevel.toReadableVersionString()));
            marker.setAttribute("severity", 2);
            marker.setAttribute("location", (Object)project.getName());
        }
        catch (CoreException e) {
            GroovyCore.logException("Error checking Groovy project compiler level compatibility for " + project.getName(), e);
        }
    }

    public static void removeCompilermMismatchProblem(IProject project) {
        try {
            IMarker[] findMarkers;
            IMarker[] iMarkerArray = findMarkers = project.findMarkers("org.codehaus.groovy.eclipse.core.compilerMismatch", true, 0);
            int n = findMarkers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                marker.delete();
                ++n2;
            }
        }
        catch (CoreException e) {
            GroovyCore.logException("Error checking Groovy project compiler level compatibility for " + project.getName(), e);
        }
    }

    public static void addMultipleCompilersOnClasspathError(IProject project, SpecifiedVersion compiler1, SpecifiedVersion compiler2) {
        try {
            IMarker marker = project.getProject().createMarker("org.codehaus.groovy.eclipse.core.compilerMismatch");
            marker.setAttribute("message", (Object)("Multiple Groovy compilers found on classpath. Continuing with compilation will produce unpredictible results. Remove a compiler before continuing.\nFound " + compiler1.toReadableVersionString() + " and " + compiler2.toReadableVersionString()));
            marker.setAttribute("severity", 2);
            marker.setAttribute("location", (Object)project.getName());
        }
        catch (CoreException e) {
            GroovyCore.logException("Error checking Groovy project compiler level compatibility for " + project.getName(), e);
        }
    }

    public static boolean projectVersionMatchesWorkspaceVersion(SpecifiedVersion version) {
        if (version == SpecifiedVersion.UNSPECIFIED || version == SpecifiedVersion.DONT_CARE) {
            return true;
        }
        return version == CompilerUtils.getWorkspaceCompilerLevel();
    }

    public static IPath getExportedGroovyAllJar() {
        Bundle groovyBundle = CompilerUtils.getActiveGroovyBundle();
        for (URL jarUrl : Collections.list(groovyBundle.findEntries("lib", "groovy-*.jar", false))) {
            if (!jarUrl.getFile().matches(".+/groovy(?:-all)?-\\d+\\.\\d+\\.\\d+(?:-indy)?\\.jar")) continue;
            return CompilerUtils.toFilePath(jarUrl);
        }
        throw new RuntimeException("Could not find groovy jar");
    }

    public static List<IPath> getExtraJarsForClasspath() {
        ArrayList<IPath> jarPaths = new ArrayList<IPath>();
        Bundle groovyBundle = CompilerUtils.getActiveGroovyBundle();
        for (URL jarUrl : Collections.list(groovyBundle.findEntries("lib", "*.jar", false))) {
            if (jarUrl.getFile().endsWith("-javadoc.jar") || jarUrl.getFile().endsWith("-sources.jar")) continue;
            jarPaths.add(CompilerUtils.toFilePath(jarUrl));
        }
        jarPaths.remove(CompilerUtils.getExportedGroovyAllJar());
        return jarPaths;
    }

    public static IPath getJarInGroovyLib(String jarName) {
        Bundle groovyBundle = CompilerUtils.getActiveGroovyBundle();
        Enumeration enu = groovyBundle.findEntries("lib", jarName, false);
        if (enu != null && enu.hasMoreElements()) {
            return CompilerUtils.toFilePath((URL)enu.nextElement());
        }
        return null;
    }

    public static File[] findJarsInDotGroovyLocation() {
        File libDir;
        String home = CompilerUtils.getDotGroovyLibLocation();
        if (home != null && (libDir = new File(home)).isDirectory()) {
            File[] files = libDir.listFiles((dir, name) -> !new File(dir, name).isDirectory() && name.endsWith(".jar"));
            return files;
        }
        return new File[0];
    }

    private static IPath toFilePath(URL url) {
        try {
            url = FileLocator.toFileURL((URL)url);
            return new Path(url.getPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

