/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.model;

import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.RequiresDirective;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.core.CreateElementInCUOperation;
import org.eclipse.jdt.launching.JavaRuntime;

public class RequireModuleOperation
extends CreateElementInCUOperation {
    private final String moduleName;

    public static void requireModule(IJavaProject javaProject, String moduleName) throws CoreException {
        IModuleDescription moduleDesc = javaProject.getModuleDescription();
        if (moduleDesc != null && !Arrays.asList(moduleDesc.getRequiredModuleNames()).contains(moduleName)) {
            new RequireModuleOperation(moduleDesc, moduleName).run(null);
        }
    }

    public static void requireModule(IJavaProject javaProject, IType type) throws CoreException {
        IPackageFragmentRoot root = (IPackageFragmentRoot)type.getAncestor(3);
        if (JavaRuntime.isModule((IClasspathEntry)root.getResolvedClasspathEntry(), (IJavaProject)javaProject)) {
            IModuleDescription moduleDescription = root.getModuleDescription();
            if (moduleDescription == null) {
                moduleDescription = JavaCore.getAutomaticModuleDescription(root);
            }
            if (moduleDescription != null) {
                RequireModuleOperation.requireModule(javaProject, moduleDescription.getElementName());
            }
        }
    }

    private RequireModuleOperation(IModuleDescription moduleDesc, String moduleName) {
        super(moduleDesc);
        this.moduleName = moduleName;
    }

    @Override
    public String getMainTaskName() {
        return "Add \"requires " + this.moduleName + ";\"";
    }

    @Override
    protected StructuralPropertyDescriptor getChildPropertyDescriptor(ASTNode parent) {
        return ModuleDeclaration.MODULE_DIRECTIVES_PROPERTY;
    }

    @Override
    protected ASTNode generateElementAST(ASTRewrite rewriter, ICompilationUnit cu) throws JavaModelException {
        AST ast = this.cuAST.getAST();
        RequiresDirective requires = ast.newRequiresDirective();
        requires.setName(ast.newName(this.moduleName));
        return requires;
    }

    @Override
    protected IJavaElement generateResultHandle() {
        return this.getParentElement();
    }
}

