/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.extract;

import java.util.LinkedHashSet;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.eclipse.refactoring.core.utils.ASTVisitorDecorator;
import org.codehaus.groovy.syntax.Token;

public class ASTVariableScanner {
    private Set<Variable> declaredVariables = new LinkedHashSet<Variable>();
    private Set<Variable> declaredInblockVariables = new LinkedHashSet<Variable>();
    private Set<Variable> usedVariables = new LinkedHashSet<Variable>();
    private Set<Variable> returnVariables = new LinkedHashSet<Variable>();
    private Set<Variable> innerLoopAssignedVariables = new LinkedHashSet<Variable>();
    private boolean selectionIsInLoopOrClosure;

    public ASTVariableScanner(boolean blockIsInLoop) {
        this.selectionIsInLoopOrClosure = blockIsInLoop;
    }

    public Set<Variable> getDeclaratedVariables() {
        return this.declaredVariables;
    }

    public Set<Variable> getUsedVariables() {
        return this.usedVariables;
    }

    public Set<Variable> getAssignedVariables() {
        return this.returnVariables;
    }

    public Set<Variable> getInnerLoopAssignedVariables() {
        return this.innerLoopAssignedVariables;
    }

    public void visitNode(ASTNode node) {
        if (this.selectionIsInLoopOrClosure) {
            node.visit(new RepeatableBlockVisit(this));
        } else {
            node.visit(new DefaultVisit(this));
        }
    }

    private class AssignementInClosureVisit
    extends ClosureVisit {
        protected Token operator;

        AssignementInClosureVisit(ASTVariableScanner container, Token token) {
            super(container);
            this.operator = token;
        }

        @Override
        public void visitVariableExpression(VariableExpression expression) {
            super.visitVariableExpression(expression);
            this.checkAssertedVariables(expression, this.operator.getType());
        }
    }

    private class AssignmentInRepeatableBlockVisit
    extends RepeatableBlockVisit {
        protected Token operator;

        AssignmentInRepeatableBlockVisit(ASTVariableScanner container, Token operator) {
            super(container);
            this.operator = operator;
        }

        @Override
        public void visitVariableExpression(VariableExpression expression) {
            super.visitVariableExpression(expression);
            this.checkAssertedVariables(expression, this.operator.getType());
        }
    }

    private class ClosureVisit
    extends RepeatableBlockVisit {
        ClosureVisit(ASTVariableScanner container) {
            super(container);
        }

        @Override
        public void visitVariableExpression(VariableExpression expression) {
            Variable var = expression.getAccessedVariable();
            if (var instanceof Parameter && ((Parameter)var).getEnd() <= 0 && var.getName().equals("it")) {
                ASTVariableScanner.this.declaredInblockVariables.add(var);
            }
            super.visitVariableExpression(expression);
        }

        @Override
        public void visitBinaryExpression(BinaryExpression expression) {
            expression.getLeftExpression().visit(new AssignementInClosureVisit((ASTVariableScanner)this.container, expression.getOperation()));
            expression.getRightExpression().visit(this);
        }

        @Override
        public void visitPostfixExpression(PostfixExpression expression) {
            expression.getExpression().visit(new AssignementInClosureVisit((ASTVariableScanner)this.container, expression.getOperation()));
        }

        @Override
        public void visitPrefixExpression(PrefixExpression expression) {
            expression.getExpression().visit(new AssignementInClosureVisit((ASTVariableScanner)this.container, expression.getOperation()));
        }
    }

    private class DefaultAssignementVisit
    extends DefaultVisit {
        protected Token operator;

        DefaultAssignementVisit(ASTVariableScanner container, Token token) {
            super(container);
            this.operator = token;
        }

        @Override
        public void visitVariableExpression(VariableExpression expression) {
            super.visitVariableExpression(expression);
            if (expression.getEnd() < 1) {
                return;
            }
            Variable var = expression.getAccessedVariable();
            if (this.operator.getType() != 30) {
                ASTVariableScanner.this.returnVariables.add(var);
            }
        }
    }

    private class DefaultVisit
    extends ASTVisitorDecorator<ASTVariableScanner> {
        DefaultVisit(ASTVariableScanner container) {
            super(container);
        }

        @Override
        public void visitVariableExpression(VariableExpression expression) {
            super.visitVariableExpression(expression);
            Variable var = expression.getAccessedVariable();
            if (expression.getEnd() < 1) {
                return;
            }
            if (var != null && !(var instanceof FieldNode) && !ASTVariableScanner.this.declaredVariables.contains(var)) {
                ASTVariableScanner.this.usedVariables.add(var);
            }
        }

        @Override
        public void visitDeclarationExpression(DeclarationExpression expression) {
            Variable var = expression.getVariableExpression().getAccessedVariable();
            if (var != null) {
                ASTVariableScanner.this.declaredVariables.add(var);
            }
            super.visitDeclarationExpression(expression);
        }

        @Override
        public void visitForLoop(ForStatement forLoop) {
            if (forLoop.getVariable() != null) {
                ASTVariableScanner.this.declaredInblockVariables.add(forLoop.getVariable());
            }
            forLoop.getCollectionExpression().visit(new RepeatableBlockVisit((ASTVariableScanner)this.container));
            forLoop.getLoopBlock().visit(new RepeatableBlockVisit((ASTVariableScanner)this.container));
        }

        @Override
        public void visitWhileLoop(WhileStatement loop) {
            loop.getLoopBlock().visit(new RepeatableBlockVisit((ASTVariableScanner)this.container));
        }

        @Override
        public void visitDoWhileLoop(DoWhileStatement loop) {
            loop.getLoopBlock().visit(new RepeatableBlockVisit((ASTVariableScanner)this.container));
        }

        @Override
        public void visitIfElse(IfStatement ifElse) {
            ifElse.getIfBlock().visit(new InnerBlockVisit((ASTVariableScanner)this.container));
            ifElse.getElseBlock().visit(new InnerBlockVisit((ASTVariableScanner)this.container));
        }

        @Override
        public void visitClosureExpression(ClosureExpression expression) {
            if (expression.isParameterSpecified()) {
                Parameter[] parameterArray = expression.getParameters();
                int n = parameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Parameter p = parameterArray[n2];
                    ASTVariableScanner.this.declaredInblockVariables.add(p);
                    ++n2;
                }
            }
            expression.getCode().visit(new ClosureVisit((ASTVariableScanner)this.container));
        }

        @Override
        public void visitBinaryExpression(BinaryExpression expression) {
            if (expression.getLeftExpression() instanceof VariableExpression) {
                expression.getLeftExpression().visit(new DefaultAssignementVisit((ASTVariableScanner)this.container, expression.getOperation()));
            } else {
                expression.getLeftExpression().visit(this);
            }
            expression.getRightExpression().visit(this);
        }

        @Override
        public void visitPostfixExpression(PostfixExpression expression) {
            expression.getExpression().visit(new DefaultAssignementVisit((ASTVariableScanner)this.container, expression.getOperation()));
        }

        @Override
        public void visitPrefixExpression(PrefixExpression expression) {
            expression.getExpression().visit(new DefaultAssignementVisit((ASTVariableScanner)this.container, expression.getOperation()));
        }

        protected boolean isUsed(Variable var) {
            return ASTVariableScanner.this.declaredVariables.contains(var) || ASTVariableScanner.this.declaredInblockVariables.contains(var);
        }
    }

    private class InnerBlockVisit
    extends DefaultVisit {
        InnerBlockVisit(ASTVariableScanner container) {
            super(container);
        }

        @Override
        public void visitVariableExpression(VariableExpression expression) {
            if (expression.getEnd() < 1) {
                return;
            }
            Variable var = expression.getAccessedVariable();
            if (!(var == null || var instanceof FieldNode || ASTVariableScanner.this.declaredInblockVariables.contains(var) || ASTVariableScanner.this.declaredVariables.contains(var))) {
                ASTVariableScanner.this.usedVariables.add(var);
            }
        }
    }

    private class RepeatableBlockVisit
    extends InnerBlockVisit {
        RepeatableBlockVisit(ASTVariableScanner container) {
            super(container);
        }

        protected void checkAssertedVariables(VariableExpression expression, int operatorTokenType) {
            if (operatorTokenType == 30) {
                return;
            }
            Variable var = expression.getAccessedVariable();
            if (var != null && this.isUsed(var)) {
                ASTVariableScanner.this.returnVariables.add(var);
            }
            if (ASTVariableScanner.this.usedVariables.contains(var)) {
                ASTVariableScanner.this.innerLoopAssignedVariables.add(var);
            }
        }

        @Override
        public void visitBinaryExpression(BinaryExpression expression) {
            expression.getLeftExpression().visit(new AssignmentInRepeatableBlockVisit((ASTVariableScanner)this.container, expression.getOperation()));
            expression.getRightExpression().visit(new RepeatableBlockVisit((ASTVariableScanner)this.container));
        }

        @Override
        public void visitPostfixExpression(PostfixExpression expression) {
            expression.getExpression().visit(new AssignmentInRepeatableBlockVisit((ASTVariableScanner)this.container, expression.getOperation()));
        }

        @Override
        public void visitPrefixExpression(PrefixExpression expression) {
            expression.getExpression().visit(new AssignmentInRepeatableBlockVisit((ASTVariableScanner)this.container, expression.getOperation()));
        }

        @Override
        public void visitIfElse(IfStatement ifElse) {
            ifElse.getIfBlock().visit(this);
            ifElse.getElseBlock().visit(this);
        }
    }
}

