/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.extract;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentKind;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.BinaryExpressionFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.FragmentVisitor;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.IASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.MethodCallFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.PropertyExpressionFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.SimpleExpressionASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.groovy.eclipse.codebrowsing.selection.FindAllOccurrencesVisitor;
import org.codehaus.groovy.eclipse.codebrowsing.selection.FindSurroundingNode;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.refactoring.core.utils.ASTTools;
import org.codehaus.groovy.eclipse.refactoring.core.utils.StatusHelper;
import org.codehaus.groovy.eclipse.refactoring.formatter.DefaultGroovyFormatter;
import org.codehaus.groovy.eclipse.refactoring.formatter.FormatterPreferences;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.ExtractLocalDescriptor;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class ExtractGroovyLocalRefactoring
extends Refactoring {
    private static final String[] KNOWN_METHOD_NAME_PREFIXES = new String[]{"get", "is", "to", "set"};
    private static final String ATTRIBUTE_REPLACE = "replace";
    private IASTFragment selectedExpression;
    private GroovyCompilationUnit unit;
    private ModuleNode module;
    private int start = -1;
    private int length = -1;
    private String localName;
    private boolean replaceAllOccurrences;
    private CompilationUnitChange change;
    private Map<IASTFragment, List<IASTFragment>> allParentStack;
    private List<IASTFragment> matchingFragments;

    public ExtractGroovyLocalRefactoring(JavaRefactoringArguments arguments, RefactoringStatus status) {
    }

    public ExtractGroovyLocalRefactoring(GroovyCompilationUnit unit, int offset, int length) {
        this.unit = unit;
        this.start = offset;
        this.length = length;
        this.module = unit.getModuleNode();
    }

    public String getName() {
        return "Extract to local variable" + (this.isReplaceAllOccurrences() ? " (replace all occurrences)" : "");
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        Assert.isNotNull((Object)localName);
        this.localName = localName;
    }

    public boolean isReplaceAllOccurrences() {
        return this.replaceAllOccurrences;
    }

    public void setReplaceAllOccurrences(boolean replaceAllOccurrences) {
        this.replaceAllOccurrences = replaceAllOccurrences;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException {
        RefactoringStatus status;
        SubMonitor submon = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.ExtractTempRefactoring_checking_preconditions, (int)5);
        IASTFragment astFragment = this.getSelectedFragment();
        if (astFragment == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_select_expression, (RefactoringStatusContext)StatusHelper.createContext(this.unit, new SourceRange(this.start, this.length)));
        }
        submon.worked(1);
        int trimmedLength = astFragment.getTrimmedLength(this.unit);
        int exprLength = astFragment.getLength();
        if (astFragment.getStart() != this.start || this.length > exprLength || this.length < trimmedLength) {
            return RefactoringStatus.createFatalErrorStatus((String)"Must select a full expression", (RefactoringStatusContext)StatusHelper.createContext(this.unit, new SourceRange(this.start, this.length)));
        }
        submon.worked(1);
        try {
            try {
                status = (RefactoringStatus)Checks.class.getDeclaredMethod("validateModifiesFiles", IFile[].class, Object.class, IProgressMonitor.class).invoke(Checks.class, ResourceUtil.getFiles((ICompilationUnit[])new ICompilationUnit[]{this.unit}), this.getValidationContext(), submon.split(4));
            }
            catch (NoSuchMethodException e) {
                status = (RefactoringStatus)Checks.class.getDeclaredMethod("validateModifiesFiles", IFile[].class, Object.class).invoke(Checks.class, ResourceUtil.getFiles((ICompilationUnit[])new ICompilationUnit[]{this.unit}), this.getValidationContext());
                submon.worked(1);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        if (status.hasFatalError()) {
            return status;
        }
        if (this.module == null) {
            status.addFatalError("Cannot build module node for file.  Possible syntax error.");
            return status;
        }
        submon.worked(1);
        status.merge(this.checkExpression());
        if (status.hasFatalError()) {
            return status;
        }
        submon.worked(1);
        return status;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException {
        SubMonitor submon = SubMonitor.convert((IProgressMonitor)monitor, (String)"Checking postconditions...", (int)4);
        RefactoringStatus result = new RefactoringStatus();
        this.change = this.doCreateChange(result, (IProgressMonitor)submon.split(2));
        if (this.getExcludedVariableNames().contains(this.getLocalName())) {
            result.addWarning(RefactoringCoreMessages.bind((String)RefactoringCoreMessages.ExtractTempRefactoring_another_variable, (Object)BasicElementLabels.getJavaElementName((String)this.getLocalName())));
        }
        result.merge(this.checkMatchingFragments());
        this.change.setKeepPreviewEdits(true);
        return result;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        ExtractLocalDescriptor descriptor = this.createRefactoringDescriptor();
        this.change.setDescriptor((ChangeDescriptor)new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor));
        return this.change;
    }

    public RefactoringStatus checkLocalNameOnChange(String newName) {
        Assert.isTrue((boolean)newName.equals(this.getLocalName()));
        String selectedText = this.getTextAt(this.getSelectedFragment().getStart(), this.getSelectedFragment().getEnd());
        if (newName.equals(selectedText)) {
            return RefactoringStatus.createFatalErrorStatus((String)"Extracted variable name must be different from original text");
        }
        return Checks.checkTempName((String)newName, (IJavaElement)this.unit);
    }

    public String[] guessLocalNames() {
        String text = this.getBaseNameFromExpression(this.getSelectedFragment());
        String[] excludedNames = this.getExcludedVariableNames().toArray(CharOperation.NO_STRINGS);
        return NamingConventions.suggestVariableNames(5, 1, text, this.unit.getJavaProject(), 0, excludedNames, true);
    }

    private Set<String> getExcludedVariableNames() {
        HashSet<String> usedNames = new HashSet<String>();
        if (this.getSelectedFragment() != null) {
            Set<Variable> vars = ASTTools.getVariablesInScope(this.module, this.getSelectedFragment().getAssociatedExpression());
            for (Variable v : vars) {
                usedNames.add(v.getName());
            }
            String selectedText = this.getTextAt(this.getSelectedFragment().getStart(), this.getSelectedFragment().getEnd());
            if (JavaConventionsUtil.validateIdentifier((String)selectedText, null) == Status.OK_STATUS) {
                usedNames.add(selectedText);
            }
        }
        return usedNames;
    }

    private RefactoringStatus checkMatchingFragments() {
        RefactoringStatus result = new RefactoringStatus();
        List<IASTFragment> matchingExprs = this.getMatchingExpressions();
        for (IASTFragment matchingExpr : matchingExprs) {
            if (this.isDeclaration(matchingExpr)) {
                String msg = "The selected expression is a declaration.  Extracting may cause an error.";
                result.addError(msg, StatusHelper.createContext(this.unit, new SourceRange(matchingExpr.getStart(), matchingExpr.getLength())));
            }
            if (!this.isLeftValue(matchingExpr)) continue;
            result.addWarning(RefactoringCoreMessages.ExtractTempRefactoring_assigned_to, StatusHelper.createContext(this.unit, new SourceRange(matchingExpr.getStart(), matchingExpr.getLength())));
        }
        return result;
    }

    private boolean isDeclaration(IASTFragment fragment) {
        Expression expression = fragment.getAssociatedExpression();
        return expression instanceof VariableExpression && ((VariableExpression)expression).getAccessedVariable() == expression;
    }

    private boolean isLeftValue(IASTFragment fragment) {
        return fragment.kind() == ASTFragmentKind.BINARY && ((BinaryExpressionFragment)fragment).getToken().isA(1100);
    }

    private List<IASTFragment> getMatchingExpressions() {
        if (this.matchingFragments != null) {
            return this.matchingFragments;
        }
        IASTFragment origFragment = this.getSelectedFragment();
        List<IASTFragment> parentStack = this.getParentStack(origFragment);
        AnnotatedNode limitTo = null;
        for (IASTFragment fragment : parentStack) {
            ASTNode astNode = fragment.getAssociatedNode();
            if (astNode instanceof FieldNode) {
                limitTo = (FieldNode)astNode;
                break;
            }
            if (astNode instanceof MethodNode) {
                limitTo = (MethodNode)astNode;
                break;
            }
            if (astNode instanceof ClassNode) {
                limitTo = (ClassNode)astNode;
                break;
            }
            if (!(astNode instanceof ModuleNode)) continue;
            limitTo = ((ModuleNode)astNode).getScriptClassDummy();
        }
        if (this.replaceAllOccurrences) {
            FindAllOccurrencesVisitor v = new FindAllOccurrencesVisitor(this.unit.getModuleNode(), limitTo);
            this.matchingFragments = v.findOccurrences(origFragment);
        } else {
            this.matchingFragments = Collections.singletonList(origFragment);
        }
        return this.matchingFragments;
    }

    private CompilationUnitChange doCreateChange(RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        CompilationUnitChange newChange = new CompilationUnitChange("Extract Local Variable", (ICompilationUnit)this.unit);
        newChange.setEdit((TextEdit)new MultiTextEdit());
        this.createTempDeclaration(newChange, status);
        if (!status.hasFatalError()) {
            this.addReplaceExpressionWithTemp(newChange);
        }
        return newChange;
    }

    private void addReplaceExpressionWithTemp(CompilationUnitChange newChange) {
        List<IASTFragment> matchingExpressions = this.replaceAllOccurrences ? this.getMatchingExpressions() : Collections.singletonList(this.getSelectedFragment());
        for (IASTFragment matchingExpr : matchingExpressions) {
            TextEditGroup group = new TextEditGroup(RefactoringCoreMessages.ExtractTempRefactoring_replace_occurrences);
            ReplaceEdit edit = new ReplaceEdit(matchingExpr.getStart(), matchingExpr.getLength(), this.getLocalName());
            group.addTextEdit((TextEdit)edit);
            newChange.addChangeGroup((TextEditBasedChangeGroup)new TextEditChangeGroup((TextChange)newChange, group));
            newChange.addEdit((TextEdit)edit);
        }
    }

    private void createTempDeclaration(CompilationUnitChange newChange, RefactoringStatus status) {
        List<IASTFragment> matchingExpressions = this.replaceAllOccurrences ? this.getMatchingExpressions() : Collections.singletonList(this.getSelectedFragment());
        int insertLoc = this.insertAt(matchingExpressions, status);
        if (insertLoc == -1 && !status.hasFatalError()) {
            status.addFatalError("Could not find a suitable extraction location", this.createContext());
        }
        if (status.hasFatalError()) {
            return;
        }
        int lineStart = this.findLineStart(insertLoc);
        String prefix = this.getTextAt(lineStart, insertLoc);
        TextEditGroup group = new TextEditGroup(RefactoringCoreMessages.ExtractTempRefactoring_declare_local_variable);
        InsertEdit edit = new InsertEdit(lineStart, this.createExpressionText(prefix, status));
        group.addTextEdit((TextEdit)edit);
        newChange.addChangeGroup((TextEditBasedChangeGroup)new TextEditChangeGroup((TextChange)newChange, group));
        newChange.addEdit((TextEdit)edit);
    }

    private String getTextAt(int start, int end) {
        char[] contents = this.unit.getContents();
        if (start >= 0 && end > start && end < contents.length) {
            return String.valueOf(contents, start, end - start);
        }
        return "";
    }

    private int insertAt(List<IASTFragment> matchingExpressions, RefactoringStatus status) {
        int insertLoc;
        ArrayList<List<IASTFragment>> parentsStack = new ArrayList<List<IASTFragment>>(matchingExpressions.size());
        IASTFragment firstExpression = null;
        for (IASTFragment matchingExpr : matchingExpressions) {
            if (firstExpression == null || matchingExpr.getStart() < firstExpression.getStart()) {
                firstExpression = matchingExpr;
            }
            parentsStack.add(this.getParentStack(matchingExpr));
        }
        IASTFragment[] commonPrefix = this.getLongestStackPrefix(parentsStack);
        if (commonPrefix.length == 0) {
            status.addFatalError("Could not find a common root for extracted occurrences.", this.createContext());
            return -1;
        }
        ASTNode firstCommonStatement = null;
        IASTFragment[] iASTFragmentArray = commonPrefix;
        int n = commonPrefix.length;
        int n2 = 0;
        while (n2 < n) {
            IASTFragment fragment = iASTFragmentArray[n2];
            if (fragment.getAssociatedNode() instanceof Statement) {
                firstCommonStatement = (Statement)fragment.getAssociatedNode();
                break;
            }
            ++n2;
        }
        if (firstCommonStatement instanceof BlockStatement) {
            insertLoc = -1;
            List<IASTFragment> firstParentStack = this.getParentStack(firstExpression);
            int j = 1;
            while (j < firstParentStack.size()) {
                if (firstParentStack.get(j).getAssociatedNode() == firstCommonStatement) {
                    insertLoc = firstParentStack.get(j - 1).getStart();
                    break;
                }
                ++j;
            }
        } else {
            insertLoc = firstCommonStatement != null ? firstCommonStatement.getStart() : -1;
        }
        return insertLoc;
    }

    private int findLineStart(int insertLoc) {
        char[] contents = this.unit.getContents();
        while (insertLoc > 0 && contents[insertLoc - 1] != '\n' && contents[insertLoc - 1] != '\r') {
            --insertLoc;
        }
        return insertLoc;
    }

    private IASTFragment[] getLongestStackPrefix(List<List<IASTFragment>> parentsStack) {
        int prefixLength = -1;
        if (parentsStack.isEmpty()) {
            return new IASTFragment[0];
        }
        int minArrayLength = parentsStack.get(0).size();
        int i = 1;
        while (i < parentsStack.size()) {
            minArrayLength = Math.min(minArrayLength, parentsStack.get(i).size());
            ++i;
        }
        i = 0;
        while (i < minArrayLength) {
            if (!this.allStacksEqual(parentsStack, i)) break;
            ++prefixLength;
            ++i;
        }
        if (prefixLength <= -1) {
            return new IASTFragment[0];
        }
        return this.getStackPrefix(parentsStack.get(0), prefixLength);
    }

    private IASTFragment[] getStackPrefix(List<IASTFragment> stack, int length) {
        IASTFragment[] array = new IASTFragment[length + 1];
        int i = 0;
        while (i <= length) {
            array[length - i] = stack.get(stack.size() - 1 - i);
            ++i;
        }
        return array;
    }

    private boolean allStacksEqual(List<List<IASTFragment>> parentsStack, int i) {
        IASTFragment candidate = parentsStack.get(0).get(parentsStack.get(0).size() - 1 - i);
        for (List<IASTFragment> stack : parentsStack) {
            if (stack.get(stack.size() - 1 - i).getAssociatedNode() == candidate.getAssociatedNode()) continue;
            return false;
        }
        return true;
    }

    private List<IASTFragment> getParentStack(IASTFragment expr) {
        if (this.allParentStack == null) {
            this.allParentStack = new HashMap<IASTFragment, List<IASTFragment>>();
        } else if (this.allParentStack.containsKey(expr)) {
            return this.allParentStack.get(expr);
        }
        FindSurroundingNode find = new FindSurroundingNode(new Region(expr), FindSurroundingNode.VisitKind.PARENT_STACK);
        find.doVisitSurroundingNode(this.module);
        ArrayList<IASTFragment> parentStack = new ArrayList<IASTFragment>(find.getParentStack());
        Collections.reverse(parentStack);
        this.allParentStack.put(expr, parentStack);
        return parentStack;
    }

    private String createExpressionText(String prefix, RefactoringStatus status) {
        StringBuilder sb = new StringBuilder();
        sb.append("def ").append(this.getLocalName()).append(" = ").append(this.getTextAt(this.getSelectedFragment().getStart(), this.getSelectedFragment().getEnd()));
        Document doc = new Document(sb.toString());
        DefaultGroovyFormatter formatter = new DefaultGroovyFormatter((IDocument)doc, new FormatterPreferences(this.unit), 0);
        try {
            formatter.format().apply((IDocument)doc);
        }
        catch (MalformedTreeException e) {
            GroovyCore.logException("Exception during extract local variable refactoring", e);
            status.addFatalError(e.getMessage(), this.createContext());
        }
        catch (BadLocationException e) {
            GroovyCore.logException("Exception during extract local variable refactoring", e);
            status.addFatalError(e.getMessage(), this.createContext());
        }
        String declarationExpression = String.valueOf(prefix) + doc.get() + ASTTools.getLineDelimeter(this.unit);
        return declarationExpression;
    }

    private RefactoringStatus checkExpression() throws JavaModelException {
        RefactoringStatus status = new RefactoringStatus();
        IASTFragment selectedFragment = this.getSelectedFragment();
        status.merge(this.checkExpressionFragmentIsRValue(selectedFragment));
        if (status.hasFatalError()) {
            return status;
        }
        if (selectedFragment instanceof ConstantExpression && ((ConstantExpression)selectedFragment).isNullExpression()) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_null_literals));
        }
        return status;
    }

    private RefactoringStatus checkExpressionFragmentIsRValue(IASTFragment fragment) throws JavaModelException {
        if (this.isDeclaration(fragment)) {
            return RefactoringStatus.createFatalErrorStatus((String)"Target expression is a variable declaration.  Cannot extract.");
        }
        if (this.isLeftValue(fragment)) {
            return RefactoringStatus.createFatalErrorStatus((String)"Target expression is target of an assignment.  Cannot extract.");
        }
        return new RefactoringStatus();
    }

    private RefactoringStatusContext createContext() {
        try {
            IJavaElement elt = this.unit.getElementAt(this.start);
            if (elt instanceof IMember) {
                return StatusHelper.createContext((IMember)elt);
            }
        }
        catch (JavaModelException e) {
            GroovyCore.logException("Error finding refactoring context", (Throwable)((Object)e));
        }
        return null;
    }

    private IASTFragment getSelectedFragment() {
        if (this.selectedExpression != null) {
            return this.selectedExpression;
        }
        FindSurroundingNode finder = new FindSurroundingNode(new Region(this.start, this.length), FindSurroundingNode.VisitKind.SURROUNDING_NODE);
        IASTFragment fragment = finder.doVisitSurroundingNode(this.unit.getModuleNode());
        if (ASTFragmentKind.isExpressionKind((IASTFragment)fragment)) {
            this.selectedExpression = fragment;
        }
        return this.selectedExpression;
    }

    private String getBaseNameFromExpression(IASTFragment assignedFragment) {
        if (assignedFragment == null) {
            return "local";
        }
        GuessBaseNameVisitor visitor = new GuessBaseNameVisitor();
        assignedFragment.accept((FragmentVisitor)visitor);
        return visitor.getGuessedName();
    }

    private ExtractLocalDescriptor createRefactoringDescriptor() {
        String project = null;
        IJavaProject javaProject = this.unit.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        String description = RefactoringCoreMessages.bind((String)RefactoringCoreMessages.ExtractTempRefactoring_descriptor_description_short, (Object)BasicElementLabels.getJavaElementName((String)this.getLocalName()));
        String expression = this.getTextAt(this.getSelectedFragment().getStart(), this.getSelectedFragment().getEnd());
        String header = RefactoringCoreMessages.bind((String)RefactoringCoreMessages.ExtractTempRefactoring_descriptor_description, (Object)BasicElementLabels.getJavaElementName((String)this.getLocalName()), (Object)BasicElementLabels.getJavaCodeString((String)expression));
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
        comment.addSetting(RefactoringCoreMessages.bind((String)RefactoringCoreMessages.ExtractTempRefactoring_name_pattern, (Object)BasicElementLabels.getJavaElementName((String)this.getLocalName())));
        comment.addSetting(RefactoringCoreMessages.bind((String)RefactoringCoreMessages.ExtractTempRefactoring_expression_pattern, (Object)BasicElementLabels.getJavaCodeString((String)expression)));
        if (this.replaceAllOccurrences) {
            comment.addSetting(RefactoringCoreMessages.ExtractTempRefactoring_replace_occurrences);
        }
        HashMap<String, String> arguments = new HashMap<String, String>();
        ExtractLocalDescriptor descriptor = RefactoringSignatureDescriptorFactory.createExtractLocalDescriptor((String)project, (String)description, (String)comment.asString(), arguments, (int)0);
        arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle((String)project, (IJavaElement)this.unit));
        arguments.put("name", this.getLocalName());
        arguments.put("selection", String.valueOf(this.start) + " " + this.length);
        arguments.put(ATTRIBUTE_REPLACE, Boolean.valueOf(this.replaceAllOccurrences).toString());
        return descriptor;
    }

    private static class GuessBaseNameVisitor
    extends FragmentVisitor {
        StringBuilder sb = new StringBuilder();

        private GuessBaseNameVisitor() {
        }

        String getGuessedName() {
            String name = this.sb.toString();
            if (name.length() == 0) {
                name = "local";
            } else {
                int i = 0;
                while (i < KNOWN_METHOD_NAME_PREFIXES.length) {
                    String curr = KNOWN_METHOD_NAME_PREFIXES[i];
                    if (name.startsWith(curr)) {
                        if (name.equals(curr)) {
                            return "local";
                        }
                        if (Character.isUpperCase(name.charAt(curr.length()))) {
                            return name.substring(curr.length());
                        }
                    }
                    ++i;
                }
                try {
                    Integer.parseInt(name);
                    name = "_" + name;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (name.length() > 0) {
                name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            }
            return name;
        }

        public boolean visit(BinaryExpressionFragment fragment) {
            String nextPart = this.nameFromExpression(fragment.getAssociatedExpression());
            if (nextPart != null) {
                this.sb.append(nextPart);
            }
            return true;
        }

        public boolean visit(MethodCallFragment fragment) {
            String nextPart = this.nameFromExpression(fragment.getAssociatedExpression());
            if (nextPart != null) {
                this.sb.append(nextPart);
            }
            return true;
        }

        public boolean visit(PropertyExpressionFragment fragment) {
            String nextPart = this.nameFromExpression(fragment.getAssociatedExpression());
            if (nextPart != null) {
                this.sb.append(nextPart);
            }
            return true;
        }

        public boolean visit(SimpleExpressionASTFragment fragment) {
            String nextPart = this.nameFromExpression(fragment.getAssociatedExpression());
            if (nextPart != null) {
                this.sb.append(nextPart);
            }
            return true;
        }

        private String nameFromExpression(Expression expr) {
            String name = null;
            if (expr instanceof CastExpression) {
                expr = ((CastExpression)expr).getExpression();
            }
            if (expr instanceof ConstantExpression) {
                name = ((ConstantExpression)expr).getText();
            } else if (expr instanceof MethodCallExpression) {
                name = ((MethodCallExpression)expr).getMethodAsString();
            } else if (expr instanceof StaticMethodCallExpression) {
                name = ((StaticMethodCallExpression)expr).getMethod();
            } else if (expr instanceof BinaryExpression) {
                name = String.valueOf(this.nameFromExpression(((BinaryExpression)expr).getLeftExpression())) + this.nameFromExpression(((BinaryExpression)expr).getRightExpression());
            } else if (expr instanceof Variable) {
                name = ((Variable)((Object)expr)).getName();
            }
            if (name != null && name.length() > 0) {
                name = MetaClassHelper.capitalize(name);
            }
            return name;
        }
    }
}

