/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.formatter;

import groovyjarjarantlr.Token;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.antlr.GroovyTokenTypeBridge;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.ASTScanner;
import org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.predicates.ClosuresInCodePredicate;
import org.codehaus.groovy.eclipse.refactoring.formatter.DefaultGroovyFormatter;
import org.codehaus.groovy.eclipse.refactoring.formatter.GroovyFormatter;
import org.codehaus.groovy.eclipse.refactoring.formatter.IFormatterPreferences;
import org.codehaus.groovy.eclipse.refactoring.formatter.KlenkDocumentScanner;
import org.codehaus.groovy.eclipse.refactoring.formatter.ListInCodePredicate;
import org.codehaus.groovy.eclipse.refactoring.formatter.SemicolonRemover;
import org.codehaus.groovy.eclipse.refactoring.formatter.lineWrap.CorrectLineWrap;
import org.codehaus.groovy.eclipse.refactoring.formatter.lineWrap.NextLine;
import org.codehaus.groovy.eclipse.refactoring.formatter.lineWrap.SameLine;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class GroovyBeautifier {
    private static final boolean DEBUG_EDITS = false;
    public final DefaultGroovyFormatter formatter;
    private final IFormatterPreferences preferences;
    private final Set<Token> ignoreToken = new HashSet<Token>();

    public GroovyBeautifier(DefaultGroovyFormatter formatter, IFormatterPreferences preferences) {
        this.formatter = formatter;
        this.preferences = preferences;
    }

    public TextEdit getBeautifiEdits() throws BadLocationException {
        try {
            MultiTextEdit edits = new MultiTextEdit();
            this.combineClosures(edits);
            this.formatLists(edits);
            this.correctBraces(edits);
            this.removeUnnecessarySemicolons(edits);
            MultiTextEdit multiTextEdit = edits;
            return multiTextEdit;
        }
        finally {
            this.formatter.getTokens().dispose();
        }
    }

    private void combineClosures(MultiTextEdit edits) throws BadLocationException {
        ASTScanner scanner = new ASTScanner(this.formatter.getProgressRootNode(), new ClosuresInCodePredicate(), this.formatter.getProgressDocument());
        scanner.startASTscan();
        for (ASTNode node : scanner.getMatchedNodes().keySet()) {
            ClosureExpression clExp = (ClosureExpression)node;
            int posClStart = this.formatter.getPosOfToken(GroovyTokenTypeBridge.LCURLY, clExp.getLineNumber(), clExp.getColumnNumber(), "{");
            if (posClStart == -1) continue;
            int posCLEnd = this.formatter.getPosOfToken(GroovyTokenTypeBridge.RCURLY, clExp.getLastLineNumber(), clExp.getLastColumnNumber() - 1, "}");
            if (posCLEnd == -1) {
                int positionLastTokenOfClosure = this.formatter.getPosOfToken(clExp.getLastLineNumber(), clExp.getLastColumnNumber());
                while (this.formatter.getTokens().get(positionLastTokenOfClosure).getType() != GroovyTokenTypeBridge.RCURLY) {
                    --positionLastTokenOfClosure;
                }
                posCLEnd = positionLastTokenOfClosure;
            }
            if (clExp.getLineNumber() == clExp.getLastLineNumber()) {
                this.ignoreToken.add(this.formatter.getTokens().get(posCLEnd));
                continue;
            }
            if (!(clExp.getCode() instanceof BlockStatement)) continue;
            int posParamDelim = posClStart;
            if (clExp.isParameterSpecified()) {
                posParamDelim = this.formatter.getPosOfNextTokenOfType(posClStart, GroovyTokenTypeBridge.CLOSABLE_BLOCK_OP);
                this.replaceNLSWithSpace(edits, posClStart, posParamDelim);
            }
            if (posParamDelim > 0 && this.formatter.getNextTokenIncludingNLS(posParamDelim).getType() != GroovyTokenTypeBridge.NLS) {
                this.addEdit((TextEdit)new InsertEdit(this.formatter.getOffsetOfTokenEnd(this.formatter.getTokens().get(posParamDelim)), this.formatter.getNewLine()), (TextEdit)edits);
                continue;
            }
            if (posParamDelim != 0 || this.formatter.getNextTokenIncludingNLS(posClStart).getType() == GroovyTokenTypeBridge.NLS) continue;
            this.addEdit((TextEdit)new InsertEdit(this.formatter.getOffsetOfTokenEnd(this.formatter.getTokens().get(posClStart)), this.formatter.getNewLine()), (TextEdit)edits);
        }
    }

    private void formatLists(MultiTextEdit edits) {
        ASTScanner scanner = new ASTScanner(this.formatter.getProgressRootNode(), new ListInCodePredicate(), this.formatter.getProgressDocument());
        scanner.startASTscan();
        for (ASTNode node : scanner.getMatchedNodes().keySet()) {
            ListExpression listExpr = (ListExpression)node;
            KlenkDocumentScanner tokens = this.formatter.getTokens();
            try {
                int lbrackOffset = listExpr.getStart();
                int rbrackOffset = listExpr.getEnd() - 1;
                while (Character.isWhitespace(this.formatter.getProgressDocument().getChar(rbrackOffset))) {
                    --rbrackOffset;
                }
                assert (this.formatter.getProgressDocument().getChar(lbrackOffset) == '[');
                assert (this.formatter.getProgressDocument().getChar(rbrackOffset) == ']');
                Token penultimate = tokens.getLastNonWhitespaceTokenBefore(rbrackOffset);
                if (penultimate.getType() == GroovyTokenTypeBridge.STRING_CTOR_START) continue;
                boolean wrap = rbrackOffset - lbrackOffset > this.preferences.getLongListLength() || listExpr.getExpressions().size() > 1 && this.hasClosureElement(listExpr);
                for (Expression exp : listExpr.getExpressions()) {
                    Token previous = tokens.getLastTokenBefore(exp.getStart());
                    while (previous.getType() != GroovyTokenTypeBridge.LBRACK && previous.getType() != GroovyTokenTypeBridge.COMMA) {
                        previous = tokens.getLastTokenBefore(previous);
                    }
                    String prefix = wrap ? this.formatter.getNewLine() : (previous.getType() == GroovyTokenTypeBridge.LBRACK ? "" : " ");
                    this.replaceWhiteSpaceAfter(edits, previous, prefix);
                }
                String suffix = wrap || penultimate.getType() == GroovyTokenTypeBridge.SL_COMMENT ? this.formatter.getNewLine() : "";
                this.replaceWhiteSpaceAfter(edits, penultimate, suffix);
            }
            catch (Exception e) {
                Util.log(e);
            }
        }
    }

    private void replaceWhiteSpaceAfter(MultiTextEdit edits, Token token, String replaceWith) {
        KlenkDocumentScanner tokens = this.formatter.getTokens();
        try {
            Token first;
            int editStart = tokens.getEnd(token);
            Token last = first = tokens.getNextToken(token);
            while (this.isWhiteSpace(last.getType())) {
                last = tokens.getNextToken(last);
            }
            this.replaceFromTo(editStart, tokens.getOffset(last), replaceWith, edits);
        }
        catch (BadLocationException e) {
            Util.log(e);
        }
    }

    private boolean isWhiteSpace(int type) {
        return type == GroovyTokenTypeBridge.WS || type == GroovyTokenTypeBridge.NLS;
    }

    private boolean hasClosureElement(ListExpression node) {
        List<Expression> list = node.getExpressions();
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) instanceof ClosureExpression) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void replaceNLSWithSpace(MultiTextEdit container, int startPos, int endPos) throws BadLocationException {
        Token token;
        Token fromToken = null;
        int p = startPos + 1;
        while (p < endPos) {
            token = this.formatter.getTokens().get(p);
            int ttype = token.getType();
            if (ttype == GroovyTokenTypeBridge.NLS) {
                if (fromToken == null) {
                    fromToken = token;
                }
            } else {
                if (ttype == GroovyTokenTypeBridge.SL_COMMENT) {
                    ++p;
                }
                if (fromToken != null) {
                    this.replaceFromTo(fromToken, token, " ", container);
                    fromToken = null;
                }
            }
            ++p;
        }
        if (fromToken != null) {
            token = this.formatter.getTokens().get(p);
            this.replaceFromTo(fromToken, token, " ", container);
        }
    }

    private void replaceFromTo(Token fromToken, Token toToken, String with, MultiTextEdit container) throws BadLocationException {
        int startEdit = this.formatter.getOffsetOfToken(fromToken);
        int endEdit = this.formatter.getOffsetOfToken(toToken);
        this.addEdit((TextEdit)new ReplaceEdit(startEdit, endEdit - startEdit, with), (TextEdit)container);
    }

    private void replaceFromTo(int startEdit, int endEdit, String with, MultiTextEdit container) {
        this.addEdit((TextEdit)new ReplaceEdit(startEdit, endEdit - startEdit, with), (TextEdit)container);
    }

    private void correctBraces(MultiTextEdit edits) throws BadLocationException {
        CorrectLineWrap lCurlyCorrector = null;
        CorrectLineWrap rCurlyCorrector = null;
        if (this.preferences.getBracesStart() == 0) {
            lCurlyCorrector = new SameLine(this);
        } else if (this.preferences.getBracesStart() == 1) {
            lCurlyCorrector = new NextLine(this);
        }
        if (this.preferences.getBracesEnd() == 0) {
            rCurlyCorrector = new SameLine(this);
        } else if (this.preferences.getBracesEnd() == 1) {
            rCurlyCorrector = new NextLine(this);
        }
        assert (lCurlyCorrector != null);
        assert (rCurlyCorrector != null);
        KlenkDocumentScanner tokens = this.formatter.getTokens();
        assert (tokens != null);
        boolean skipNextNLS = false;
        int i = 0;
        while (i < tokens.size()) {
            Token token = tokens.get(i);
            if (!this.ignoreToken.contains(token)) {
                int tokenType = token.getType();
                if (tokenType == GroovyTokenTypeBridge.LCURLY) {
                    if (skipNextNLS) {
                        skipNextNLS = false;
                        break;
                    }
                    ClosureExpression maybeClosure = this.formatter.findCorrespondingClosure(token);
                    if (maybeClosure == null || maybeClosure.getLineNumber() != maybeClosure.getLastLineNumber()) {
                        int type;
                        Token nextToken;
                        this.addEdit((TextEdit)lCurlyCorrector.correctLineWrap(i, token), (TextEdit)edits);
                        ASTNode node = this.formatter.findCorrespondingNode(token);
                        if (!(node != null && (node instanceof ClosureExpression || node instanceof CastExpression || node instanceof ArgumentListExpression) || (nextToken = tokens.getNextToken(token)) == null || (type = nextToken.getType()) == GroovyTokenTypeBridge.NLS || type == GroovyTokenTypeBridge.RCURLY)) {
                            int start = tokens.getEnd(token);
                            int end = tokens.getOffset(nextToken);
                            this.addEdit((TextEdit)new ReplaceEdit(start, end - start, this.formatter.getNewLine()), (TextEdit)edits);
                        }
                    }
                } else if (tokenType == GroovyTokenTypeBridge.RCURLY) {
                    if (skipNextNLS) {
                        skipNextNLS = false;
                    } else {
                        Token previousToken = tokens.getLastTokenBefore(token);
                        if (previousToken.getType() != GroovyTokenTypeBridge.LCURLY) {
                            this.addEdit((TextEdit)rCurlyCorrector.correctLineWrap(i, token), (TextEdit)edits);
                        }
                    }
                } else if (tokenType == GroovyTokenTypeBridge.SL_COMMENT) {
                    skipNextNLS = true;
                }
            }
            ++i;
        }
    }

    private void removeUnnecessarySemicolons(MultiTextEdit edits) throws BadLocationException {
        if (this.preferences.isRemoveUnnecessarySemicolons()) {
            SemicolonRemover semicolonRemover = new SemicolonRemover(this.formatter.selection, this.formatter.document, edits);
            ((GroovyFormatter)semicolonRemover).format();
        }
    }

    private void addEdit(TextEdit edit, TextEdit container) {
        if (edit != null && edit.getOffset() >= this.formatter.formatOffset && edit.getOffset() + edit.getLength() <= this.formatter.formatOffset + this.formatter.formatLength) {
            try {
                container.addChild(edit);
            }
            catch (MalformedTreeException malformedTreeException) {
                // empty catch block
            }
        }
    }
}

