/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.GString;
import groovy.lang.GroovyObject;
import java.io.IOException;
import java.io.Writer;
import org.apache.groovy.ast.tools.ImmutablePropertyUtils;
import org.codehaus.groovy.runtime.GStringUtil;

public class GStringImpl
extends GString {
    private static final long serialVersionUID = 3581289038662723858L;
    private final String[] strings;
    private final boolean frozen;
    private boolean cacheable;
    private String cachedStringLiteral;

    public GStringImpl(Object[] values, String[] strings) {
        this(values, strings, GStringImpl.checkValuesImmutable(values), null, false);
    }

    protected GStringImpl(Object[] values, String[] strings, boolean cacheable, String cachedStringLiteral, boolean frozen) {
        super(frozen ? (Object[])values.clone() : values);
        this.strings = frozen ? (String[])strings.clone() : strings;
        this.cacheable = cacheable;
        this.cachedStringLiteral = cachedStringLiteral;
        this.frozen = frozen;
    }

    @Override
    public GString plus(GString that) {
        GString thatFrozen = that instanceof GStringImpl ? ((GStringImpl)that).freeze() : that;
        return GStringUtil.plusImpl(super.getValues(), thatFrozen.getValues(), this.strings, thatFrozen.getStrings());
    }

    @Override
    public Writer writeTo(Writer out) throws IOException {
        return GStringUtil.writeToImpl(out, super.getValues(), this.strings);
    }

    @Override
    public void build(GroovyObject builder) {
        GStringUtil.buildImpl(builder, super.getValues(), this.strings);
    }

    @Override
    protected int calcInitialCapacity() {
        return GStringUtil.calcInitialCapacityImpl(super.getValues(), this.strings);
    }

    public GString freeze() {
        return new GStringImpl(super.getValues(), this.strings, this.cacheable, this.cachedStringLiteral, true);
    }

    @Override
    public String[] getStrings() {
        if (this.frozen) {
            return (String[])this.strings.clone();
        }
        this.cacheable = false;
        this.cachedStringLiteral = null;
        return this.strings;
    }

    @Override
    public Object[] getValues() {
        if (this.frozen) {
            return (Object[])super.getValues().clone();
        }
        this.cacheable = false;
        this.cachedStringLiteral = null;
        return super.getValues();
    }

    @Override
    public String toString() {
        if (null != this.cachedStringLiteral) {
            return this.cachedStringLiteral;
        }
        String str = super.toString();
        if (this.cacheable) {
            this.cachedStringLiteral = str;
        }
        return str;
    }

    private static boolean checkValuesImmutable(Object[] values) {
        for (Object value : values) {
            if (null == value || ImmutablePropertyUtils.builtinOrMarkedImmutableClass(value.getClass()) || value instanceof GStringImpl && ((GStringImpl)value).cacheable) continue;
            return false;
        }
        return true;
    }
}

