/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.integration.internal;

import java.util.Collections;
import org.codehaus.jdt.groovy.integration.internal.GroovyIndexingVisitor;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyParser;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.SourceElementNotifier;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.core.search.indexing.IndexingParser;
import org.eclipse.jdt.internal.core.util.Messages;

class MultiplexingIndexingParser
extends IndexingParser {
    private final SourceElementNotifier notifier = (SourceElementNotifier)ReflectionUtils.getPrivateField(SourceElementParser.class, "notifier", this);
    private final boolean reportReferenceInfo;
    private ISourceElementRequestor requestor;

    MultiplexingIndexingParser(ISourceElementRequestor requestor, IProblemFactory problemFactory, CompilerOptions options, boolean reportLocalDeclarations, boolean optimizeStringLiterals, boolean useSourceJavadocParser) {
        super(requestor, problemFactory, options, reportLocalDeclarations, optimizeStringLiterals, useSourceJavadocParser);
        this.reportReferenceInfo = reportLocalDeclarations;
        this.requestor = requestor;
    }

    @Override
    public void setRequestor(ISourceElementRequestor requestor) {
        super.setRequestor(requestor);
        this.requestor = requestor;
    }

    @Override
    public CompilationUnitDeclaration parseCompilationUnit(ICompilationUnit compilationUnit, boolean fullParse, IProgressMonitor pm) {
        if (GroovyParser.isGroovyParserEligible(compilationUnit, this.readManager)) {
            char[] contents = GroovyParser.getContents(compilationUnit, this.readManager);
            String fileName = CharOperation.charToString(compilationUnit.getFileName());
            CompilationResult compilationResult = new CompilationResult(compilationUnit, 0, 1, this.options.maxProblemsPerUnit);
            GroovyCompilationUnitDeclaration gcud = new GroovyParser(this.options, this.problemReporter, false, true).dietParse(contents, fileName, compilationResult);
            if (pm != null && pm.isCanceled()) {
                throw new OperationCanceledException(Messages.operation_cancelled);
            }
            new GroovyIndexingVisitor(this.requestor).visitModule(gcud.getModuleNode());
            this.notifier.notifySourceElementRequestor(gcud, 0, contents.length, this.reportReferenceInfo, gcud.sourceEnds, Collections.emptyMap());
            return gcud;
        }
        return super.parseCompilationUnit(compilationUnit, fullParse, pm);
    }
}

