/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.model;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.core.util.Util;

public class GroovyProjectFacade {
    private IJavaProject project;

    @Deprecated
    public GroovyProjectFacade(IJavaElement element) {
        this(element.getJavaProject());
    }

    @Deprecated
    public GroovyProjectFacade(IJavaProject project) {
        this.project = project;
    }

    public IJavaProject getProject() {
        return this.project;
    }

    private static boolean hasAppropriateArgsForMain(String[] params) {
        String typeName;
        if (params == null || params.length != 1) {
            return false;
        }
        int array = Signature.getArrayCount(params[0]);
        if (array == 1) {
            typeName = "String";
        } else if (array == 0) {
            typeName = "Object";
        } else {
            return false;
        }
        String sigNoArray = Signature.getElementType(params[0]);
        String name = Signature.getSignatureSimpleName(sigNoArray);
        String qual = Signature.getSignatureQualifier(sigNoArray);
        return name.equals(typeName) && (qual == null || qual.isEmpty() || "java.lang".equals(qual));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasGroovyMainMethod(IType type) {
        try {
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IMethod method = iMethodArray[n2];
                if (method.getElementName().equals("main") && Flags.isStatic(method.getFlags()) && (method.getReturnType().equals("V") || method.getReturnType().endsWith("java.lang.Object;")) && GroovyProjectFacade.hasAppropriateArgsForMain(method.getParameterTypes())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            Util.log((Throwable)((Object)e), "Exception searching for main method in " + type);
        }
        return false;
    }

    public static boolean isGroovyScript(IType type) {
        ModuleNode module = (ModuleNode)Adapters.adapt((Object)type.getCompilationUnit(), ModuleNode.class);
        if (module != null) {
            for (ClassNode classNode : module.getClasses()) {
                if (!classNode.getNameWithoutPackage().equals(type.getElementName())) continue;
                return classNode.isScript();
            }
        }
        return false;
    }
}

