/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.ClosureSignatureHint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.jdt.groovy.control.EclipseSourceUnit;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.GenericsMapper;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.core.util.Util;

public class TypeLookupResult {
    public final TypeConfidence confidence;
    public final ClassNode declaringType;
    public final ClassNode type;
    public final ASTNode declaration;
    public final VariableScope scope;
    public final String extraDoc;
    public boolean isGroovy;
    public AnnotationNode enclosingAnnotation;
    public BinaryExpression enclosingAssignment;

    public TypeLookupResult(ClassNode type, ClassNode declaringType, ASTNode declaration, TypeConfidence confidence, VariableScope scope) {
        this(type, declaringType, declaration, confidence, scope, null);
    }

    public TypeLookupResult(ClassNode type, ClassNode declaringType, ASTNode declaration, TypeConfidence confidence, VariableScope scope, String extraDoc) {
        this.confidence = confidence;
        this.type = type;
        this.declaringType = declaringType;
        this.declaration = declaration;
        this.scope = scope;
        this.extraDoc = extraDoc;
    }

    public TypeLookupResult resolveTypeParameterization(ClassNode objExprType, boolean isStatic) {
        if (this.declaringType != null && (this.declaration instanceof FieldNode || this.declaration instanceof PropertyNode || this.declaration instanceof MethodNode && !(this.declaration instanceof ConstructorNode))) {
            ClassNode objectType = objExprType;
            if (objectType == null) {
                objectType = this.isGroovy || !isStatic ? this.scope.getDelegateOrThis() : this.declaringType;
            }
            if (ClassHelper.isPrimitiveType(objectType)) {
                objectType = ClassHelper.getWrapper(objectType);
            }
            if (!(this.declaration instanceof MethodNode)) {
                GenericsMapper mapper = GenericsMapper.gatherGenerics(objectType, this.declaringType);
                ClassNode maybe = VariableScope.resolveTypeParameterization(mapper, VariableScope.clone(this.type));
                if (!maybe.toString(false).equals(this.type.toString(false))) {
                    TypeLookupResult result = new TypeLookupResult(maybe, this.declaringType, this.declaration, this.confidence, this.scope, this.extraDoc);
                    result.enclosingAnnotation = this.enclosingAnnotation;
                    result.isGroovy = this.isGroovy;
                    return result;
                }
            } else {
                GenericsMapper mapper;
                MethodNode method = (MethodNode)this.declaration;
                if (!isStatic && method.getName().equals("getClass") && method.getParameters().length == 0) {
                    ClassNode classType = VariableScope.clone(method.getReturnType());
                    classType.getGenericsTypes()[0].setUpperBounds(new ClassNode[]{objectType});
                    return new TypeLookupResult(classType, method.getDeclaringClass(), method, this.confidence, this.scope, this.extraDoc);
                }
                if (!GroovyUtils.isUsingGenerics(method) || !GenericsUtils.hasUnresolvedGenerics(method.getReturnType()) && !GroovyUtils.getParameterTypes(method.getParameters()).stream().anyMatch(GenericsUtils::hasUnresolvedGenerics)) {
                    return this;
                }
                ArrayList<ClassNode> argumentTypes = new ArrayList<ClassNode>();
                if (this.isGroovy) {
                    argumentTypes.add(objectType);
                }
                ClassNode targetType = null;
                if (this.scope.getEnclosingNode() instanceof MethodPointerExpression) {
                    mapper = GenericsMapper.gatherGenerics(argumentTypes, objectType, method, new GenericsType[0]);
                    method = VariableScope.resolveTypeParameterization(mapper, method);
                    VariableScope.CallAndType cat = this.scope.getEnclosingMethodCallExpression();
                    if (cat != null && cat.declaration instanceof MethodNode && cat.call.getArguments() instanceof TupleExpression) {
                        int index = ((TupleExpression)cat.call.getArguments()).getExpressions().indexOf(this.scope.getEnclosingNode());
                        Parameter[] params = ((MethodNode)cat.declaration).getParameters();
                        if (index != -1 && params.length > 0) {
                            targetType = params[Math.min(index, params.length - 1)].getType();
                            if (targetType.isArray() && index >= params.length - 1) {
                                targetType = objectType.getComponentType();
                            }
                            if (targetType.equals(VariableScope.CLOSURE_CLASS_NODE)) {
                                MethodNode source = method;
                                Parameter target = params[Math.min(index, params.length - 1)];
                                method = TypeLookupResult.findClosureSignature(target, source, this.scope.getEnclosingModuleNode().getContext(), cat.call).map(types -> {
                                    GenericsMapper gm = GenericsMapper.gatherGenerics(Arrays.asList(types), callAndType.declaringType, source, new GenericsType[0]);
                                    MethodNode mn = VariableScope.resolveTypeParameterization(gm, source);
                                    return mn;
                                }).orElse(method);
                            }
                        }
                    } else if (TypeLookupResult.testEnclosingAssignment(this.scope, rhs -> rhs == this.scope.getEnclosingNode())) {
                        targetType = this.scope.getEnclosingAssignment().getLeftExpression().getType();
                    }
                    if (targetType != null) {
                        if (targetType.equals(VariableScope.CLOSURE_CLASS_NODE)) {
                            ClassNode returnType = Optional.of(targetType).map(ClassNode::getGenericsTypes).filter(Objects::nonNull).map(gts -> gts[0].getType()).orElse(VariableScope.OBJECT_CLASS_NODE);
                            mapper = GenericsMapper.gatherGenerics(Collections.singletonList(returnType), this.declaringType, TypeLookupResult.returnTypeStub(method), new GenericsType[0]);
                            method = VariableScope.resolveTypeParameterization(mapper, method);
                        } else {
                            MethodNode sam = ClassHelper.findSAM(targetType);
                            if (sam != null) {
                                mapper = GenericsMapper.gatherGenerics(GroovyUtils.getParameterTypes(sam.getParameters()), this.declaringType, method, new GenericsType[0]);
                                method = VariableScope.resolveTypeParameterization(mapper, method);
                                mapper = GenericsMapper.gatherGenerics(targetType);
                                method = VariableScope.resolveTypeParameterization(mapper, method);
                            }
                        }
                    }
                } else {
                    if (this.scope.getMethodCallArgumentTypes() != null) {
                        argumentTypes.addAll(this.scope.getMethodCallArgumentTypes());
                    }
                    mapper = GenericsMapper.gatherGenerics(argumentTypes, objectType, method, this.scope.getMethodCallGenericsTypes());
                    method = VariableScope.resolveTypeParameterization(mapper, method);
                    if (this.scope.getMethodCallGenericsTypes() == null && GenericsUtils.hasUnresolvedGenerics(method.getReturnType()) && argumentTypes.size() == (this.isGroovy ? 1 : 0) && TypeLookupResult.testEnclosingAssignment(this.scope, rhs -> rhs instanceof StaticMethodCallExpression && rhs == this.scope.getCurrentNode() || rhs instanceof MethodCallExpression && ((MethodCallExpression)rhs).getMethod() == this.scope.getCurrentNode())) {
                        targetType = this.scope.getEnclosingAssignment().getLeftExpression().getType();
                        mapper = GenericsMapper.gatherGenerics(Collections.singletonList(targetType), this.declaringType, TypeLookupResult.returnTypeStub(method), new GenericsType[0]);
                        method = VariableScope.resolveTypeParameterization(mapper, method);
                    }
                }
                ClassNode returnType = method.getReturnType();
                if (method.getGenericsTypes() != null && this.scope.getMethodCallGenericsTypes() == null && GenericsUtils.hasUnresolvedGenerics(returnType) && (mapper = GenericsMapper.gatherGenerics(returnType)).hasGenerics()) {
                    returnType = VariableScope.resolveTypeParameterization(mapper.fillPlaceholders(method.getGenericsTypes()), VariableScope.clone(returnType.redirect()));
                }
                if (method != this.declaration || returnType != method.getReturnType()) {
                    TypeLookupResult result = new TypeLookupResult(returnType, method.getDeclaringClass(), method, this.confidence, this.scope, this.extraDoc);
                    result.enclosingAnnotation = this.enclosingAnnotation;
                    result.isGroovy = this.isGroovy;
                    return result;
                }
            }
        }
        return this;
    }

    private static MethodNode returnTypeStub(MethodNode node) {
        MethodNode stub = new MethodNode("", 0, VariableScope.VOID_CLASS_NODE, new Parameter[]{new Parameter(node.getReturnType(), "")}, null, null);
        stub.setDeclaringClass(node.getDeclaringClass());
        stub.setGenericsTypes(node.getGenericsTypes());
        return stub;
    }

    private static boolean testEnclosingAssignment(VariableScope scope, Predicate<Expression> rhsTest) {
        return Optional.ofNullable(scope.getEnclosingAssignment()).filter(bexp -> bexp instanceof DeclarationExpression).map(BinaryExpression::getRightExpression).filter(rhsTest).isPresent();
    }

    private static Optional<ClassNode[]> findClosureSignature(Parameter target, MethodNode source, SourceUnit unit, MethodCall call) {
        return GroovyUtils.getAnnotations(target, VariableScope.CLOSURE_PARAMS.getName()).findFirst().map(cp -> {
            try {
                Class hint = (Class)StaticTypeCheckingSupport.evaluateExpression(GeneralUtils.castX(VariableScope.CLASS_CLASS_NODE, cp.getMember("value")), unit.getConfiguration());
                String[] opts = (String[])(cp.getMember("options") == null ? ClosureParams.class.getMethod("options", new Class[0]).getDefaultValue() : StaticTypeCheckingSupport.evaluateExpression(GeneralUtils.castX(VariableScope.STRING_CLASS_NODE.makeArray(), cp.getMember("options")), unit.getConfiguration()));
                List<ClassNode[]> sigs = ((ClosureSignatureHint)hint.newInstance()).getClosureSignatures(source, unit, ((EclipseSourceUnit)sourceUnit).resolver.compilationUnit, opts, (Expression)((Object)call));
                if (sigs != null) {
                    List<ClassNode> parameterTypes = GroovyUtils.getParameterTypes(source.getParameters());
                    for (ClassNode[] sig : sigs) {
                        if (sig.length != parameterTypes.size() || !IntStream.range(0, sig.length).allMatch(i -> GroovyUtils.isAssignable(sig[i], (ClassNode)parameterTypes.get(i)))) continue;
                        return sig;
                    }
                }
            }
            catch (Exception | LinkageError e) {
                Util.log(e, "Error processing @ClosureParams of " + call.getMethodAsString());
            }
            return null;
        });
    }

    public static enum TypeConfidence {
        EXACT,
        INFERRED,
        LOOSELY_INFERRED,
        UNKNOWN;


        public static TypeConfidence findLessPrecise(TypeConfidence left, TypeConfidence right) {
            return left.isLessThan(right) ? left : right;
        }

        public boolean isLessThan(TypeConfidence that) {
            return this.ordinal() > that.ordinal();
        }

        public boolean isAtLeast(TypeConfidence that) {
            return this.ordinal() <= that.ordinal();
        }
    }
}

