/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.groovy;

import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseConfig;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseFramework;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipsePluginConfig;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseServiceConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.IGroovyLogger;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.core.GroovyCoreActivator;
import org.codehaus.groovy.eclipse.refactoring.formatter.DefaultGroovyFormatter;
import org.codehaus.groovy.eclipse.refactoring.formatter.FormatterPreferencesOnStore;
import org.codehaus.groovy.eclipse.refactoring.formatter.GroovyFormatter;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.text.edits.TextEdit;
import org.osgi.framework.BundleActivator;

public class GrEclipseFormatterStepImpl {
    public static final String IGNORE_FORMATTER_PROBLEMS = "ignoreFormatterProblems";
    private final FormatterPreferencesOnStore preferencesStore;
    private final boolean ignoreFormatterProblems;

    public GrEclipseFormatterStepImpl(Properties properties) throws Exception {
        SpotlessEclipseFramework.setup((SpotlessEclipseConfig)new FrameworkConfig());
        PreferenceStore preferences = GrEclipseFormatterStepImpl.createPreferences(properties);
        this.preferencesStore = new FormatterPreferencesOnStore((IPreferenceStore)preferences);
        this.ignoreFormatterProblems = Boolean.parseBoolean(properties.getProperty(IGNORE_FORMATTER_PROBLEMS, "false"));
    }

    public String format(String raw) throws Exception {
        Document doc = new Document(raw);
        GroovyErrorListener errorListener = new GroovyErrorListener();
        TextSelection selectAll = new TextSelection((IDocument)doc, 0, doc.getLength());
        DefaultGroovyFormatter codeFormatter = new DefaultGroovyFormatter((ITextSelection)selectAll, (IDocument)doc, this.preferencesStore, false);
        TextEdit edit = ((GroovyFormatter)codeFormatter).format();
        if (!this.ignoreFormatterProblems && errorListener.errorsDetected()) {
            throw new IllegalArgumentException(errorListener.toString());
        }
        edit.apply((IDocument)doc);
        return doc.get();
    }

    private static PreferenceStore createPreferences(Properties properties) throws IOException {
        PreferenceStore preferences = new PreferenceStore();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        properties.store(output, null);
        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
        preferences.load((InputStream)input);
        return preferences;
    }

    private static class GroovyErrorListener
    implements ILogListener,
    IGroovyLogger {
        private final List<String> errors = Collections.synchronizedList(new ArrayList());

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GroovyErrorListener() {
            ILog groovyLogger = GroovyCoreActivator.getDefault().getLog();
            groovyLogger.addLogListener((ILogListener)this);
            GroovyLogManager groovyLogManager = GroovyLogManager.manager;
            synchronized (groovyLogManager) {
                GroovyLogManager.manager.addLogger(this);
            }
        }

        public void logging(IStatus status, String plugin) {
            this.errors.add(status.getMessage());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean errorsDetected() {
            ILog groovyLogger = GroovyCoreActivator.getDefault().getLog();
            groovyLogger.removeLogListener((ILogListener)this);
            GroovyLogManager groovyLogManager = GroovyLogManager.manager;
            synchronized (groovyLogManager) {
                GroovyLogManager.manager.removeLogger(this);
            }
            return 0 != this.errors.size();
        }

        public String toString() {
            StringBuilder string = new StringBuilder();
            if (1 < this.errors.size()) {
                string.append("Multiple problems detected during step execution:");
            } else if (0 == this.errors.size()) {
                string.append("Step sucesfully executed.");
            }
            for (String error : this.errors) {
                string.append(System.lineSeparator());
                string.append(error);
            }
            return string.toString();
        }

        @Override
        public boolean isCategoryEnabled(TraceCategory cat) {
            return TraceCategory.COMPILER.equals((Object)cat);
        }

        @Override
        public void log(TraceCategory arg0, String arg1) {
            this.errors.add(arg1);
        }
    }

    private static class FrameworkConfig
    implements SpotlessEclipseConfig {
        private FrameworkConfig() {
        }

        public void registerServices(SpotlessEclipseServiceConfig config) {
            config.applyDefault();
            config.useSlf4J(GrEclipseFormatterStepImpl.class.getPackage().getName());
        }

        public void activatePlugins(SpotlessEclipsePluginConfig config) {
            config.add((BundleActivator)new GroovyCoreActivator());
        }
    }
}

