/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.inference;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.classgen.asm.MopWriter;
import org.codehaus.groovy.eclipse.core.compiler.CompilerUtils;
import org.codehaus.groovy.transform.stc.ExtensionMethodNode;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;
import org.eclipse.jdt.groovy.search.ITypeLookup;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;

public class STCTypeLookup
implements ITypeLookup {
    private static final boolean isEnabled = CompilerUtils.getActiveGroovyBundle().getVersion().getMajor() >= 2;

    @Override
    public TypeLookupResult lookupType(Expression expr, VariableScope scope, ClassNode objectExpressionType) {
        if (isEnabled) {
            boolean isGroovy = false;
            AnnotatedNode declaration = expr;
            ClassNode declaringType = objectExpressionType;
            TypeLookupResult.TypeConfidence confidence = TypeLookupResult.TypeConfidence.INFERRED;
            Object inferredType = expr.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
            if (inferredType == null && expr instanceof VariableExpression) {
                inferredType = expr.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
            }
            if (inferredType instanceof ClassNode) {
                Object methodTarget;
                if (expr instanceof ClassExpression) {
                    declaration = expr.getType();
                } else if (expr instanceof FieldExpression) {
                    declaration = ((FieldExpression)expr).getField();
                    assert (((FieldNode)declaration).getDeclaringClass().equals(declaringType));
                } else if (expr instanceof VariableExpression) {
                    VariableExpression vexp = (VariableExpression)expr;
                    if (vexp.isThisExpression() || vexp.isSuperExpression()) {
                        declaration = (ClassNode)inferredType;
                    } else {
                        Object methodTarget2 = vexp.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
                        if (methodTarget2 instanceof MethodNode) {
                            declaration = (MethodNode)methodTarget2;
                            declaringType = ((MethodNode)methodTarget2).getDeclaringClass();
                        } else {
                            Variable accessedVariable = vexp.getAccessedVariable();
                            if (accessedVariable instanceof AnnotatedNode) {
                                VariableScope.VariableInfo info;
                                declaration = (AnnotatedNode)((Object)accessedVariable);
                                declaringType = declaration.getDeclaringClass();
                                if (VariableScope.isPlainClosure((ClassNode)inferredType) && (info = scope.lookupName(accessedVariable.getName())) != null && VariableScope.isParameterizedClosure(info.type)) {
                                    inferredType = info.type;
                                }
                            } else {
                                confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                            }
                        }
                    }
                } else if (expr instanceof MethodCall && (methodTarget = declaration.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET)) instanceof MethodNode) {
                    declaration = (MethodNode)methodTarget;
                    declaringType = ((MethodNode)methodTarget).getDeclaringClass();
                }
            } else if (expr instanceof ConstantExpression) {
                ASTNode enclosingNode = scope.getEnclosingNode();
                ASTNode methodTarget = null;
                if (enclosingNode instanceof PropertyExpression && ((PropertyExpression)enclosingNode).getProperty() == expr) {
                    methodTarget = (ASTNode)enclosingNode.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
                    if (methodTarget instanceof MethodNode && ((MethodNode)methodTarget).isSynthetic()) {
                        declaringType = ((MethodNode)methodTarget).getOriginal().getDeclaringClass();
                        inferredType = enclosingNode.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                        declaration = declaringType.getProperty(expr.getText());
                        if (declaration != null) {
                            methodTarget = null;
                        }
                    }
                } else if (enclosingNode instanceof MethodCallExpression && ((MethodCallExpression)enclosingNode).getMethod() == expr) {
                    methodTarget = (ASTNode)enclosingNode.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
                    if (methodTarget == null) {
                        methodTarget = STCTypeLookup.getMopMethodTarget((MethodCallExpression)enclosingNode);
                    }
                    if (methodTarget == null) {
                        methodTarget = ((MethodCallExpression)enclosingNode).getMethodTarget();
                    }
                }
                if (methodTarget instanceof ExtensionMethodNode) {
                    methodTarget = ((ExtensionMethodNode)methodTarget).getExtensionMethodNode();
                    isGroovy = true;
                }
                if (methodTarget instanceof MethodNode) {
                    declaration = ((MethodNode)methodTarget).getOriginal();
                    declaringType = ((MethodNode)methodTarget).getOriginal().getDeclaringClass();
                    inferredType = enclosingNode.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                    if (inferredType == null) {
                        inferredType = ((MethodNode)methodTarget).getReturnType();
                    }
                }
            }
            if (inferredType instanceof ClassNode) {
                if (confidence.isAtLeast(TypeLookupResult.TypeConfidence.INFERRED) && STCTypeLookup.isCompoundAssignTarget(expr, scope) && declaration instanceof MethodNode) {
                    confidence = TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
                }
                TypeLookupResult result = new TypeLookupResult((ClassNode)inferredType, declaringType, declaration, confidence, scope);
                result.isGroovy = isGroovy;
                return result;
            }
        }
        return null;
    }

    @Override
    public TypeLookupResult lookupType(FieldNode node, VariableScope scope) {
        Object inferredType;
        if (isEnabled && (inferredType = node.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE)) instanceof ClassNode) {
            return new TypeLookupResult((ClassNode)inferredType, node.getDeclaringClass(), node, TypeLookupResult.TypeConfidence.INFERRED, scope);
        }
        return null;
    }

    @Override
    public TypeLookupResult lookupType(MethodNode node, VariableScope scope) {
        Object inferredType;
        if (isEnabled && (inferredType = node.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE)) instanceof ClassNode) {
            return new TypeLookupResult((ClassNode)inferredType, node.getDeclaringClass(), node, TypeLookupResult.TypeConfidence.INFERRED, scope);
        }
        return null;
    }

    private static MethodNode getMopMethodTarget(MethodCallExpression call) {
        Matcher m;
        if (call.isImplicitThis() && MopWriter.isMopMethod(call.getMethodAsString()) && call.getObjectExpression().getNodeMetaData("OriginalExpression") != null && (m = Pattern.compile("super\\$(\\d+)\\$(.+)").matcher(call.getMethodAsString())).matches()) {
            int dist = Integer.parseInt(m.group(1));
            ArrayList<ClassNode> types = new ArrayList<ClassNode>();
            ClassNode next = call.getMethodTarget().getDeclaringClass();
            while (next != null) {
                types.add(next);
                next = next.getSuperClass();
            }
            String name = m.group(2);
            ClassNode type = (ClassNode)types.get(types.size() - dist);
            return type.getMethod(name, call.getMethodTarget().getParameters());
        }
        return null;
    }

    private static boolean isCompoundAssignTarget(Expression expr, VariableScope scope) {
        boolean isAssignTarget;
        boolean bl = isAssignTarget = scope.getWormhole().get("lhs") == expr || expr.getNodeMetaData("rhsType") != null;
        return isAssignTarget && scope.getEnclosingAssignmentOperator().filter(op -> op.getType() != 100).isPresent();
    }
}

