/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.search;

import java.beans.Introspector;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.codehaus.groovy.eclipse.core.search.ISearchRequestor;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;

public class SyntheticAccessorSearchRequestor {
    public void findSyntheticMatches(IJavaElement element, ISearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        this.findSyntheticMatches(element, 2, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createWorkspaceScope(), requestor, monitor);
    }

    public void findSyntheticMatches(IJavaElement element, int limitTo, SearchParticipant[] participants, IJavaSearchScope scope, final ISearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        if (!(element instanceof IMember) || !GroovyNature.hasGroovyNature(element.getJavaProject().getProject())) {
            return;
        }
        SearchPattern pattern = this.createPattern(element, limitTo & 0xFFFFFFEF);
        if (pattern == null) {
            return;
        }
        final boolean checkFlags = element.getElementType() == 9 && element.getElementName().startsWith("set");
        new SearchEngine().search(pattern, participants, scope, new SearchRequestor(){

            @Override
            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                if (!checkFlags || !Flags.isFinal(((IMember)match.getElement()).getFlags())) {
                    requestor.acceptMatch(match);
                }
            }
        }, monitor);
    }

    private SearchPattern createPattern(IJavaElement element, int limitTo) throws JavaModelException {
        IJavaElement[] toSearch = new IJavaElement[]{this.findSyntheticProperty(element), this.findSyntheticMember(element, "is"), this.findSyntheticMember(element, "get"), this.findSyntheticMember(element, "set")};
        SearchPattern pattern = null;
        IJavaElement[] iJavaElementArray = toSearch;
        int n = toSearch.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement searchElt = iJavaElementArray[n2];
            if (searchElt != null) {
                SearchPattern newPattern = SearchPattern.createPattern(searchElt, limitTo);
                pattern = pattern == null ? newPattern : SearchPattern.createOrPattern(pattern, newPattern);
            }
            ++n2;
        }
        return pattern;
    }

    private IMethod findSyntheticMember(IJavaElement element, String prefix) throws JavaModelException {
        String[] stringArray;
        if (element.getElementType() != 8) {
            return null;
        }
        IField field = (IField)element;
        boolean isser = "is".equals(prefix);
        boolean setter = "set".equals(prefix);
        if (setter && Flags.isFinal(field.getFlags())) {
            return null;
        }
        if (isser && !field.getTypeSignature().equals("Z")) {
            return null;
        }
        String name = String.valueOf(prefix) + MetaClassHelper.capitalize(field.getElementName());
        if (!setter) {
            stringArray = CharOperation.NO_STRINGS;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = field.getTypeSignature();
        }
        String[] params = stringArray;
        IMethod method = ((IType)field.getParent()).getMethod(name, params);
        return method.exists() ? null : SyntheticAccessorSearchRequestor.syntheticMemberProxy(IMethod.class, method, setter ? "V" : field.getTypeSignature());
    }

    private IField findSyntheticProperty(IJavaElement element) throws JavaModelException {
        int prefixLength;
        if (element.getElementType() != 9) {
            return null;
        }
        String name = element.getElementName();
        if (name.length() <= 2) {
            return null;
        }
        if (name.startsWith("is")) {
            prefixLength = 2;
        } else {
            if (name.length() == 3) {
                return null;
            }
            prefixLength = 3;
        }
        name = Introspector.decapitalize(name.substring(prefixLength));
        IField field = ((IType)element.getParent()).getField(name);
        return field.exists() ? null : SyntheticAccessorSearchRequestor.syntheticMemberProxy(IField.class, field, "Z");
    }

    public static <T extends IMember> T syntheticMemberProxy(Class<T> face, final IMember delegate, final String signature) {
        return (T)((IMember)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), new Class[]{face}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("getReturnType") || method.getName().equals("getTypeSignature")) {
                    return signature;
                }
                if (method.getName().equals("getTypeParameters")) {
                    return new ITypeParameter[0];
                }
                if (method.getName().equals("getFlags")) {
                    return 1;
                }
                if (method.getName().equals("exists")) {
                    return Boolean.TRUE;
                }
                try {
                    return method.invoke((Object)delegate, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
        }));
    }
}

