/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.util;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.antlr.LocationSupport;
import org.codehaus.groovy.ast.Comment;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.eclipse.core.ISourceBuffer;
import org.codehaus.groovy.eclipse.core.compiler.GroovySnippetParser;
import org.codehaus.groovy.eclipse.core.impl.ReverseSourceBuffer;
import org.codehaus.groovy.eclipse.core.util.Token;
import org.codehaus.groovy.eclipse.core.util.TokenStreamException;

public class TokenStream {
    private static final Pattern MULTI_LINE_COMMENT = Pattern.compile("(?s)/\\*.*\\*/");
    private static final Pattern SINGLE_LINE_COMMENT = Pattern.compile(".*//");
    private static final Pattern SINGLE_QUOTE1 = Pattern.compile("^'.*'");
    private static final Pattern SINGLE_QUOTE2 = Pattern.compile("^\".*\"");
    private static final Pattern TRIPLE_QUOTE1 = Pattern.compile("^'''.*'''");
    private static final Pattern TRIPLE_QUOTE2 = Pattern.compile("^\"\"\".*\"\"\"");
    private static final Token TOKEN_EOF = new Token(Token.Type.EOF, -1, -1, null);
    private final ISourceBuffer buffer;
    private Token last;
    private Token next;
    private int offset;
    private char ch;
    private int[] comments;

    public TokenStream(ISourceBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        this.ch = buffer.charAt(offset);
    }

    public char getCurrentChar() {
        return this.ch;
    }

    public Token peek() throws TokenStreamException {
        int offset = this.offset;
        Token last = this.last;
        Token next = this.next;
        char ch = this.ch;
        Token ret = this.next();
        this.offset = offset;
        this.last = last;
        this.next = next;
        this.ch = ch;
        return ret;
    }

    public Token last() {
        return this.last;
    }

    public Token next() throws TokenStreamException {
        if (this.next != null) {
            this.last = this.next;
            this.next = null;
            return this.last;
        }
        if (this.offset == -1) {
            return TOKEN_EOF;
        }
        if (Character.isWhitespace(this.ch)) {
            this.skipWhite();
            if (this.offset == -1) {
                return TOKEN_EOF;
            }
        }
        if (this.isLineBreakChar()) {
            this.last = this.skipLineBreak();
            this.next = this.skipLineComment();
            return this.last;
        }
        if (this.ch == '/' && this.la(1) == '*') {
            this.last = this.scanBlockComment();
            return this.last;
        }
        if (Character.isJavaIdentifierPart(this.ch)) {
            this.last = this.scanIdent();
        } else {
            switch (this.ch) {
                case '.': {
                    this.last = this.scanDot();
                    break;
                }
                case '}': {
                    this.last = this.scanPair('{', '}', Token.Type.BRACE_BLOCK);
                    break;
                }
                case ')': {
                    this.last = this.scanPair('(', ')', Token.Type.PAREN_BLOCK);
                    break;
                }
                case ']': {
                    this.last = this.scanPair('[', ']', Token.Type.BRACK_BLOCK);
                    break;
                }
                case '\'': {
                    this.last = this.scanQuote('\'');
                    break;
                }
                case '\"': {
                    this.last = this.scanQuote('\"');
                    break;
                }
                case '@': {
                    this.nextChar();
                    if (this.ch == '.') {
                        this.nextChar();
                        this.last = new Token(Token.Type.FIELD_ACCESS, this.offset + 1, this.offset + 3, this.buffer.subSequence(this.offset + 1, this.offset + 3).toString());
                        break;
                    }
                    this.last = new Token(Token.Type.IDENT, this.offset + 1, this.offset + 2, this.buffer.subSequence(this.offset + 1, this.offset + 2).toString());
                    break;
                }
                case '&': {
                    this.nextChar();
                    if (this.ch != '.') break;
                    this.nextChar();
                    this.last = new Token(Token.Type.METHOD_POINTER, this.offset + 1, this.offset + 3, this.buffer.subSequence(this.offset + 1, this.offset + 3).toString());
                    break;
                }
                case ':': {
                    this.nextChar();
                    if (this.ch != ':') break;
                    this.nextChar();
                    this.last = new Token(Token.Type.METHOD_POINTER, this.offset + 1, this.offset + 3, this.buffer.subSequence(this.offset + 1, this.offset + 3).toString());
                    break;
                }
                case ';': {
                    this.nextChar();
                    this.last = new Token(Token.Type.SEMI, this.offset + 1, this.offset + 2, this.buffer.subSequence(this.offset + 1, this.offset + 2).toString());
                    break;
                }
                default: {
                    throw new TokenStreamException(this.ch);
                }
            }
        }
        return this.last;
    }

    private Token scanDot() {
        this.nextChar();
        if (this.offset == -1) {
            return TOKEN_EOF;
        }
        if (this.ch == '.') {
            this.nextChar();
            return new Token(Token.Type.DOUBLE_DOT, this.offset + 1, this.offset + 3, this.buffer.subSequence(this.offset + 1, this.offset + 3).toString());
        }
        if (this.ch == '?') {
            this.nextChar();
            return new Token(Token.Type.SAFE_DEREF, this.offset + 1, this.offset + 3, this.buffer.subSequence(this.offset + 1, this.offset + 3).toString());
        }
        if (this.ch == '*') {
            this.nextChar();
            return new Token(Token.Type.SPREAD, this.offset + 1, this.offset + 3, this.buffer.subSequence(this.offset + 1, this.offset + 3).toString());
        }
        return new Token(Token.Type.DOT, this.offset + 1, this.offset + 2, this.buffer.subSequence(this.offset + 1, this.offset + 2).toString());
    }

    private Token skipLineBreak() {
        int endOffset = this.offset + 1;
        char firstChar = this.ch;
        this.nextChar();
        if (this.offset != -1 && this.isLineBreakChar()) {
            char secondChar = this.ch;
            this.nextChar();
            return new Token(Token.Type.LINE_BREAK, this.offset + 1, endOffset, new String(new char[]{firstChar, secondChar}));
        }
        return new Token(Token.Type.LINE_BREAK, this.offset + 1, endOffset, new String(new char[]{firstChar}));
    }

    private boolean isLineBreakChar() {
        return this.ch == '\n' || this.ch == '\r';
    }

    private void nextChar() {
        if (this.offset == -1) {
            throw new IllegalStateException("tried to get next char after eof");
        }
        if (this.offset == 0) {
            this.offset = -1;
        } else {
            this.ch = this.buffer.charAt(--this.offset);
        }
    }

    private Token scanPair(char open, char close, Token.Type type) throws TokenStreamException {
        int endOffset = this.offset + 1;
        int pairCount = 1;
        while (pairCount > 0 && this.offset > 0) {
            this.ch = this.buffer.charAt(--this.offset);
            if (this.ch == open) {
                --pairCount;
                continue;
            }
            if (this.ch != close) continue;
            ++pairCount;
        }
        if (this.offset != 0) {
            this.ch = this.buffer.charAt(--this.offset);
        } else {
            this.offset = -1;
            if (pairCount != 0) {
                throw new TokenStreamException("Unclosed pair at EOF");
            }
        }
        return new Token(type, this.offset + 1, endOffset, this.buffer.subSequence(this.offset + 1, endOffset).toString());
    }

    private Token scanIdent() {
        int endOffset = this.offset + 1;
        do {
            this.nextChar();
        } while (this.offset > -1 && Character.isJavaIdentifierPart(this.ch));
        return new Token(Token.Type.IDENT, this.offset + 1, endOffset, this.buffer.subSequence(this.offset + 1, endOffset).toString());
    }

    private Token scanQuote(char quote) throws TokenStreamException {
        Pattern tripleQuote;
        Pattern singleQuote;
        if (quote == '\'') {
            singleQuote = SINGLE_QUOTE1;
            tripleQuote = TRIPLE_QUOTE1;
        } else {
            singleQuote = SINGLE_QUOTE2;
            tripleQuote = TRIPLE_QUOTE2;
        }
        Token token = this.matchQuote(tripleQuote);
        if (token != null) {
            return token;
        }
        token = this.matchQuote(singleQuote);
        if (token != null) {
            return token;
        }
        throw new TokenStreamException("Could not close quoted string, end offset = " + this.offset);
    }

    private Token matchQuote(Pattern quotePattern) {
        ReverseSourceBuffer matchBuffer = new ReverseSourceBuffer(this.buffer, this.offset);
        Matcher matcher = quotePattern.matcher(matchBuffer);
        if (matcher.find()) {
            int startOffset;
            String match = matcher.group(0);
            int endOffset = this.offset + 1;
            this.offset = startOffset = this.offset - match.length() + 1;
            if (this.offset == 0) {
                this.offset = -1;
            }
            if (this.offset != -1) {
                --this.offset;
                this.ch = this.buffer.charAt(this.offset);
            }
            return new Token(Token.Type.QUOTED_STRING, startOffset, endOffset, match);
        }
        return null;
    }

    private void skipWhite() {
        if (this.isLineBreakChar()) {
            return;
        }
        do {
            this.nextChar();
        } while (Character.isWhitespace(this.ch) && !this.isLineBreakChar() && this.offset > -1);
    }

    private Token skipLineComment() {
        Matcher matcher = SINGLE_LINE_COMMENT.matcher(new ReverseSourceBuffer(this.buffer, this.offset));
        if (matcher.find() && matcher.start() == 0) {
            String match = matcher.group(0);
            int endOffset = this.offset + 1;
            int startOffset = this.offset - match.length() + 1;
            if (this.isComment(startOffset)) {
                this.offset = startOffset;
                this.ch = this.offset != 0 ? this.buffer.charAt(--this.offset) : this.buffer.charAt(this.offset--);
                return new Token(Token.Type.LINE_COMMENT, startOffset, endOffset, match);
            }
        }
        return null;
    }

    private Token scanBlockComment() {
        Matcher matcher = MULTI_LINE_COMMENT.matcher(new ReverseSourceBuffer(this.buffer, this.offset));
        if (matcher.find()) {
            String match = matcher.group(0);
            int endOffset = this.offset + 1;
            int startOffset = this.offset - match.length() + 1;
            if (this.isComment(startOffset)) {
                this.offset = startOffset;
                this.ch = this.offset != 0 ? this.buffer.charAt(--this.offset) : this.buffer.charAt(this.offset--);
                return new Token(Token.Type.BLOCK_COMMENT, startOffset, endOffset, match);
            }
        }
        this.ch = this.buffer.charAt(--this.offset);
        return null;
    }

    private boolean isComment(int index) {
        if (this.comments == null) {
            CharSequence source = this.buffer.subSequence(0, this.buffer.length());
            GroovySnippetParser parser = new GroovySnippetParser();
            ModuleNode module = parser.parse(source);
            LocationSupport locator = (LocationSupport)module.getNodeMetaData(LocationSupport.class);
            List<Comment> list = module.getContext().getComments();
            int i = 0;
            int n = list == null ? 0 : list.size();
            this.comments = new int[n * 2];
            if (n > 0) {
                for (Comment comment : list) {
                    this.comments[i++] = locator.findOffset(comment.sline, comment.scol);
                    this.comments[i++] = locator.findOffset(comment.eline, comment.ecol);
                }
                Arrays.sort(this.comments);
            }
        }
        return Arrays.binarySearch(this.comments, index) % 2 == 0;
    }

    private char la(int index) {
        if (this.offset - index >= 0) {
            return this.buffer.charAt(this.offset - index);
        }
        return '\u0000';
    }
}

