/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.AbstractRefactoringCodeVisitor;
import org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.RefactoringImportNode;

public class StaticFieldImport
extends RefactoringImportNode {
    private final String field;
    private String newField;
    private String newAlias;

    public StaticFieldImport(ClassNode type, String alias, String field) {
        super(type, alias);
        this.field = field;
        this.newClassName = type.getName();
        this.newField = field;
        this.newAlias = this.getAlias();
    }

    @Override
    public String getText() {
        if (this.field.equals(this.newAlias)) {
            return "import static " + this.newClassName + "." + this.newField;
        }
        return "import static " + this.newClassName + "." + this.newField + " as " + this.newAlias;
    }

    public String getField() {
        return this.field;
    }

    public void setNewField(String field) {
        this.newField = field;
    }

    public void setNewAlias(String newAlias) {
        this.newAlias = newAlias;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StaticFieldImport) {
            StaticFieldImport other = (StaticFieldImport)obj;
            return this.getType().equals(other.getType()) && this.field.equals(other.getField()) && this.getAlias().equals(other.getAlias());
        }
        return false;
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    @Override
    public void visit(GroovyCodeVisitor visitor) {
        if (visitor instanceof AbstractRefactoringCodeVisitor) {
            ((AbstractRefactoringCodeVisitor)visitor).visitStaticFieldImport(this);
        }
    }
}

