/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.formatter;

import groovyjarjarantlr.Token;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.antlr.GroovyTokenTypeBridge;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.refactoring.formatter.FormatterPreferences;
import org.codehaus.groovy.eclipse.refactoring.formatter.GroovyDocumentScanner;
import org.codehaus.groovy.eclipse.refactoring.formatter.IFormatterPreferences;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;

public class GroovyIndentationService {
    private static GroovyIndentationService lastIndenter;
    private static Map<Integer, Integer> closer2opener;
    private static Set<Integer> jumpIn;
    private static Set<Integer> jumpOut;
    private GroovyDocumentScanner cachedScanner;
    private IFormatterPreferences prefs;
    private final IJavaProject project;

    static {
        closer2opener = new HashMap<Integer, Integer>();
        jumpIn = new HashSet<Integer>();
        jumpOut = new HashSet<Integer>();
        GroovyIndentationService.openClosePair(GroovyTokenTypeBridge.LCURLY, GroovyTokenTypeBridge.RCURLY);
        GroovyIndentationService.openClosePair(GroovyTokenTypeBridge.LBRACK, GroovyTokenTypeBridge.RBRACK);
        GroovyIndentationService.openClosePair(GroovyTokenTypeBridge.LPAREN, GroovyTokenTypeBridge.RPAREN);
        GroovyIndentationService.openClosePair(GroovyTokenTypeBridge.STRING_CTOR_START, GroovyTokenTypeBridge.STRING_CTOR_END);
    }

    public static synchronized GroovyIndentationService get(IJavaProject project) {
        if (lastIndenter != null && project != null && !project.equals(GroovyIndentationService.lastIndenter.project)) {
            GroovyIndentationService.disposeLastImpl();
        }
        if (lastIndenter == null) {
            lastIndenter = new GroovyIndentationService(project);
        }
        return lastIndenter;
    }

    public static synchronized void disposeLast() {
        GroovyIndentationService.disposeLastImpl();
    }

    private static void disposeLastImpl() {
        if (lastIndenter != null) {
            try {
                lastIndenter.dispose();
            }
            finally {
                lastIndenter = null;
            }
        }
    }

    public static String getLeadingWhiteSpace(String text) {
        int i = 0;
        while (i < text.length() && Character.isWhitespace(text.charAt(i))) {
            ++i;
        }
        return text.substring(0, i);
    }

    public static String getLine(IDocument d, int lineNum) {
        try {
            String delim = d.getLineDelimiter(lineNum);
            int delimLen = delim == null ? 0 : delim.length();
            String string = d.get(d.getLineOffset(lineNum), d.getLineLength(lineNum) - delimLen);
            return string;
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    public static String getLineLeadingWhiteSpace(IDocument d, int line) {
        return GroovyIndentationService.getLeadingWhiteSpace(GroovyIndentationService.getLine(d, line));
    }

    public static String getLineTextUpto(IDocument d, int offset) throws BadLocationException {
        int line = d.getLineOfOffset(offset);
        int lineStart = d.getLineOffset(line);
        String lineStartText = d.get(lineStart, offset - lineStart);
        return lineStartText;
    }

    private static void openClosePair(int opener, int closer) {
        Assert.isTrue((!closer2opener.containsKey(closer) ? 1 : 0) != 0);
        closer2opener.put(closer, opener);
        jumpIn.add(opener);
        jumpOut.add(closer);
    }

    public GroovyIndentationService(IJavaProject project) {
        assert (project != null);
        this.project = project;
    }

    public int computeIndentAfterNewline(IDocument d, int offset) throws BadLocationException {
        Token token = this.getTokenBefore(d, offset);
        int line = token == null ? 0 : this.getLineNumber(token);
        int orgIndentLevel = token == null ? 0 : this.getLineIndentLevel(d, line);
        List<Token> tokens = this.getTokens(d, d.getLineOffset(line), offset);
        int indentLevel = this.simpleComputeNextLineIndentLevel(orgIndentLevel, tokens);
        Token lastToken = this.lastNonNlsToken(d, tokens);
        if (lastToken != null) {
            if (this.isCloserOfPair(lastToken)) {
                int firstTokenType;
                if (indentLevel < orgIndentLevel) {
                    indentLevel = this.getIndentLevelForCloserPair(d, lastToken);
                } else if (indentLevel == orgIndentLevel && lastToken.getType() == GroovyTokenTypeBridge.RPAREN && ((firstTokenType = tokens.get(0).getType()) == GroovyTokenTypeBridge.LITERAL_if || firstTokenType == GroovyTokenTypeBridge.LITERAL_else || firstTokenType == GroovyTokenTypeBridge.LITERAL_for || firstTokenType == GroovyTokenTypeBridge.LITERAL_while || firstTokenType == GroovyTokenTypeBridge.RCURLY && tokens.size() > 1 && tokens.get(1).getType() == GroovyTokenTypeBridge.LITERAL_else)) {
                    indentLevel = this.getIndentLevelForCloserPair(d, lastToken) + this.getPrefs().getIndentationSize();
                }
            } else if (indentLevel == orgIndentLevel && lastToken.getType() == GroovyTokenTypeBridge.LITERAL_else) {
                indentLevel += this.getPrefs().getIndentationSize();
            }
        }
        return indentLevel;
    }

    private int getLineNumber(Token token) {
        return token.getLine() - 1;
    }

    public int computeIndentForLine(IDocument d, int line) {
        if (line != 0) {
            try {
                Token nextToken = this.getTokenFrom(d, d.getLineOffset(line));
                if (nextToken != null && this.isCloserOfPair(nextToken)) {
                    return this.getIndentLevelForCloserPair(d, nextToken);
                }
                IRegion prevLine = d.getLineInformation(line - 1);
                return this.computeIndentAfterNewline(d, prevLine.getOffset() + prevLine.getLength());
            }
            catch (BadLocationException e) {
                GroovyCore.logException("internal error", e);
            }
        }
        return 0;
    }

    public String createIndentation(int spaces) {
        return GroovyIndentationService.createIndentation(this.getPrefs(), spaces);
    }

    public static String createIndentation(IFormatterPreferences pref, int spaces) {
        StringBuilder b = new StringBuilder();
        int tab = pref.getTabSize();
        if (spaces > 0 && pref != null && pref.useTabs() && tab > 0) {
            while (spaces >= tab) {
                b.append('\t');
                spaces -= tab;
            }
        }
        while (spaces > 0) {
            b.append(' ');
            --spaces;
        }
        return b.toString();
    }

    public void dispose() {
        this.disposeScanner();
        this.disposePrefs();
    }

    public void disposePrefs() {
        this.prefs = null;
    }

    private void disposeScanner() {
        if (this.cachedScanner != null) {
            try {
                this.cachedScanner.dispose();
            }
            finally {
                this.cachedScanner = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void fixIndentation(Document workCopy, int line, int newIndentLevel) {
        try {
            IRegion lineRegion = workCopy.getLineInformation(line);
            String text = workCopy.get(lineRegion.getOffset(), lineRegion.getLength()).trim();
            text = String.valueOf(this.createIndentation(newIndentLevel)) + text;
            workCopy.replace(lineRegion.getOffset(), lineRegion.getLength(), text);
        }
        catch (BadLocationException e) {
            GroovyCore.logException("internal error", e);
        }
    }

    private GroovyDocumentScanner getGroovyDocumentScanner(IDocument d) {
        if (this.cachedScanner == null || this.cachedScanner.getDocument() != d) {
            this.disposeScanner();
            this.cachedScanner = new GroovyDocumentScanner(d);
        }
        return this.cachedScanner;
    }

    public int getIndentLevel(IDocument d, int offset) {
        try {
            return this.getLineIndentLevel(d, d.getLineOfOffset(offset));
        }
        catch (BadLocationException e) {
            return 0;
        }
    }

    private int getIndentLevelForCloserPair(IDocument d, Token closer) {
        GroovyDocumentScanner scanner = this.getGroovyDocumentScanner(d);
        int closerType = closer.getType();
        int openerType = closer2opener.get(closerType);
        int closeCount = 1;
        Token token = closer;
        try {
            while (closeCount != 0 && (token = scanner.getLastTokenBefore(token)) != null) {
                if (token.getType() == openerType) {
                    --closeCount;
                }
                if (token.getType() != closerType) continue;
                ++closeCount;
            }
            return this.getIndentLevel(d, scanner.getOffset(token));
        }
        catch (BadLocationException e) {
            try {
                return this.getIndentLevel(d, scanner.getOffset(closer));
            }
            catch (BadLocationException e1) {
                return 0;
            }
        }
    }

    public String getLineDelimiter(IDocument d, int lineNum) throws BadLocationException {
        String result = d.getLineDelimiter(lineNum);
        if (result == null) {
            return "";
        }
        return result;
    }

    public int getLineIndentLevel(IDocument d, int lineNum) {
        return this.indentLevel(GroovyIndentationService.getLine(d, lineNum));
    }

    private List<Token> getLineTokensUpto(IDocument d, int offset) {
        return this.getGroovyDocumentScanner(d).getLineTokensUpto(offset);
    }

    protected int getOpenVersusCloseBalance(List<Token> tokens) {
        int adjust = 0;
        if (!tokens.isEmpty() && jumpOut.contains(tokens.get(0).getType())) {
            ++adjust;
        }
        for (Token tok : tokens) {
            if (jumpIn.contains(tok.getType())) {
                ++adjust;
            }
            if (!jumpOut.contains(tok.getType())) continue;
            --adjust;
        }
        return adjust;
    }

    public IFormatterPreferences getPrefs() {
        if (this.prefs == null) {
            this.refreshPrefs();
        }
        return this.prefs;
    }

    public String getTabString() {
        return this.createIndentation(this.getPrefs().getTabSize());
    }

    private Token getTokenBefore(IDocument d, Token token) throws BadLocationException {
        return this.getGroovyDocumentScanner(d).getLastTokenBefore(token);
    }

    private Token getTokenBefore(IDocument d, int offset) throws BadLocationException {
        return this.getGroovyDocumentScanner(d).getLastTokenBefore(offset);
    }

    private Token getTokenFrom(IDocument d, int offset) {
        return this.getGroovyDocumentScanner(d).getTokenFrom(offset);
    }

    private List<Token> getTokens(IDocument d, int start, int end) {
        return this.getGroovyDocumentScanner(d).getTokens(start, end);
    }

    public int indentLevel(String lineText) {
        int level = 0;
        int i = 0;
        int n = lineText.length();
        while (i < n) {
            switch (lineText.charAt(i)) {
                case ' ': {
                    ++level;
                    break;
                }
                case '\t': {
                    level += this.getPrefs().getTabSize();
                    break;
                }
                default: {
                    return level;
                }
            }
            ++i;
        }
        return level;
    }

    public boolean isAfterOpeningBrace(IDocument d, int pos) {
        Token token = this.getGroovyDocumentScanner(d).getLastTokenBefore(pos);
        return token != null && token.getType() == GroovyTokenTypeBridge.LCURLY;
    }

    private boolean isCloserOfPair(Token lastToken) {
        return closer2opener.containsKey(lastToken.getType());
    }

    public boolean isEndOfLine(IDocument d, int pos) {
        Token token = this.getGroovyDocumentScanner(d).getTokenFrom(pos);
        return token == null || token.getType() == GroovyTokenTypeBridge.NLS || token.getType() == GroovyTokenTypeBridge.EOF;
    }

    public boolean isInEmptyLine(IDocument d, int offset) {
        try {
            int line = d.getLineOfOffset(offset);
            String text = GroovyIndentationService.getLine(d, line);
            return text.trim().length() == 0;
        }
        catch (BadLocationException e) {
            GroovyCore.logException("Internal error", e);
            return false;
        }
    }

    private Token lastNonNlsToken(IDocument d, List<Token> tokens) throws BadLocationException {
        if (tokens != null && !tokens.isEmpty()) {
            Token lastToken = tokens.get(tokens.size() - 1);
            while (lastToken != null && lastToken.getType() == GroovyTokenTypeBridge.NLS) {
                lastToken = this.getTokenBefore(d, lastToken);
            }
            return lastToken;
        }
        return null;
    }

    public int lengthToNextCurly(IDocument d, int offset) throws BadLocationException {
        Token token = this.getTokenFrom(d, offset);
        if (!this.isEndOfLine(d, offset) && GroovyTokenTypeBridge.RCURLY == token.getType()) {
            return token.getColumn() - offset + d.getLineOffset(d.getLineOfOffset(offset));
        }
        return 0;
    }

    public boolean moreOpenThanCloseBefore(IDocument d, int offset) {
        return this.getOpenVersusCloseBalance(this.getLineTokensUpto(d, offset)) > 0;
    }

    public String newline(IDocument d) {
        return TextUtilities.getDefaultLineDelimiter((IDocument)d);
    }

    public void refreshPrefs() {
        this.prefs = new FormatterPreferences(this.project);
    }

    private int simpleComputeNextLineIndentLevel(int indentLevel, List<Token> tokens) {
        int adjust = this.getOpenVersusCloseBalance(tokens);
        if (adjust > 0) {
            indentLevel += this.getPrefs().getIndentationSize();
        } else if (adjust < 0) {
            indentLevel -= this.getPrefs().getIndentationSize();
        }
        return indentLevel;
    }
}

