/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.jdt.groovy.internal.compiler.ast.EventListener;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitScope;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyTypeDeclaration;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.LazilyResolvedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class GroovyClassScope
extends ClassScope {
    public static EventListener debugListener;
    private final TraitHelper traitHelper = new TraitHelper();

    public GroovyClassScope(Scope parent, TypeDeclaration typeDecl) {
        super(parent, typeDecl);
    }

    @Override
    protected MethodBinding[] augmentMethodBindings(MethodBinding[] methodBindings) {
        SourceTypeBinding typeBinding = this.referenceContext.binding;
        if (typeBinding == null || typeBinding.isInterface() || typeBinding.isAnnotationType()) {
            return methodBindings;
        }
        ReferenceBinding[] superInterfaces = typeBinding.superInterfaces();
        if (superInterfaces == null) {
            superInterfaces = Binding.NO_SUPERINTERFACES;
        } else if (superInterfaces.length > 1) {
            Collections.reverse(Arrays.asList(superInterfaces));
        }
        boolean implementsGroovyObject = false;
        ReferenceBinding[] referenceBindingArray = superInterfaces;
        int n = superInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            ReferenceBinding face = referenceBindingArray[n2];
            if (CharOperation.equals(face.compoundName, GroovyCompilationUnitScope.GROOVY_LANG_GROOVYOBJECT)) {
                implementsGroovyObject = true;
                break;
            }
            ++n2;
        }
        ArrayList<MethodBinding> groovyMethods = new ArrayList<MethodBinding>();
        if (implementsGroovyObject) {
            if (debugListener != null) {
                debugListener.record("augment: type " + this.referenceContext.name + " having GroovyObject methods added");
            }
            ReferenceBinding bindingJLO = this.getJavaLangObject();
            ReferenceBinding bindingJLS = this.getJavaLangString();
            ReferenceBinding bindingGLM = this.getGroovyLangMetaClass();
            this.createMethod("invokeMethod", new TypeBinding[]{bindingJLS, bindingJLO}, bindingJLO, methodBindings).ifPresent(groovyMethods::add);
            this.createMethod("getProperty", new TypeBinding[]{bindingJLS}, bindingJLO, methodBindings).ifPresent(groovyMethods::add);
            this.createMethod("setProperty", new TypeBinding[]{bindingJLS, bindingJLO}, TypeBinding.VOID, methodBindings).ifPresent(groovyMethods::add);
            this.createMethod("getMetaClass", Binding.NO_TYPES, bindingGLM, methodBindings).ifPresent(groovyMethods::add);
            this.createMethod("setMetaClass", new TypeBinding[]{bindingGLM}, TypeBinding.VOID, methodBindings).ifPresent(groovyMethods::add);
        }
        if (this.referenceContext instanceof GroovyTypeDeclaration) {
            for (PropertyNode property : ((GroovyTypeDeclaration)this.referenceContext).getClassNode().getProperties()) {
                int modifiers = this.getModifiers(property);
                if (Flags.isPackageDefault(modifiers)) continue;
                String capitalizedName = MetaClassHelper.capitalize(property.getName());
                if (property.getType().equals(ClassHelper.boolean_TYPE)) {
                    if (!this.createGetterMethod(property, "get" + capitalizedName, modifiers, methodBindings).isPresent()) continue;
                    this.createGetterMethod(property, "is" + capitalizedName, modifiers, methodBindings).ifPresent(binding -> {
                        groovyMethods.add((MethodBinding)binding);
                        this.createGetterMethod(property, "get" + capitalizedName, modifiers, methodBindings).ifPresent(groovyMethods::add);
                    });
                } else {
                    this.createGetterMethod(property, "get" + capitalizedName, modifiers, methodBindings).ifPresent(groovyMethods::add);
                }
                if (Flags.isFinal(property.getModifiers())) continue;
                this.createSetterMethod(property, "set" + capitalizedName, modifiers, methodBindings).ifPresent(groovyMethods::add);
            }
        }
        HashMap<String, MethodBinding> traitMethods = new HashMap<String, MethodBinding>();
        ReferenceBinding[] referenceBindingArray2 = superInterfaces;
        int capitalizedName = superInterfaces.length;
        int modifiers = 0;
        while (modifiers < capitalizedName) {
            ReferenceBinding face = referenceBindingArray2[modifiers];
            if (this.traitHelper.isTrait(face)) {
                ReferenceBinding helperBinding = this.traitHelper.getHelperBinding(face);
                MethodBinding[] methodBindingArray = face.availableMethods();
                int n3 = methodBindingArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    MethodBinding method = methodBindingArray[n4];
                    if (!method.isSynthetic() && this.isNotActuallyAbstract(method, helperBinding)) {
                        if ((method.modifiers & 0x800000) != 0) {
                            method.modifiers ^= 0x800408;
                        }
                        if ((method.modifiers & 0x4000000) != 0) {
                            method.modifiers ^= 0x4000010;
                        }
                        if (method.isPublic() || method.isStatic()) {
                            traitMethods.putIfAbsent(this.getMethodAsString(method), method);
                        }
                    }
                    ++n4;
                }
            }
            ++modifiers;
        }
        if (!traitMethods.isEmpty()) {
            MethodBinding[] methodBindingArray;
            HashSet<String> canBeOverridden = new HashSet<String>();
            ReferenceBinding superclass = typeBinding;
            while ((superclass = superclass.superclass()) != null) {
                methodBindingArray = superclass.availableMethods();
                int helperBinding = methodBindingArray.length;
                int n5 = 0;
                while (n5 < helperBinding) {
                    MethodBinding method = methodBindingArray[n5];
                    if (!(method.isConstructor() || method.isPrivate() || method.isStatic() || method.isFinal())) {
                        canBeOverridden.add(this.getMethodAsString(method));
                    }
                    ++n5;
                }
            }
            methodBindingArray = methodBindings;
            int helperBinding = methodBindings.length;
            int n6 = 0;
            while (n6 < helperBinding) {
                MethodBinding method = methodBindingArray[n6];
                if (!method.isConstructor()) {
                    String signature = this.getMethodAsString(method);
                    canBeOverridden.remove(signature);
                    traitMethods.remove(signature);
                }
                ++n6;
            }
            for (String key : canBeOverridden) {
                MethodBinding method = (MethodBinding)traitMethods.remove(key);
                if (method == null) continue;
                method = new MethodBinding(method, typeBinding);
                method.modifiers &= 0xFFFFFBFF;
                method.modifiers &= 0xFFFFFFFD;
                groovyMethods.add(method);
            }
            for (MethodBinding method : traitMethods.values()) {
                if (!method.isStatic()) continue;
                method = new MethodBinding(method, typeBinding);
                method.modifiers &= 0xFFFFFFFD;
                groovyMethods.add(method);
            }
        }
        int m = methodBindings.length;
        int n7 = m + groovyMethods.size();
        MethodBinding[] methods = Arrays.copyOf(methodBindings, n7);
        int i = m;
        int j = 0;
        while (i < n7) {
            methods[i] = (MethodBinding)groovyMethods.get(j);
            ++i;
            ++j;
        }
        return methods;
    }

    private ReferenceBinding getGroovyLangMetaClass() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(GroovyCompilationUnitScope.GROOVY_LANG_METACLASS);
        return unitScope.environment.getResolvedType(GroovyCompilationUnitScope.GROOVY_LANG_METACLASS, this);
    }

    private ReferenceBinding getGroovyTransformGenerated() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(GroovyCompilationUnitScope.GROOVY_TRANSFORM_GENERATED);
        return unitScope.environment.getResolvedType(GroovyCompilationUnitScope.GROOVY_TRANSFORM_GENERATED, this);
    }

    private int getModifiers(PropertyNode propertyNode) {
        int modifiers = propertyNode.getModifiers() & 0xF;
        if (propertyNode.getType().isUsingGenerics()) {
            modifiers |= 0x40000000;
        }
        char[] nameChars = propertyNode.getName().toCharArray();
        FieldDeclaration[] fieldDeclarationArray = this.referenceContext.fields;
        int n = this.referenceContext.fields.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration field = fieldDeclarationArray[n2];
            if (CharOperation.equals(field.name, nameChars)) {
                if (!Flags.isPackageDefault(field.modifiers)) break;
                modifiers &= 0xFFFFFFFE;
                break;
            }
            ++n2;
        }
        if (propertyNode.getField().getAnnotations().stream().map(anno -> anno.getClassNode().getName()).anyMatch(name -> name.equals("Deprecated") || name.equals("java.lang.Deprecated"))) {
            modifiers |= 0x100000;
        }
        return modifiers;
    }

    private String getMethodAsString(MethodBinding methodBinding) {
        StringBuilder key = new StringBuilder();
        key.append(methodBinding.selector).append('(');
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        int n = methodBinding.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            TypeBinding tb = typeBindingArray[n2];
            if (tb instanceof ReferenceBinding) {
                key.append(((ReferenceBinding)tb).readableName(false));
            } else if (tb != null) {
                key.append(tb.readableName());
            }
            key.append(';');
            ++n2;
        }
        key.append(')');
        return key.toString();
    }

    private boolean isNotActuallyAbstract(MethodBinding methodBinding, ReferenceBinding helperBinding) {
        if (methodBinding.declaringClass instanceof SourceTypeBinding) {
            AbstractMethodDeclaration methodDeclaration = ((SourceTypeBinding)methodBinding.declaringClass).scope.referenceContext.declarationOf(methodBinding);
            if (methodDeclaration != null) {
                return !Flags.isAbstract(methodDeclaration.modifiers);
            }
        } else if (methodBinding.declaringClass instanceof BinaryTypeBinding && helperBinding != null) {
            MethodBinding[] methodBindingArray = helperBinding.methods();
            int n = methodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                TypeBinding[] expectedParameters;
                TypeBinding[] actualParameters;
                MethodBinding m = methodBindingArray[n2];
                if (Arrays.equals(methodBinding.selector, m.selector) && (actualParameters = m.parameters).length == (expectedParameters = methodBinding.parameters).length + 1 && actualParameters[0].equals(methodBinding.declaringClass)) {
                    boolean same = true;
                    int i = 0;
                    int n3 = expectedParameters.length;
                    while (i < n3) {
                        if (!actualParameters[i + 1].equals(expectedParameters[i])) {
                            same = false;
                            break;
                        }
                        ++i;
                    }
                    return same && !m.isAbstract();
                }
                ++n2;
            }
        }
        return true;
    }

    private Optional<MethodBinding> asGenerated(MethodBinding methodBinding) {
        methodBinding.setAnnotations(new AnnotationBinding[]{new AnnotationBinding(this.getGroovyTransformGenerated(), Binding.NO_ELEMENT_VALUE_PAIRS)}, false);
        methodBinding.tagBits |= 0x600000000L;
        methodBinding.modifiers |= 0x400000;
        return Optional.of(methodBinding);
    }

    private Optional<MethodBinding> createMethod(String methodName, TypeBinding[] parameterTypes, TypeBinding returnType, MethodBinding[] methodBindings) {
        char[] nameChars = methodName.toCharArray();
        MethodBinding[] methodBindingArray = methodBindings;
        int n = methodBindings.length;
        int n2 = 0;
        while (n2 < n) {
            MethodBinding methodBinding = methodBindingArray[n2];
            if (CharOperation.equals(nameChars, methodBinding.selector)) {
                boolean equalParameters;
                ((SourceTypeBinding)methodBinding.declaringClass).resolveTypesFor(methodBinding);
                boolean bl = equalParameters = parameterTypes.length == methodBinding.parameters.length;
                if (equalParameters) {
                    int i = 0;
                    int n3 = parameterTypes.length;
                    while (i < n3) {
                        if (!CharOperation.equals(parameterTypes[i].signature(), methodBinding.parameters[i].signature())) {
                            equalParameters = false;
                            break;
                        }
                        ++i;
                    }
                }
                if (equalParameters) {
                    return Optional.empty();
                }
            }
            ++n2;
        }
        return this.asGenerated(new MethodBinding(1, nameChars, returnType, parameterTypes, Binding.NO_EXCEPTIONS, this.referenceContext.binding));
    }

    private Optional<MethodBinding> createGetterMethod(PropertyNode propertyNode, String methodName, int modifiers, MethodBinding[] methodBindings) {
        char[] nameChars = methodName.toCharArray();
        MethodBinding[] methodBindingArray = methodBindings;
        int n = methodBindings.length;
        int n2 = 0;
        while (n2 < n) {
            TypeBinding[] parameters;
            Argument[] arguments;
            MethodBinding methodBinding = methodBindingArray[n2];
            if (CharOperation.equals(nameChars, methodBinding.selector) && ((methodBinding.modifiers & 0x2000000) != 0 ? (arguments = methodBinding.sourceMethod().arguments) == null || arguments.length == 0 : (parameters = methodBinding.parameters) == null || parameters.length == 0)) {
                return Optional.empty();
            }
            ++n2;
        }
        if (ClassHelper.isPrimitiveType(propertyNode.getType())) {
            TypeBinding returnType = Scope.getBaseType(propertyNode.getType().getName().toCharArray());
            return this.asGenerated(new MethodBinding(modifiers, nameChars, returnType, Binding.NO_PARAMETERS, Binding.NO_EXCEPTIONS, this.referenceContext.binding));
        }
        return this.asGenerated(new LazilyResolvedMethodBinding(true, propertyNode.getName(), modifiers, nameChars, Binding.NO_EXCEPTIONS, (ReferenceBinding)this.referenceContext.binding));
    }

    private Optional<MethodBinding> createSetterMethod(PropertyNode propertyNode, String methodName, int modifiers, MethodBinding[] methodBindings) {
        char[] nameChars = methodName.toCharArray();
        MethodBinding[] methodBindingArray = methodBindings;
        int n = methodBindings.length;
        int n2 = 0;
        while (n2 < n) {
            TypeBinding[] parameters;
            Argument[] arguments;
            MethodBinding methodBinding = methodBindingArray[n2];
            if (CharOperation.equals(nameChars, methodBinding.selector) && ((methodBinding.modifiers & 0x2000000) != 0 ? (arguments = methodBinding.sourceMethod().arguments) != null && arguments.length == 1 : (parameters = methodBinding.parameters) != null && parameters.length == 1)) {
                return Optional.empty();
            }
            ++n2;
        }
        if (ClassHelper.isPrimitiveType(propertyNode.getType())) {
            TypeBinding[] parameterTypes = new TypeBinding[]{Scope.getBaseType(propertyNode.getType().getName().toCharArray())};
            return this.asGenerated(new MethodBinding(modifiers, nameChars, TypeBinding.VOID, parameterTypes, Binding.NO_EXCEPTIONS, this.referenceContext.binding));
        }
        int va = propertyNode.getType().isArray() ? 128 : 0;
        return this.asGenerated(new LazilyResolvedMethodBinding(false, propertyNode.getName(), modifiers | va, nameChars, Binding.NO_EXCEPTIONS, (ReferenceBinding)this.referenceContext.binding));
    }

    @Override
    protected void buildFieldsAndMethods() {
        super.buildFieldsAndMethods();
        FieldDeclaration[] fieldDeclarationArray = this.referenceContext.fields;
        int n = this.referenceContext.fields.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration field = fieldDeclarationArray[n2];
            Expression initialization = field.initialization;
            while (initialization instanceof CastExpression) {
                initialization = ((CastExpression)initialization).expression;
            }
            if (initialization instanceof QualifiedAllocationExpression) {
                QualifiedAllocationExpression allocation = (QualifiedAllocationExpression)initialization;
                if (allocation.anonymousType != null && allocation.anonymousType.scope == null) {
                    MethodScope scope;
                    MethodScope methodScope = scope = field.isStatic() ? this.referenceContext.staticInitializerScope : this.referenceContext.initializerScope;
                    if (field.binding.type == null) {
                        field.binding.type = field.getKind() == 3 ? scope.enclosingSourceType() : field.type.resolveType(scope);
                    }
                    field.resolve(scope);
                }
            }
            ++n2;
        }
    }

    @Override
    public boolean shouldReport(int problem) {
        switch (problem) {
            case 16777528: 
            case 16777531: 
            case 16777533: 
            case 16777741: 
            case 16777825: 
            case 67109264: 
            case 67109265: 
            case 67109268: 
            case 67109270: 
            case 67109271: 
            case 67109273: 
            case 67109424: 
            case 67109498: 
            case 67109627: 
            case 67109667: 
            case 0x8000082: {
                return false;
            }
        }
        return true;
    }

    private class TraitHelper {
        private boolean lookForTraitAlias;
        private boolean toBeInitialized = true;

        private TraitHelper() {
        }

        private void initialize() {
            ImportBinding[] imports = GroovyClassScope.this.referenceContext.scope.compilationUnitScope().imports;
            if (imports != null) {
                ImportBinding[] importBindingArray = imports;
                int n = imports.length;
                int n2 = 0;
                while (n2 < n) {
                    ImportBinding i = importBindingArray[n2];
                    String importedType = new String(i.readableName());
                    if ("groovy.transform.Trait".equals(importedType)) {
                        this.lookForTraitAlias = true;
                        break;
                    }
                    if (importedType.endsWith(".Trait")) {
                        this.lookForTraitAlias = false;
                        break;
                    }
                    if ("groovy.transform.*".equals(importedType)) {
                        this.lookForTraitAlias = true;
                    }
                    ++n2;
                }
                this.toBeInitialized = true;
            }
        }

        private boolean isTrait(ReferenceBinding referenceBinding) {
            if (referenceBinding != null) {
                AnnotationBinding[] annotations;
                if (this.toBeInitialized) {
                    this.initialize();
                }
                if ((annotations = referenceBinding.getAnnotations()) != null) {
                    AnnotationBinding[] annotationBindingArray = annotations;
                    int n = annotations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AnnotationBinding annotation = annotationBindingArray[n2];
                        if (annotation != null) {
                            ReferenceBinding annotationType = annotation.getAnnotationType();
                            String annotationName = CharOperation.toString(annotationType.compoundName);
                            if ("groovy.transform.Trait".equals(annotationName)) {
                                return true;
                            }
                            if (this.lookForTraitAlias && "Trait".equals(annotationName)) {
                                return true;
                            }
                        }
                        ++n2;
                    }
                }
            }
            return false;
        }

        private ReferenceBinding getHelperBinding(ReferenceBinding interfaceBinding) {
            if (interfaceBinding instanceof BinaryTypeBinding) {
                StringBuilder nameBuilder = new StringBuilder();
                nameBuilder.append(interfaceBinding.sourceName);
                nameBuilder.append("$Trait$Helper");
                ReferenceBinding helperBinding = GroovyClassScope.this.compilationUnitScope().findType(nameBuilder.toString().toCharArray(), interfaceBinding.fPackage, interfaceBinding.fPackage);
                if (helperBinding != null && helperBinding instanceof ProblemReferenceBinding) {
                    helperBinding = ((ProblemReferenceBinding)helperBinding).closestReferenceMatch();
                }
                return helperBinding;
            }
            return null;
        }
    }
}

