/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationProvider;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.lookup.SignatureWrapper;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.util.KeyToSignature;

public final class ExternalAnnotationUtil {
    public static final char NULLABLE = '0';
    public static final char NONNULL = '1';
    public static final char NO_ANNOTATION = '@';
    private static final int POSITION_RETURN_TYPE = -1;
    private static final int POSITION_FULL_SIGNATURE = -2;
    private static final int POSITION_TYPE_PARAMETER = -3;

    public static String extractGenericSignature(IMethodBinding methodBinding) {
        KeyToSignature parser = new KeyToSignature(methodBinding.getKey(), 0, true);
        parser.parse();
        return parser.toString();
    }

    public static String extractGenericTypeSignature(ITypeBinding type) {
        KeyToSignature parser = new KeyToSignature(type.getKey(), 0, true);
        parser.parse();
        return parser.toString();
    }

    public static String extractGenericTypeParametersSignature(ITypeBinding type) {
        StringBuilder signature = new StringBuilder().append('<');
        ITypeBinding[] iTypeBindingArray = type.getTypeParameters();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding typeParameter = iTypeBindingArray[n2];
            signature.append(typeParameter.getName());
            signature.append(':');
            ITypeBinding superclass = typeParameter.getSuperclass();
            if (superclass != null) {
                String superclassSignature = ExternalAnnotationUtil.extractGenericTypeSignature(superclass);
                boolean superIsRelevant = typeParameter.getInterfaces().length == 0;
                if (superIsRelevant |= !superclassSignature.equals(new String(ConstantPool.JavaLangObjectSignature))) {
                    signature.append(superclassSignature);
                }
            }
            ITypeBinding[] iTypeBindingArray2 = typeParameter.getInterfaces();
            int n3 = iTypeBindingArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                ITypeBinding superInterface = iTypeBindingArray2[n4];
                signature.append(':').append(ExternalAnnotationUtil.extractGenericTypeSignature(superInterface));
                ++n4;
            }
            ++n2;
        }
        signature.append('>');
        return signature.toString();
    }

    public static String insertReturnAnnotation(String methodSignature, char annotation, MergeStrategy mergeStrategy) {
        int close = methodSignature.indexOf(41);
        if (close == -1 || close > methodSignature.length() - 4) {
            throw new IllegalArgumentException("Malformed method signature");
        }
        switch (methodSignature.charAt(close + 1)) {
            case 'L': 
            case 'T': 
            case '[': {
                return ExternalAnnotationUtil.insertAt(methodSignature, close + 2, annotation, mergeStrategy);
            }
        }
        throw new IllegalArgumentException("Return type is not a reference type");
    }

    public static String insertParameterAnnotation(String methodSignature, int paramIdx, char annotation, MergeStrategy mergeStrategy) {
        SignatureWrapper wrapper = new SignatureWrapper(methodSignature.toCharArray());
        wrapper.start = 1;
        int i = 0;
        while (i < paramIdx) {
            wrapper.start = wrapper.computeEnd() + 1;
            ++i;
        }
        int start = wrapper.start;
        switch (methodSignature.charAt(start)) {
            case 'L': 
            case 'T': 
            case '[': {
                return ExternalAnnotationUtil.insertAt(methodSignature, start + 1, annotation, mergeStrategy);
            }
        }
        throw new IllegalArgumentException("Paramter type is not a reference type");
    }

    public static IFile getAnnotationFile(IJavaProject project, ITypeBinding type, IProgressMonitor monitor) throws CoreException {
        IFile annotationZip;
        IType targetType = project.findType(type.getErasure().getQualifiedName());
        if (!targetType.exists()) {
            return null;
        }
        String binaryTypeName = targetType.getFullyQualifiedName('$').replace('.', '/');
        IPackageFragmentRoot packageRoot = (IPackageFragmentRoot)targetType.getAncestor(3);
        IClasspathEntry entry = packageRoot.getResolvedClasspathEntry();
        IPath annotationPath = ClasspathEntry.getExternalAnnotationPath(entry, project.getProject(), false);
        if (annotationPath == null) {
            return null;
        }
        IWorkspaceRoot workspaceRoot = project.getProject().getWorkspace().getRoot();
        if (annotationPath.segmentCount() > 1 && (annotationZip = workspaceRoot.getFile(annotationPath)).exists()) {
            return null;
        }
        annotationPath = annotationPath.append(binaryTypeName).addFileExtension("eea");
        return workspaceRoot.getFile(annotationPath);
    }

    public static void annotateMember(String typeName, IFile file, String selector, String originalSignature, String annotatedSignature, MergeStrategy mergeStrategy, IProgressMonitor monitor) throws CoreException, IOException {
        ExternalAnnotationUtil.annotateMember(typeName, file, selector, originalSignature, annotatedSignature, -2, mergeStrategy, monitor);
    }

    public static void annotateTypeTypeParameter(String typeName, IFile file, String originalSignature, String annotatedTypeParameter, int rank, MergeStrategy mergeStrategy, IProgressMonitor monitor) throws CoreException, IOException, IllegalArgumentException {
        ExternalAnnotationUtil.annotateMember(typeName, file, null, originalSignature, annotatedTypeParameter, -3 - rank, mergeStrategy, monitor);
    }

    public static void annotateMethodTypeParameter(String typeName, IFile file, String selector, String originalSignature, String annotatedTypeParameter, int rank, MergeStrategy mergeStrategy, IProgressMonitor monitor) throws CoreException, IOException, IllegalArgumentException {
        ExternalAnnotationUtil.annotateMember(typeName, file, selector, originalSignature, annotatedTypeParameter, -3 - rank, mergeStrategy, monitor);
    }

    public static void annotateMethodReturnType(String typeName, IFile file, String selector, String originalSignature, String annotatedReturnType, MergeStrategy mergeStrategy, IProgressMonitor monitor) throws CoreException, IOException, IllegalArgumentException {
        ExternalAnnotationUtil.annotateMember(typeName, file, selector, originalSignature, annotatedReturnType, -1, mergeStrategy, monitor);
    }

    public static void annotateMethodParameterType(String typeName, IFile file, String selector, String originalSignature, String annotatedParameterType, int paramIdx, MergeStrategy mergeStrategy, IProgressMonitor monitor) throws CoreException, IOException, IllegalArgumentException {
        ExternalAnnotationUtil.annotateMember(typeName, file, selector, originalSignature, annotatedParameterType, paramIdx, mergeStrategy, monitor);
    }

    private static void annotateMember(String typeName, IFile file, String selector, String originalSignature, String annotatedSignature, int updatePosition, MergeStrategy mergeStrategy, IProgressMonitor monitor) throws CoreException, IOException, IllegalArgumentException {
        if (!file.exists()) {
            annotatedSignature = ExternalAnnotationUtil.updateSignature(originalSignature, annotatedSignature, updatePosition, MergeStrategy.REPLACE_SIGNATURE);
            StringBuffer newContent = new StringBuffer();
            newContent.append("class ");
            newContent.append(typeName).append('\n');
            if (selector != null) {
                newContent.append(selector).append('\n');
            }
            newContent.append(' ').append(originalSignature).append('\n');
            newContent.append(' ').append(annotatedSignature).append('\n');
            ExternalAnnotationUtil.createNewFile(file, newContent.toString(), monitor);
        } else {
            StringBuffer newContent = new StringBuffer();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents()));){
                String line;
                String previousSignature = originalSignature;
                newContent.append(reader.readLine()).append('\n');
                while ((line = reader.readLine()) != null) {
                    if (selector == null) {
                        if (!line.trim().startsWith("<")) break;
                        line = reader.readLine();
                        assert (line.trim().startsWith("<"));
                        previousSignature = line.trim();
                        line = reader.readLine();
                        break;
                    }
                    if (line.isEmpty()) {
                        newContent.append('\n');
                        continue;
                    }
                    if (!Character.isJavaIdentifierStart(line.charAt(0)) && line.charAt(0) != '<') {
                        newContent.append(line).append('\n');
                        continue;
                    }
                    int relation = line.compareTo(selector);
                    if (relation > 0) break;
                    if (relation < 0) {
                        newContent.append(line).append('\n');
                        continue;
                    }
                    if (relation != 0) continue;
                    StringBuffer pending = new StringBuffer(line).append('\n');
                    line = reader.readLine();
                    pending.append(line);
                    if (line == null) break;
                    relation = line.trim().compareTo(originalSignature);
                    if (relation > 0) {
                        line = pending.toString();
                        break;
                    }
                    newContent.append(pending).append('\n');
                    if (relation < 0 || relation != 0) continue;
                    String annotationLine = reader.readLine();
                    String nextLine = null;
                    if (annotationLine == null || annotationLine.isEmpty() || !annotationLine.startsWith(" ")) {
                        nextLine = annotationLine;
                        annotationLine = line;
                    }
                    if (annotationLine.startsWith(" ")) {
                        switch (mergeStrategy) {
                            case REPLACE_SIGNATURE: {
                                break;
                            }
                            case OVERWRITE_ANNOTATIONS: 
                            case ADD_ANNOTATIONS: {
                                annotatedSignature = ExternalAnnotationUtil.updateSignature(annotationLine.trim(), annotatedSignature, updatePosition, mergeStrategy);
                                break;
                            }
                            default: {
                                JavaCore.getJavaCore().getLog().log((IStatus)new Status(4, "org.eclipse.jdt.core", "Unexpected value for enum MergeStrategy"));
                            }
                        }
                    }
                    ExternalAnnotationUtil.writeFile(file, newContent, annotatedSignature, nextLine, reader, monitor);
                    return;
                }
                if (selector != null) {
                    newContent.append(selector).append('\n');
                }
                newContent.append(' ').append(originalSignature).append('\n');
                annotatedSignature = ExternalAnnotationUtil.updateSignature(previousSignature, annotatedSignature, updatePosition, mergeStrategy);
                ExternalAnnotationUtil.writeFile(file, newContent, annotatedSignature, line, reader, monitor);
            }
        }
    }

    private static String updateSignature(String originalSignature, String annotatedSignature, int updatePosition, MergeStrategy mergeStrategy) {
        StringBuffer buf = new StringBuffer();
        String postfix = null;
        if (updatePosition <= -3) {
            assert (originalSignature.charAt(0) == '<') : "generic signature must start with '<'";
            SignatureWrapper wrapper = new SignatureWrapper(originalSignature.toCharArray(), true, true);
            wrapper.start = 1;
            int i = 0;
            while (i < -updatePosition + -3) {
                wrapper.skipTypeParameter();
                ++i;
            }
            int start = wrapper.start;
            buf.append(originalSignature, 0, start);
            int end = wrapper.skipTypeParameter();
            String signatureToReplace = originalSignature.substring(start, end);
            ExternalAnnotationUtil.updateTypeParameter(buf, signatureToReplace.toCharArray(), annotatedSignature.toCharArray(), mergeStrategy);
            postfix = originalSignature.substring(end, originalSignature.length());
        } else {
            String signatureToReplace;
            switch (updatePosition) {
                case -2: {
                    signatureToReplace = originalSignature;
                    break;
                }
                case -1: {
                    assert (originalSignature.charAt(0) == '(' || originalSignature.charAt(0) == '<') : "signature must start with '(' or '<'";
                    int close = originalSignature.indexOf(41);
                    buf.append(originalSignature, 0, close + 1);
                    signatureToReplace = originalSignature.substring(close + 1);
                    break;
                }
                default: {
                    SignatureWrapper wrapper = new SignatureWrapper(originalSignature.toCharArray(), true, true);
                    wrapper.start = CharOperation.indexOf('(', wrapper.signature) + 1;
                    int i = 0;
                    while (i < updatePosition) {
                        wrapper.start = wrapper.skipAngleContents(wrapper.computeEnd()) + 1;
                        ++i;
                    }
                    int start = wrapper.start;
                    int end = wrapper.skipAngleContents(wrapper.computeEnd());
                    buf.append(originalSignature, 0, start);
                    signatureToReplace = originalSignature.substring(start, end + 1);
                    postfix = originalSignature.substring(end + 1, originalSignature.length());
                }
            }
            ExternalAnnotationUtil.updateType(buf, signatureToReplace.toCharArray(), annotatedSignature.toCharArray(), mergeStrategy);
        }
        if (postfix != null) {
            buf.append(postfix);
        }
        return buf.toString();
    }

    private static String insertAt(String signature, int position, char annotation, MergeStrategy mergeStrategy) {
        StringBuilder result = new StringBuilder();
        result.append(signature, 0, position);
        result.append(annotation);
        char next = signature.charAt(position);
        switch (next) {
            case '0': 
            case '1': {
                if (mergeStrategy == MergeStrategy.ADD_ANNOTATIONS) {
                    return signature;
                }
                ++position;
            }
        }
        result.append(signature, position, signature.length());
        return result.toString();
    }

    private static boolean updateType(StringBuffer buf, char[] oldType, char[] newType, MergeStrategy mergeStrategy) {
        block8: {
            block9: {
                if (mergeStrategy == MergeStrategy.REPLACE_SIGNATURE) {
                    buf.append(newType);
                    return false;
                }
                try {
                    SignatureWrapper oWrap = new SignatureWrapper(oldType, true, true);
                    SignatureWrapper nWrap = new SignatureWrapper(newType, true, true);
                    if (ExternalAnnotationUtil.match(buf, oWrap, nWrap, 'L', false) || ExternalAnnotationUtil.match(buf, oWrap, nWrap, 'T', false)) {
                        ExternalAnnotationUtil.mergeAnnotation(buf, oWrap, nWrap, mergeStrategy);
                        buf.append(oWrap.nextName());
                        nWrap.nextName();
                        if (ExternalAnnotationUtil.match(buf, oWrap, nWrap, '<', false)) {
                            do {
                                int oStart = oWrap.start;
                                int nStart = nWrap.start;
                                oWrap.computeEnd();
                                nWrap.computeEnd();
                                if (!ExternalAnnotationUtil.updateType(buf, oWrap.getFrom(oStart), nWrap.getFrom(nStart), mergeStrategy)) continue;
                                ExternalAnnotationUtil.mergeAnnotation(buf, oWrap, nWrap, mergeStrategy);
                            } while (!ExternalAnnotationUtil.match(buf, oWrap, nWrap, '>', false));
                        }
                        ExternalAnnotationUtil.match(buf, oWrap, nWrap, ';', true);
                        break block8;
                    }
                    if (ExternalAnnotationUtil.match(buf, oWrap, nWrap, '[', false)) {
                        ExternalAnnotationUtil.mergeAnnotation(buf, oWrap, nWrap, mergeStrategy);
                        ExternalAnnotationUtil.updateType(buf, oWrap.tail(), nWrap.tail(), mergeStrategy);
                        break block8;
                    }
                    if (!ExternalAnnotationUtil.match(buf, oWrap, nWrap, '*', false) && !ExternalAnnotationUtil.match(buf, oWrap, nWrap, '+', false) && !ExternalAnnotationUtil.match(buf, oWrap, nWrap, '-', false)) break block9;
                    return true;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    StringBuilder msg = new StringBuilder("Structural mismatch between ").append(oldType).append(" and ").append(newType);
                    throw new IllegalArgumentException(msg.toString(), aioobe);
                }
            }
            buf.append(oldType);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean updateTypeParameter(StringBuffer buf, char[] oldType, char[] newType, MergeStrategy mergeStrategy) {
        if (mergeStrategy == MergeStrategy.REPLACE_SIGNATURE) {
            buf.append(newType);
            return false;
        }
        try {
            SignatureWrapper oWrap = new SignatureWrapper(oldType, true, true);
            SignatureWrapper nWrap = new SignatureWrapper(newType, true, true);
            ExternalAnnotationUtil.mergeAnnotation(buf, oWrap, nWrap, mergeStrategy);
            char[] oName = oWrap.wordUntil(':');
            char[] nName = nWrap.wordUntil(':');
            if (!CharOperation.equals(oName, nName)) {
                StringBuilder msg = new StringBuilder("Structural mismatch between type parameters ").append(oName).append(" and ").append(nName);
                throw new IllegalArgumentException(msg.toString());
            }
            buf.append(oName);
            while (true) {
                char[] oType;
                if (!ExternalAnnotationUtil.match(buf, oWrap, nWrap, ':', false)) {
                    return false;
                }
                int oStart = oWrap.start;
                int nStart = nWrap.start--;
                nWrap.skipAngleContents(nWrap.computeEnd());
                char[] nType = nWrap.getFrom(nStart);
                if (oWrap.charAtStart() == ':') {
                    if (CharOperation.equals(nType, new char[]{':'}) || CharOperation.equals(nType, ConstantPool.JavaLangObjectSignature)) continue;
                    oType = ConstantPool.JavaLangObjectSignature;
                } else {
                    oWrap.skipAngleContents(oWrap.computeEnd());
                    oType = oWrap.getFrom(oStart);
                }
                if (ExternalAnnotationUtil.updateType(buf, oType, nType, mergeStrategy)) {
                    ExternalAnnotationUtil.mergeAnnotation(buf, oWrap, nWrap, mergeStrategy);
                }
                if (oWrap.atEnd()) return false;
                if (nWrap.atEnd()) break;
            }
            return false;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            StringBuilder msg = new StringBuilder("Structural mismatch between ").append(oldType).append(" and ").append(newType);
            throw new IllegalArgumentException(msg.toString(), aioobe);
        }
    }

    private static boolean match(StringBuffer buf, SignatureWrapper sig1, SignatureWrapper sig2, char expected, boolean force) {
        boolean match2;
        boolean match1 = sig1.signature[sig1.start] == expected;
        boolean bl = match2 = sig2.signature[sig2.start] == expected;
        if (match1 != match2) {
            StringBuilder msg = new StringBuilder("Mismatching type structures ").append(sig1.signature).append(" vs ").append(sig2.signature);
            throw new IllegalArgumentException(msg.toString());
        }
        if (match1) {
            buf.append(expected);
            ++sig1.start;
            ++sig2.start;
            return true;
        }
        if (force) {
            throw new IllegalArgumentException("Expected char " + expected + " not found in " + new String(sig1.signature));
        }
        return false;
    }

    private static void mergeAnnotation(StringBuffer buf, SignatureWrapper oldS, SignatureWrapper newS, MergeStrategy mergeStrategy) {
        char oldAnn = !oldS.atEnd() ? oldS.signature[oldS.start] : (char)'\u0000';
        char newAnn = !newS.atEnd() ? newS.signature[newS.start] : (char)'\u0000';
        block0 : switch (mergeStrategy) {
            case ADD_ANNOTATIONS: {
                switch (oldAnn) {
                    case '0': 
                    case '1': {
                        ++oldS.start;
                        buf.append(oldAnn);
                        switch (newAnn) {
                            case '0': 
                            case '1': {
                                ++newS.start;
                            }
                        }
                        return;
                    }
                }
            }
            case OVERWRITE_ANNOTATIONS: {
                switch (newAnn) {
                    case '0': 
                    case '1': {
                        ++newS.start;
                        buf.append(newAnn);
                        switch (oldAnn) {
                            case '0': 
                            case '1': {
                                ++oldS.start;
                            }
                        }
                        break block0;
                    }
                    case '@': {
                        ++newS.start;
                        switch (oldAnn) {
                            case '0': 
                            case '1': {
                                ++oldS.start;
                            }
                        }
                        break block0;
                    }
                }
                switch (oldAnn) {
                    case '0': 
                    case '1': {
                        ++oldS.start;
                        buf.append(oldAnn);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected merge strategy");
            }
        }
    }

    private static void writeFile(IFile annotationFile, StringBuffer head, String annotatedSignature, String nextLines, BufferedReader tailReader, IProgressMonitor monitor) throws CoreException, IOException {
        String line;
        head.append(' ').append(annotatedSignature).append('\n');
        if (nextLines != null) {
            head.append(nextLines).append('\n');
        }
        while ((line = tailReader.readLine()) != null) {
            head.append(line).append('\n');
        }
        ByteArrayInputStream newContent = new ByteArrayInputStream(head.toString().getBytes("UTF-8"));
        annotationFile.setContents((InputStream)newContent, 2, monitor);
    }

    private static void createNewFile(IFile file, String newContent, IProgressMonitor monitor) throws CoreException {
        ExternalAnnotationUtil.ensureExists(file.getParent(), monitor);
        try {
            file.create((InputStream)new ByteArrayInputStream(newContent.getBytes("UTF-8")), false, monitor);
        }
        catch (UnsupportedEncodingException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core", e.getMessage(), (Throwable)e));
        }
    }

    private static void ensureExists(IContainer container, IProgressMonitor monitor) throws CoreException {
        if (container.exists()) {
            return;
        }
        if (!(container instanceof IFolder)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core", "not a folder: " + container));
        }
        IContainer parent = container.getParent();
        if (parent instanceof IFolder) {
            ExternalAnnotationUtil.ensureExists(parent, monitor);
        }
        ((IFolder)container).create(false, true, monitor);
    }

    public static String getAnnotatedSignature(String typeName, IFile file, String selector, String originalSignature) {
        if (file.exists()) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents()));){
                    String line;
                    ExternalAnnotationProvider.assertClassHeader(reader.readLine(), typeName);
                    do {
                        line = reader.readLine();
                        if (!(selector != null ? selector.equals(line) && originalSignature.equals(ExternalAnnotationProvider.extractSignature(line = reader.readLine())) : line != null && line.trim().startsWith("<") && originalSignature.equals(ExternalAnnotationProvider.extractSignature(line)))) continue;
                        return ExternalAnnotationProvider.extractSignature(reader.readLine());
                    } while (line != null);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException e) {
                return null;
            }
        }
        return null;
    }

    public static String[] annotateType(String originalSignature, String annotatedType, MergeStrategy mergeStrategy) {
        String[] result = new String[4];
        result[0] = "";
        StringBuffer buf = new StringBuffer();
        result[1] = originalSignature;
        ExternalAnnotationUtil.updateType(buf, originalSignature.toCharArray(), annotatedType.toCharArray(), mergeStrategy);
        result[2] = buf.toString();
        result[3] = "";
        return result;
    }

    public static String[] annotateReturnType(String originalSignature, String annotatedType, MergeStrategy mergeStrategy) {
        String[] result = new String[4];
        assert (originalSignature.charAt(0) == '(' || originalSignature.charAt(0) == '<') : "signature must start with '(' or '<'";
        int close = originalSignature.indexOf(41);
        result[0] = originalSignature.substring(0, close + 1);
        StringBuffer buf = new StringBuffer();
        result[1] = originalSignature.substring(close + 1);
        ExternalAnnotationUtil.updateType(buf, result[1].toCharArray(), annotatedType.toCharArray(), mergeStrategy);
        result[2] = buf.toString();
        result[3] = "";
        return result;
    }

    public static String[] annotateParameterType(String originalSignature, String annotatedType, int paramIdx, MergeStrategy mergeStrategy) {
        String[] result = new String[4];
        SignatureWrapper wrapper = new SignatureWrapper(originalSignature.toCharArray(), true, true);
        wrapper.start = CharOperation.indexOf('(', wrapper.signature) + 1;
        int i = 0;
        while (i < paramIdx) {
            wrapper.start = wrapper.skipAngleContents(wrapper.computeEnd()) + 1;
            ++i;
        }
        int start = wrapper.start;
        int end = wrapper.skipAngleContents(wrapper.computeEnd());
        result[0] = originalSignature.substring(0, start);
        StringBuffer buf = new StringBuffer();
        result[1] = originalSignature.substring(start, end + 1);
        ExternalAnnotationUtil.updateType(buf, result[1].toCharArray(), annotatedType.toCharArray(), mergeStrategy);
        result[2] = buf.toString();
        result[3] = originalSignature.substring(end + 1, originalSignature.length());
        return result;
    }

    public static String[] annotateTypeParameter(String originalSignature, String annotatedType, int rank, MergeStrategy mergeStrategy) {
        String[] result = new String[4];
        StringBuffer buf = new StringBuffer();
        SignatureWrapper wrapper = new SignatureWrapper(originalSignature.toCharArray(), true, true);
        wrapper.start = 1;
        int i = 0;
        while (i < rank) {
            wrapper.skipTypeParameter();
            ++i;
        }
        int start = wrapper.start;
        result[0] = originalSignature.substring(0, start);
        int end = wrapper.skipTypeParameter();
        result[1] = originalSignature.substring(start, end);
        SignatureWrapper oWrap = new SignatureWrapper(result[1].toCharArray());
        SignatureWrapper nWrap = new SignatureWrapper(annotatedType.toCharArray());
        ExternalAnnotationUtil.mergeAnnotation(buf, oWrap, nWrap, mergeStrategy);
        ExternalAnnotationUtil.updateTypeParameter(buf, oWrap.tail(), nWrap.tail(), mergeStrategy);
        result[2] = buf.toString();
        result[3] = originalSignature.substring(end, originalSignature.length());
        return result;
    }

    public static enum MergeStrategy {
        REPLACE_SIGNATURE,
        OVERWRITE_ANNOTATIONS,
        ADD_ANNOTATIONS;

    }
}

