/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.core;

import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.groovy.core.Activator;
import org.eclipse.jdt.groovy.core.util.ContentTypeUtils;

public class GroovyResourceAdapter
implements IAdapterFactory {
    public Class<?>[] getAdapterList() {
        return new Class[]{GroovyCompilationUnit.class, ICompilationUnit.class, ModuleNode.class, ClassNode[].class, ClassNode.class};
    }

    public <T> T getAdapter(Object adaptable, Class<T> adapterType) {
        Object result;
        block9: {
            result = null;
            if (adaptable instanceof IFile && Arrays.asList(this.getAdapterList()).contains(adapterType) && ContentTypeUtils.isGroovyLikeFileName(((IFile)adaptable).getName())) {
                try {
                    GroovyCompilationUnit unit = (GroovyCompilationUnit)JavaCore.createCompilationUnitFrom((IFile)adaptable);
                    if (adapterType.isAssignableFrom(GroovyCompilationUnit.class)) {
                        result = unit;
                        break block9;
                    }
                    ModuleNode module = unit.getModuleNode();
                    if (module == null) break block9;
                    if (adapterType.equals(ModuleNode.class)) {
                        result = module;
                        break block9;
                    }
                    List<ClassNode> classNodes = module.getClasses();
                    if (classNodes == null || classNodes.isEmpty()) break block9;
                    if (adapterType.equals(ClassNode.class)) {
                        if (classNodes.size() == 1) {
                            result = classNodes.get(0);
                            break block9;
                        }
                        String mainClassName = module.getMainClassName();
                        for (ClassNode classNode : classNodes) {
                            if (!classNode.getName().equals(mainClassName)) continue;
                            result = classNode;
                            break block9;
                        }
                        break block9;
                    }
                    if (adapterType.equals(ClassNode[].class)) {
                        result = classNodes.toArray(ClassNode.EMPTY_ARRAY);
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.jdt.groovy.core", "error adapting IFile to " + adapterType.getSimpleName(), (Throwable)e));
                }
            }
        }
        return (T)result;
    }
}

