/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.wtp;

import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseFramework;
import com.diffplug.spotless.extra.eclipse.wtp.sse.PreventExternalURIResolverExtension;
import com.diffplug.spotless.extra.eclipse.wtp.sse.SpotlessPreferences;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.dtd.core.internal.DTDCorePlugin;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.formatter.DefaultXMLPartitionFormatter;
import org.eclipse.wst.xml.core.internal.formatter.XMLFormattingPreferences;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryAdapterFactoryForXML;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.parser.XMLSourceParser;
import org.eclipse.wst.xml.core.internal.preferences.XMLCorePreferenceInitializer;
import org.eclipse.wst.xml.core.internal.text.rules.StructuredTextPartitionerForXML;
import org.eclipse.wst.xsd.core.internal.XSDCorePlugin;
import org.eclipse.xsd.util.XSDSchemaBuildingTools;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleException;

public class EclipseXmlFormatterStepImpl {
    private static XmlFormattingPreferencesFactory PREFERENCE_FACTORY = null;
    private final DefaultXMLPartitionFormatter formatter;
    private final XMLFormattingPreferences preferences;
    private final INodeAdapterFactory xmlAdapterFactory;

    public EclipseXmlFormatterStepImpl(Properties properties) throws Exception {
        boolean resolveExternalURI = Boolean.parseBoolean(properties.getProperty("resolveExternalURI", "false"));
        EclipseXmlFormatterStepImpl.setupFramework(resolveExternalURI);
        this.preferences = PREFERENCE_FACTORY.create(properties);
        this.formatter = new DefaultXMLPartitionFormatter();
        this.xmlAdapterFactory = new ModelQueryAdapterFactoryForXML();
    }

    private static void setupFramework(boolean resolveExternalURI) throws BundleException {
        if (SpotlessEclipseFramework.setup(config -> {
            config.applyDefault();
            config.useSlf4J(EclipseXmlFormatterStepImpl.class.getPackage().getName());
        }, plugins -> {
            plugins.applyDefault();
            plugins.add((BundleActivator)new XMLCorePlugin());
            plugins.add((BundleActivator)new URIResolverPlugin());
            plugins.add((BundleActivator)new DTDCorePlugin());
            plugins.add((BundleActivator)new XSDCorePlugin());
            if (!resolveExternalURI) {
                plugins.add((BundleActivator)new PreventExternalURIResolverExtension());
            }
        })) {
            PREFERENCE_FACTORY = new XmlFormattingPreferencesFactory();
            XSDSchemaBuildingTools.getXSDFactory();
        }
    }

    public String format(String raw, String baseLocation) throws Exception {
        BasicStructuredDocument document = new BasicStructuredDocument(new XMLSourceParser());
        document.setPreferredLineDelimiter("\n");
        StructuredTextPartitionerForXML partitioner = new StructuredTextPartitionerForXML();
        document.setDocumentPartitioner(new StructuredTextPartitionerForXML());
        partitioner.connect(document);
        document.set(raw);
        DOMModelImpl xmlDOM = new DOMModelImpl();
        xmlDOM.setBaseLocation(baseLocation);
        xmlDOM.getFactoryRegistry().addFactory(this.xmlAdapterFactory);
        xmlDOM.setStructuredDocument(document);
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery(xmlDOM);
        modelQuery.getCMDocumentManager().setPropertyEnabled("useCachedResovledURI", true);
        TextEdit formatterChanges = this.formatter.format(xmlDOM, 0, document.getLength(), this.preferences);
        formatterChanges.apply((IDocument)document);
        return document.get();
    }

    private static class XmlFormattingPreferencesFactory {
        private static final Set<String> SUPPORTED_XML_FORMAT_PREFS = new HashSet<String>(Arrays.asList("formatCommentText", "formatCommentJoinLines", "lineWidth", "splitMultiAttrs", "alignEndBracket", "spaceBeforeEmptyCloseTag", "preserveCDATAContent", "indentationChar", "indentationSize", "clearAllBlankLines"));

        XmlFormattingPreferencesFactory() {
            XMLCorePreferenceInitializer initializer = new XMLCorePreferenceInitializer();
            initializer.initializeDefaultPreferences();
            Properties properties = new Properties();
            properties.setProperty("cmDocumentGlobalCacheEnabled", Boolean.toString(false));
            XMLCorePlugin plugin = XMLCorePlugin.getDefault();
            SpotlessPreferences.configurePluginPreferences(plugin, properties);
        }

        XMLFormattingPreferences create(Properties properties) {
            SpotlessPreferences.configureCatalog(properties);
            return this.createFormattingPreference(properties);
        }

        private XMLFormattingPreferences createFormattingPreference(Properties properties) {
            Properties newXmlProperties = this.getXMLFormattingProperties(properties);
            XMLCorePlugin plugin = XMLCorePlugin.getDefault();
            Properties defaultXmlProperties = SpotlessPreferences.configurePluginPreferences(plugin, newXmlProperties);
            XMLFormattingPreferences xmlPreferences = new XMLFormattingPreferences();
            SpotlessPreferences.configurePluginPreferences(plugin, defaultXmlProperties);
            return xmlPreferences;
        }

        private Properties getXMLFormattingProperties(Properties properties) {
            Properties filteredProperties = new Properties();
            properties.entrySet().stream().filter(entry -> SUPPORTED_XML_FORMAT_PREFS.contains(entry.getKey())).forEach(entry -> filteredProperties.put(entry.getKey(), entry.getValue()));
            return filteredProperties;
        }
    }
}

