/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.wtp.sse;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.Catalog;
import org.eclipse.wst.xml.core.internal.catalog.CatalogReader;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;

public class SpotlessPreferences {
    public static final String USER_CATALOG = "userCatalog";
    public static final String RESOLVE_EXTERNAL_URI = "resolveExternalURI";

    public static Properties configurePluginPreferences(Plugin plugin, Properties newValues) {
        IEclipsePreferences globalPreferences = DefaultScope.INSTANCE.getNode(plugin.getBundle().getSymbolicName());
        Properties oldValues = new Properties();
        newValues.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String oldValue = globalPreferences.get((String)key, null);
            if (null != oldValue) {
                oldValues.put(key, oldValue);
            }
            globalPreferences.put((String)key, (String)value);
        }));
        return oldValues;
    }

    public static void configureCatalog(Properties config) {
        Optional<File> catalog = SpotlessPreferences.getCatalogConfig(config);
        Catalog defaultCatalog = SpotlessPreferences.getDefaultCatalog();
        if (catalog.isPresent()) {
            try {
                FileInputStream inputStream = new FileInputStream(catalog.get());
                String orgBase = defaultCatalog.getBase();
                defaultCatalog.setBase(catalog.get().toURI().toString());
                CatalogReader.read(defaultCatalog, inputStream);
                defaultCatalog.setBase(orgBase);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Value of '%s' refers to '%s', which cannot be read.", USER_CATALOG, catalog.get()));
            }
        } else {
            defaultCatalog.clear();
        }
    }

    private static Catalog getDefaultCatalog() {
        ICatalog defaultCatalogI = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        if (defaultCatalogI instanceof Catalog) {
            return (Catalog)defaultCatalogI;
        }
        throw new IllegalArgumentException("Internal error: Catalog implementation '" + defaultCatalogI.getClass().getCanonicalName() + "' unsupported.");
    }

    private static Optional<File> getCatalogConfig(Properties config) {
        String newLocation = config.getProperty(USER_CATALOG);
        if (newLocation != null && !newLocation.isEmpty()) {
            return Optional.of(new File(newLocation));
        }
        return Optional.empty();
    }
}

