/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.format;

import java.util.List;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.css.core.internal.formatter.CSSFormatUtil;
import org.eclipse.wst.css.core.internal.formatter.CSSSourceFormatterFactory;
import org.eclipse.wst.css.core.internal.formatter.CSSSourceGenerator;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.sse.core.internal.format.AbstractStructuredFormatProcessor;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatPreferences;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;

public class FormatProcessorCSS
extends AbstractStructuredFormatProcessor {
    private final int MAX_SMALL_FORMAT_SIZE = 1000;

    @Override
    protected String getFileExtension() {
        return "css";
    }

    @Override
    public void formatModel(IStructuredModel structuredModel, int start, int length) {
        List cssnodes;
        CSSFormatUtil formatUtil = CSSFormatUtil.getInstance();
        if (structuredModel instanceof ICSSModel) {
            IDocumentExtension4 docExt4 = null;
            if (structuredModel.getStructuredDocument() instanceof IDocumentExtension4) {
                docExt4 = (IDocumentExtension4)structuredModel.getStructuredDocument();
            }
            DocumentRewriteSession rewriteSession = null;
            try {
                DocumentRewriteSessionType rewriteType = length > 1000 ? DocumentRewriteSessionType.UNRESTRICTED : DocumentRewriteSessionType.UNRESTRICTED_SMALL;
                rewriteSession = docExt4 == null || docExt4.getActiveRewriteSession() != null ? null : docExt4.startRewriteSession(rewriteType);
                ICSSDocument doc = ((ICSSModel)structuredModel).getDocument();
                IStructuredDocumentRegion startRegion = structuredModel.getStructuredDocument().getRegionAtCharacterOffset(start);
                IStructuredDocumentRegion endRegion = structuredModel.getStructuredDocument().getRegionAtCharacterOffset(start + length);
                if (startRegion != null && endRegion != null) {
                    start = startRegion.getStart();
                    CSSSourceGenerator formatter = CSSSourceFormatterFactory.getInstance().getSourceFormatter((INodeNotifier)((Object)doc));
                    StringBuffer buf = formatter.format(doc, (IRegion)new Region(start, endRegion.getEnd() - start));
                    if (buf != null) {
                        formatUtil.replaceSource(doc.getModel(), start, endRegion.getEnd() - start, buf.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                if (docExt4 != null && rewriteSession != null) {
                    docExt4.stopRewriteSession(rewriteSession);
                }
                throw throwable;
            }
            if (docExt4 != null && rewriteSession != null) {
                docExt4.stopRewriteSession(rewriteSession);
            }
        } else if (structuredModel instanceof IDOMModel && (cssnodes = formatUtil.collectCSSNodes(structuredModel, start, length)) != null && !cssnodes.isEmpty()) {
            ICSSModel model = null;
            IDocumentExtension4 docExt4 = null;
            if (structuredModel.getStructuredDocument() instanceof IDocumentExtension4) {
                docExt4 = (IDocumentExtension4)structuredModel.getStructuredDocument();
            }
            DocumentRewriteSession rewriteSession = null;
            try {
                DocumentRewriteSessionType rewriteType = length > 1000 ? DocumentRewriteSessionType.UNRESTRICTED : DocumentRewriteSessionType.UNRESTRICTED_SMALL;
                rewriteSession = docExt4 == null || docExt4.getActiveRewriteSession() != null ? null : docExt4.startRewriteSession(rewriteType);
                int i = 0;
                while (i < cssnodes.size()) {
                    ICSSNode node = (ICSSNode)cssnodes.get(i);
                    CSSSourceGenerator formatter = CSSSourceFormatterFactory.getInstance().getSourceFormatter((INodeNotifier)((Object)node));
                    StringBuffer buf = formatter.format(node);
                    if (buf != null) {
                        int startOffset = ((IndexedRegion)((Object)node)).getStartOffset();
                        int endOffset = ((IndexedRegion)((Object)node)).getEndOffset();
                        if (model == null) {
                            model = node.getOwnerDocument().getModel();
                        }
                        formatUtil.replaceSource(model, startOffset, endOffset - startOffset, buf.toString());
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                if (docExt4 != null && rewriteSession != null) {
                    docExt4.stopRewriteSession(rewriteSession);
                }
                throw throwable;
            }
            if (docExt4 != null && rewriteSession != null) {
                docExt4.stopRewriteSession(rewriteSession);
            }
        }
    }

    public IStructuredFormatPreferences getFormatPreferences() {
        return null;
    }

    @Override
    protected IStructuredFormatter getFormatter(Node node) {
        return null;
    }

    @Override
    protected void refreshFormatPreferences() {
    }
}

