/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.util;

import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.dtd.core.internal.Attribute;
import org.eclipse.wst.dtd.core.internal.AttributeEnumList;
import org.eclipse.wst.dtd.core.internal.AttributeList;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.core.internal.Entity;
import org.eclipse.wst.dtd.core.internal.Notation;

public class DTDNotationReferenceRemover {
    protected Notation notation;
    protected String notationName;
    protected Object requestor;

    public void notationAboutToBeDeleted(Object requestor, Notation notation) {
        this.requestor = requestor;
        this.notation = notation;
        this.notationName = notation.getName();
        this.visit(notation.getDTDFile());
    }

    public void visit(DTDFile file) {
        List nodes = file.getNodes();
        int i = 0;
        while (i < nodes.size()) {
            DTDNode currentNode = (DTDNode)nodes.get(i);
            if (currentNode instanceof Entity) {
                this.visitEntity((Entity)currentNode);
            } else if (currentNode instanceof AttributeList) {
                this.visitAttributeList((AttributeList)currentNode);
            }
            ++i;
        }
    }

    public void visitAttribute(Attribute attr) {
        if (attr.getType().equals(Attribute.ENUMERATED_NOTATION)) {
            AttributeEnumList enumList = attr.getEnumList();
            List notationNames = enumList.getItems();
            Iterator iter = notationNames.iterator();
            boolean updateRequired = false;
            while (iter.hasNext()) {
                String notation = (String)iter.next();
                if (!notation.equals(this.notationName)) continue;
                updateRequired = true;
                iter.remove();
            }
            if (updateRequired) {
                String[] newItems = new String[notationNames.size()];
                notationNames.toArray(newItems);
                enumList.setItems(this.requestor, newItems);
            }
        }
    }

    public void visitAttributeList(AttributeList attList) {
        Attribute attr = (Attribute)attList.getFirstChild();
        while (attr != null) {
            this.visitAttribute(attr);
            attr = (Attribute)attr.getNextSibling();
        }
    }

    public void visitEntity(Entity entity) {
        if (entity.getNotationName().equals(this.notationName)) {
            entity.setNotationName(this.requestor, "");
        }
    }
}

