/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WithStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.Corext;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RefactoringDescriptorChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RefactoringAnalyzeUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.NoCommentSourceRangeComputer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;

public class ExtractTempRefactoring
extends ScriptableRefactoring {
    private static final String ATTRIBUTE_REPLACE = "replace";
    private static final String ATTRIBUTE_FINAL = "final";
    private JavaScriptUnit fCompilationUnitNode;
    private CompilationUnitRewrite fCURewrite;
    private IJavaScriptUnit fCu;
    private boolean fDeclareFinal;
    private String[] fExcludedVariableNames;
    private boolean fReplaceAllOccurrences;
    private IExpressionFragment fSelectedExpression;
    private int fSelectionLength;
    private int fSelectionStart;
    private String fTempName;
    private String[] fGuessedTempNames;
    private TextChange fChange;
    private LinkedProposalModel fLinkedProposalModel;
    private static final String KEY_NAME = "name";

    private static boolean allArraysEqual(Object[][] arrays, int position) {
        Object element = arrays[0][position];
        int i = 0;
        while (i < arrays.length) {
            Object[] array = arrays[i];
            if (!element.equals(array[position])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean canReplace(IASTFragment fragment) {
        VariableDeclarationFragment vdf;
        ASTNode node = fragment.getAssociatedNode();
        ASTNode parent = node.getParent();
        if (parent instanceof VariableDeclarationFragment && node.equals((vdf = (VariableDeclarationFragment)parent).getName())) {
            return false;
        }
        if (ExtractTempRefactoring.isMethodParameter(node)) {
            return false;
        }
        if (ExtractTempRefactoring.isThrowableInCatchBlock(node)) {
            return false;
        }
        if (parent instanceof ExpressionStatement) {
            return false;
        }
        if (ExtractTempRefactoring.isLeftValue(node)) {
            return false;
        }
        if (ExtractTempRefactoring.isReferringToLocalVariableFromFor((Expression)node)) {
            return false;
        }
        if (ExtractTempRefactoring.isUsedInForInitializerOrUpdater((Expression)node)) {
            return false;
        }
        return !(parent instanceof SwitchCase);
    }

    private static Object[] getArrayPrefix(Object[] array, int prefixLength) {
        Assert.isTrue((prefixLength <= array.length ? 1 : 0) != 0);
        Assert.isTrue((prefixLength >= 0 ? 1 : 0) != 0);
        Object[] prefix = new Object[prefixLength];
        int i = 0;
        while (i < prefix.length) {
            prefix[i] = array[i];
            ++i;
        }
        return prefix;
    }

    private static List getForInitializedVariables(VariableDeclarationExpression variableDeclarations) {
        ArrayList<IVariableBinding> forInitializerVariables = new ArrayList<IVariableBinding>(1);
        for (VariableDeclarationFragment fragment : variableDeclarations.fragments()) {
            IVariableBinding binding = fragment.resolveBinding();
            if (binding == null) continue;
            forInitializerVariables.add(binding);
        }
        return forInitializerVariables;
    }

    private static Object[] getLongestArrayPrefix(Object[][] arrays) {
        int length = -1;
        if (arrays.length == 0) {
            return new Object[0];
        }
        int minArrayLength = arrays[0].length;
        int i = 1;
        while (i < arrays.length) {
            minArrayLength = Math.min(minArrayLength, arrays[i].length);
            ++i;
        }
        i = 0;
        while (i < minArrayLength) {
            if (!ExtractTempRefactoring.allArraysEqual(arrays, i)) break;
            ++length;
            ++i;
        }
        if (length == -1) {
            return new Object[0];
        }
        return ExtractTempRefactoring.getArrayPrefix(arrays[0], length + 1);
    }

    private static ASTNode[] getParents(ASTNode node) {
        ASTNode current = node;
        ArrayList<ASTNode> parents = new ArrayList<ASTNode>();
        do {
            parents.add(current.getParent());
        } while ((current = current.getParent()).getParent() != null);
        Collections.reverse(parents);
        return parents.toArray(new ASTNode[parents.size()]);
    }

    private static boolean isLeftValue(ASTNode node) {
        Assignment assignment;
        ASTNode parent = node.getParent();
        if (parent instanceof Assignment && (assignment = (Assignment)parent).getLeftHandSide() == node) {
            return true;
        }
        if (parent instanceof PostfixExpression) {
            return true;
        }
        if (parent instanceof PrefixExpression) {
            PrefixExpression.Operator op = ((PrefixExpression)parent).getOperator();
            if (op.equals(PrefixExpression.Operator.DECREMENT)) {
                return true;
            }
            return op.equals(PrefixExpression.Operator.INCREMENT);
        }
        return false;
    }

    private static boolean isMethodParameter(ASTNode node) {
        return node instanceof SimpleName && node.getParent() instanceof SingleVariableDeclaration && node.getParent().getParent() instanceof FunctionDeclaration;
    }

    private static boolean isReferringToLocalVariableFromFor(Expression expression) {
        ASTNode current = expression;
        ASTNode parent = current.getParent();
        while (parent != null && !(parent instanceof BodyDeclaration)) {
            ForInStatement forInStmt;
            ForStatementChecker checker;
            if (parent instanceof ForStatement) {
                List initializers;
                ForStatement forStmt = (ForStatement)parent;
                if ((forStmt.initializers().contains(current) || forStmt.updaters().contains(current) || forStmt.getExpression() == current) && (initializers = forStmt.initializers()).size() == 1 && initializers.get(0) instanceof VariableDeclarationExpression) {
                    List forInitializerVariables = ExtractTempRefactoring.getForInitializedVariables((VariableDeclarationExpression)initializers.get(0));
                    checker = new ForStatementChecker(forInitializerVariables);
                    expression.accept(checker);
                    if (checker.isReferringToForVariable()) {
                        return true;
                    }
                }
            } else if (parent instanceof ForInStatement && ((forInStmt = (ForInStatement)parent).getIterationVariable().equals(current) || forInStmt.getCollection() == current) && forInStmt.getIterationVariable() instanceof VariableDeclarationExpression) {
                ArrayList<IVariableBinding> forInitializerVariables = new ArrayList<IVariableBinding>(1);
                VariableDeclarationExpression vde = (VariableDeclarationExpression)forInStmt.getIterationVariable();
                int i = 0;
                while (i < vde.fragments().size()) {
                    VariableDeclarationFragment fragment = (VariableDeclarationFragment)vde.fragments().get(i);
                    forInitializerVariables.add(fragment.resolveBinding());
                    ++i;
                }
                checker = new ForStatementChecker(forInitializerVariables);
                expression.accept(checker);
                if (checker.isReferringToForVariable()) {
                    return true;
                }
            }
            current = parent;
            parent = current.getParent();
        }
        return false;
    }

    private static boolean isThrowableInCatchBlock(ASTNode node) {
        return node instanceof SimpleName && node.getParent() instanceof SingleVariableDeclaration && node.getParent().getParent() instanceof CatchClause;
    }

    private static boolean isUsedInForInitializerOrUpdater(Expression expression) {
        ASTNode parent = expression.getParent();
        if (parent instanceof ForStatement) {
            ForStatement forStmt = (ForStatement)parent;
            return forStmt.initializers().contains(expression) || forStmt.updaters().contains(expression);
        }
        return false;
    }

    private static IASTFragment[] retainOnlyReplacableMatches(IASTFragment[] allMatches) {
        ArrayList<IASTFragment> result = new ArrayList<IASTFragment>(allMatches.length);
        int i = 0;
        while (i < allMatches.length) {
            if (ExtractTempRefactoring.canReplace(allMatches[i])) {
                result.add(allMatches[i]);
            }
            ++i;
        }
        return result.toArray(new IASTFragment[result.size()]);
    }

    public ExtractTempRefactoring(IJavaScriptUnit unit, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = unit;
        this.fCompilationUnitNode = null;
        this.fReplaceAllOccurrences = true;
        this.fDeclareFinal = false;
        this.fTempName = "";
        this.fLinkedProposalModel = null;
    }

    public ExtractTempRefactoring(JavaScriptUnit astRoot, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((boolean)(astRoot.getTypeRoot() instanceof IJavaScriptUnit));
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = (IJavaScriptUnit)astRoot.getTypeRoot();
        this.fCompilationUnitNode = astRoot;
        this.fReplaceAllOccurrences = true;
        this.fDeclareFinal = false;
        this.fTempName = "";
        this.fLinkedProposalModel = null;
    }

    public void setLinkedProposalModel(LinkedProposalModel linkedProposalModel) {
        this.fLinkedProposalModel = linkedProposalModel;
    }

    private void addReplaceExpressionWithTemp() throws JavaScriptModelException {
        IASTFragment[] fragmentsToReplace = ExtractTempRefactoring.retainOnlyReplacableMatches(this.getMatchingFragments());
        ASTRewrite rewrite = this.fCURewrite.getASTRewrite();
        HashSet<IASTFragment> seen = new HashSet<IASTFragment>();
        int i = 0;
        while (i < fragmentsToReplace.length) {
            IASTFragment fragment = fragmentsToReplace[i];
            if (seen.add(fragment)) {
                SimpleName tempName = this.fCURewrite.getAST().newSimpleName(this.fTempName);
                TextEditGroup description = this.fCURewrite.createGroupDescription(RefactoringCoreMessages.ExtractTempRefactoring_replace);
                fragment.replace(rewrite, tempName, description);
                if (this.fLinkedProposalModel != null) {
                    this.fLinkedProposalModel.getPositionGroup(KEY_NAME, true).addPosition(rewrite.track(tempName), false);
                }
            }
            ++i;
        }
    }

    private RefactoringStatus checkExpression() throws JavaScriptModelException {
        Expression selectedExpression = this.getSelectedExpression().getAssociatedExpression();
        if (selectedExpression != null) {
            ASTNode parent = selectedExpression.getParent();
            if (selectedExpression instanceof NullLiteral) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_null_literals);
            }
            if (selectedExpression instanceof ArrayInitializer) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_array_initializer);
            }
            if (selectedExpression instanceof Assignment) {
                if (parent instanceof Expression && !(parent instanceof ParenthesizedExpression)) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_assignment);
                }
                return null;
            }
            if (selectedExpression instanceof SimpleName) {
                if (((SimpleName)selectedExpression).isDeclaration()) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_names_in_declarations);
                }
                if (parent instanceof QualifiedName && selectedExpression.getLocationInParent() == QualifiedName.NAME_PROPERTY || parent instanceof FieldAccess && selectedExpression.getLocationInParent() == FieldAccess.NAME_PROPERTY) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_select_expression);
                }
            }
        }
        return null;
    }

    private RefactoringStatus checkExpressionFragmentIsRValue() throws JavaScriptModelException {
        switch (Checks.checkExpressionIsRValue(this.getSelectedExpression().getAssociatedExpression())) {
            case 1: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.ExtractTempRefactoring_select_expression, null, (String)Corext.getPluginId(), (int)64, null);
            }
            case 2: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.ExtractTempRefactoring_no_void, null, (String)Corext.getPluginId(), (int)65, null);
            }
            case 0: {
                return new RefactoringStatus();
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public TextChange createTextChange(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.ExtractTempRefactoring_checking_preconditions, 3);
            this.fCURewrite = new CompilationUnitRewrite(this.fCu, this.fCompilationUnitNode);
            this.fCURewrite.getASTRewrite().setTargetSourceRangeComputer(new NoCommentSourceRangeComputer());
            this.doCreateChange((IProgressMonitor)new SubProgressMonitor(pm, 2));
            CompilationUnitChange compilationUnitChange = this.fCURewrite.createChange(RefactoringCoreMessages.ExtractTempRefactoring_change_name, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            return compilationUnitChange;
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        this.fChange = this.createTextChange(pm);
        RefactoringStatus result = new RefactoringStatus();
        if (Arrays.asList(this.getExcludedVariableNames()).contains(this.fTempName)) {
            result.addWarning(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_another_variable, this.fTempName));
        }
        result.merge(this.checkMatchingFragments());
        this.fChange.setKeepPreviewEdits(true);
        this.checkNewSource(result);
        return result;
    }

    private final JDTRefactoringDescriptor createRefactoringDescriptor() {
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IJavaScriptProject javaProject = this.fCu.getJavaScriptProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        String description = Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_descriptor_description_short, this.fTempName);
        String expression = ASTNodes.asString(this.fSelectedExpression.getAssociatedExpression());
        String header = Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_descriptor_description, new String[]{this.fTempName, expression});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_name_pattern, this.fTempName));
        BodyDeclaration decl = (BodyDeclaration)ASTNodes.getParent((ASTNode)this.fSelectedExpression.getAssociatedExpression(), BodyDeclaration.class);
        if (decl instanceof FunctionDeclaration) {
            IFunctionBinding method = ((FunctionDeclaration)decl).resolveBinding();
            String label = method != null ? BindingLabelProvider.getBindingLabel(method, 2235681801344L) : "{...}";
            comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_destination_pattern, label));
        }
        comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_expression_pattern, expression));
        if (this.fReplaceAllOccurrences) {
            comment.addSetting(RefactoringCoreMessages.ExtractTempRefactoring_replace_occurrences);
        }
        if (this.fDeclareFinal) {
            comment.addSetting(RefactoringCoreMessages.ExtractTempRefactoring_declare_final);
        }
        JDTRefactoringDescriptor descriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.extract.temp", project, description, comment.asString(), arguments, 0);
        arguments.put("input", descriptor.elementToHandle(this.fCu));
        arguments.put(KEY_NAME, this.fTempName);
        arguments.put("selection", String.valueOf(Integer.valueOf(this.fSelectionStart).toString()) + " " + Integer.valueOf(this.fSelectionLength).toString());
        arguments.put(ATTRIBUTE_REPLACE, Boolean.valueOf(this.fReplaceAllOccurrences).toString());
        arguments.put(ATTRIBUTE_FINAL, Boolean.valueOf(this.fDeclareFinal).toString());
        return descriptor;
    }

    private void doCreateChange(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.ExtractTempRefactoring_checking_preconditions, 1);
            try {
                this.createTempDeclaration();
            }
            catch (CoreException exception) {
                JavaScriptPlugin.log(exception);
            }
            this.addReplaceExpressionWithTemp();
        }
        finally {
            pm.done();
        }
    }

    private void checkNewSource(RefactoringStatus result) throws CoreException {
        String newCuSource = this.fChange.getPreviewContent((IProgressMonitor)new NullProgressMonitor());
        JavaScriptUnit newCUNode = new RefactoringASTParser(3).parse(newCuSource, this.fCu, true, true, null);
        IProblem[] newProblems = RefactoringAnalyzeUtil.getIntroducedCompileProblems(newCUNode, this.fCompilationUnitNode);
        int i = 0;
        while (i < newProblems.length) {
            IProblem problem = newProblems[i];
            if (problem.isError()) {
                result.addEntry(new RefactoringStatusEntry(problem.isError() ? 3 : 2, problem.getMessage(), (RefactoringStatusContext)new JavaStringStatusContext(newCuSource, new SourceRange(problem))));
            }
            ++i;
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 6);
            RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new IJavaScriptUnit[]{this.fCu}), this.getValidationContext());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (this.fCompilationUnitNode == null) {
                this.fCompilationUnitNode = RefactoringASTParser.parseWithASTProvider(this.fCu, true, (IProgressMonitor)new SubProgressMonitor(pm, 3));
            } else {
                pm.worked(3);
            }
            result.merge(this.checkSelection((IProgressMonitor)new SubProgressMonitor(pm, 3)));
            if (!result.hasFatalError() && this.isLiteralNodeSelected()) {
                this.fReplaceAllOccurrences = false;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus checkMatchingFragments() throws JavaScriptModelException {
        RefactoringStatus result = new RefactoringStatus();
        IASTFragment[] matchingFragments = this.getMatchingFragments();
        int i = 0;
        while (i < matchingFragments.length) {
            ASTNode node = matchingFragments[i].getAssociatedNode();
            if (ExtractTempRefactoring.isLeftValue(node) && !ExtractTempRefactoring.isReferringToLocalVariableFromFor((Expression)node)) {
                String msg = RefactoringCoreMessages.ExtractTempRefactoring_assigned_to;
                result.addWarning(msg, JavaStatusContext.create((ITypeRoot)this.fCu, node));
            }
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkSelection(IProgressMonitor pm) throws JavaScriptModelException {
        try {
            pm.beginTask("", 8);
            IExpressionFragment selectedExpression = this.getSelectedExpression();
            if (selectedExpression == null) {
                String message = RefactoringCoreMessages.ExtractTempRefactoring_select_expression;
                RefactoringStatus refactoringStatus = CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, this.fCompilationUnitNode, message);
                return refactoringStatus;
            }
            pm.worked(1);
            if (this.isUsedInExplicitConstructorCall()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_explicit_constructor);
                return refactoringStatus;
            }
            pm.worked(1);
            if (this.getEnclosingBodyNode() == null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_expr_in_method_or_initializer);
                return refactoringStatus;
            }
            pm.worked(1);
            ASTNode associatedNode = selectedExpression.getAssociatedNode();
            if (associatedNode instanceof Name && associatedNode.getParent() instanceof ClassInstanceCreation && associatedNode.getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_name_in_new);
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkExpression());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            result.merge(this.checkExpressionFragmentIsRValue());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            if (ExtractTempRefactoring.isUsedInForInitializerOrUpdater(this.getSelectedExpression().getAssociatedExpression())) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_for_initializer_updater);
                return refactoringStatus;
            }
            pm.worked(1);
            if (ExtractTempRefactoring.isReferringToLocalVariableFromFor(this.getSelectedExpression().getAssociatedExpression())) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_refers_to_for_variable);
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus checkTempName(String newName) {
        RefactoringStatus status = Checks.checkTempName(newName);
        if (Arrays.asList(this.getExcludedVariableNames()).contains(newName)) {
            status.addWarning(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_another_variable, newName));
        }
        return status;
    }

    private void createAndInsertTempDeclaration() throws CoreException {
        Expression initializer = this.getSelectedExpression().createCopyTarget(this.fCURewrite.getASTRewrite());
        VariableDeclarationStatement vds = this.createTempDeclaration(initializer);
        if (!this.fReplaceAllOccurrences || ExtractTempRefactoring.retainOnlyReplacableMatches(this.getMatchingFragments()).length <= 1) {
            this.insertAt(this.getSelectedExpression().getAssociatedNode(), vds);
            return;
        }
        ASTNode[] firstReplaceNodeParents = ExtractTempRefactoring.getParents(this.getFirstReplacedExpression().getAssociatedNode());
        ASTNode[] commonPath = this.findDeepestCommonSuperNodePathForReplacedNodes();
        Assert.isTrue((commonPath.length <= firstReplaceNodeParents.length ? 1 : 0) != 0);
        ASTNode deepestCommonParent = firstReplaceNodeParents[commonPath.length - 1];
        if (deepestCommonParent instanceof Block) {
            this.insertAt(firstReplaceNodeParents[commonPath.length], vds);
        } else {
            this.insertAt(deepestCommonParent, vds);
        }
    }

    private VariableDeclarationStatement createTempDeclaration(Expression initializer) throws CoreException {
        AST ast = this.fCURewrite.getAST();
        VariableDeclarationFragment vdf = ast.newVariableDeclarationFragment();
        vdf.setName(ast.newSimpleName(this.fTempName));
        vdf.setInitializer(initializer);
        VariableDeclarationStatement vds = ast.newVariableDeclarationStatement(vdf);
        if (this.fLinkedProposalModel != null) {
            ASTRewrite rewrite = this.fCURewrite.getASTRewrite();
            LinkedProposalPositionGroup nameGroup = this.fLinkedProposalModel.getPositionGroup(KEY_NAME, true);
            nameGroup.addPosition(rewrite.track(vdf.getName()), true);
            String[] nameSuggestions = this.guessTempNames();
            if (nameSuggestions.length > 0 && !nameSuggestions[0].equals(this.fTempName)) {
                nameGroup.addProposal(this.fTempName, null, nameSuggestions.length + 1);
            }
            int i = 0;
            while (i < nameSuggestions.length) {
                nameGroup.addProposal(nameSuggestions[i], null, nameSuggestions.length - i);
                ++i;
            }
        }
        return vds;
    }

    private void insertAt(ASTNode target, Statement declaration) throws JavaScriptModelException {
        ASTRewrite rewrite = this.fCURewrite.getASTRewrite();
        TextEditGroup groupDescription = this.fCURewrite.createGroupDescription(RefactoringCoreMessages.ExtractTempRefactoring_declare_local_variable);
        ASTNode parent = target.getParent();
        while (!(parent instanceof Block)) {
            StructuralPropertyDescriptor locationInParent = target.getLocationInParent();
            if (locationInParent == IfStatement.THEN_STATEMENT_PROPERTY || locationInParent == IfStatement.ELSE_STATEMENT_PROPERTY || locationInParent == ForStatement.BODY_PROPERTY || locationInParent == ForInStatement.BODY_PROPERTY || locationInParent == EnhancedForStatement.BODY_PROPERTY || locationInParent == DoStatement.BODY_PROPERTY || locationInParent == WhileStatement.BODY_PROPERTY || locationInParent == WithStatement.BODY_PROPERTY) {
                Block replacement = rewrite.getAST().newBlock();
                ListRewrite replacementRewrite = rewrite.getListRewrite(replacement, Block.STATEMENTS_PROPERTY);
                replacementRewrite.insertFirst(declaration, null);
                replacementRewrite.insertLast(rewrite.createMoveTarget(target), null);
                rewrite.replace(target, replacement, groupDescription);
                return;
            }
            target = parent;
            parent = parent.getParent();
        }
        ListRewrite listRewrite = rewrite.getListRewrite(parent, Block.STATEMENTS_PROPERTY);
        listRewrite.insertBefore(declaration, target, groupDescription);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.ExtractTempRefactoring_checking_preconditions, 1);
            JDTRefactoringDescriptor descriptor = this.createRefactoringDescriptor();
            RefactoringDescriptorChange refactoringDescriptorChange = new RefactoringDescriptorChange((RefactoringDescriptor)descriptor, RefactoringCoreMessages.ExtractTempRefactoring_extract_temp, new Change[]{this.fChange});
            return refactoringDescriptorChange;
        }
        finally {
            pm.done();
        }
    }

    private void createTempDeclaration() throws CoreException {
        if (this.shouldReplaceSelectedExpressionWithTempDeclaration()) {
            this.replaceSelectedExpressionWithTempDeclaration();
        } else {
            this.createAndInsertTempDeclaration();
        }
    }

    public boolean declareFinal() {
        return this.fDeclareFinal;
    }

    private ASTNode[] findDeepestCommonSuperNodePathForReplacedNodes() throws JavaScriptModelException {
        ASTNode[] matchNodes = this.getMatchNodes();
        Object[][] matchingNodesParents = new ASTNode[matchNodes.length][];
        int i = 0;
        while (i < matchNodes.length) {
            matchingNodesParents[i] = ExtractTempRefactoring.getParents(matchNodes[i]);
            ++i;
        }
        List<Object> l = Arrays.asList(ExtractTempRefactoring.getLongestArrayPrefix(matchingNodesParents));
        return l.toArray(new ASTNode[l.size()]);
    }

    private Block getEnclosingBodyNode() throws JavaScriptModelException {
        ASTNode node = this.getSelectedExpression().getAssociatedNode();
        do {
            switch (node.getNodeType()) {
                case 31: {
                    return ((FunctionDeclaration)node).getBody();
                }
                case 28: {
                    return ((Initializer)node).getBody();
                }
            }
        } while ((node = node.getParent()) != null);
        return null;
    }

    private String[] getExcludedVariableNames() {
        if (this.fExcludedVariableNames == null) {
            try {
                IBinding[] bindings = new ScopeAnalyzer(this.fCompilationUnitNode).getDeclarationsInScope(this.getSelectedExpression().getStartPosition(), 2);
                this.fExcludedVariableNames = new String[bindings.length];
                int i = 0;
                while (i < bindings.length) {
                    this.fExcludedVariableNames[i] = bindings[i].getName();
                    ++i;
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {
                this.fExcludedVariableNames = new String[0];
            }
        }
        return this.fExcludedVariableNames;
    }

    private IExpressionFragment getFirstReplacedExpression() throws JavaScriptModelException {
        if (!this.fReplaceAllOccurrences) {
            return this.getSelectedExpression();
        }
        IASTFragment[] nodesToReplace = ExtractTempRefactoring.retainOnlyReplacableMatches(this.getMatchingFragments());
        if (nodesToReplace.length == 0) {
            return this.getSelectedExpression();
        }
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((IASTFragment)o1).getStartPosition() - ((IASTFragment)o2).getStartPosition();
            }
        };
        Arrays.sort(nodesToReplace, comparator);
        return (IExpressionFragment)nodesToReplace[0];
    }

    private IASTFragment[] getMatchingFragments() throws JavaScriptModelException {
        if (this.fReplaceAllOccurrences) {
            IASTFragment[] allMatches = ASTFragmentFactory.createFragmentForFullSubtree(this.getEnclosingBodyNode()).getSubFragmentsMatching(this.getSelectedExpression());
            return allMatches;
        }
        return new IASTFragment[]{this.getSelectedExpression()};
    }

    private ASTNode[] getMatchNodes() throws JavaScriptModelException {
        IASTFragment[] matches = ExtractTempRefactoring.retainOnlyReplacableMatches(this.getMatchingFragments());
        ASTNode[] result = new ASTNode[matches.length];
        int i = 0;
        while (i < matches.length) {
            result[i] = matches[i].getAssociatedNode();
            ++i;
        }
        return result;
    }

    public String getName() {
        return RefactoringCoreMessages.ExtractTempRefactoring_name;
    }

    private IExpressionFragment getSelectedExpression() throws JavaScriptModelException {
        if (this.fSelectedExpression != null) {
            return this.fSelectedExpression;
        }
        IASTFragment selectedFragment = ASTFragmentFactory.createFragmentForSourceRange(new SourceRange(this.fSelectionStart, this.fSelectionLength), this.fCompilationUnitNode, this.fCu);
        if (selectedFragment instanceof IExpressionFragment && !Checks.isInsideJavadoc(selectedFragment.getAssociatedNode())) {
            this.fSelectedExpression = (IExpressionFragment)selectedFragment;
        } else if (selectedFragment != null) {
            if (selectedFragment.getAssociatedNode() instanceof ExpressionStatement) {
                ExpressionStatement exprStatement = (ExpressionStatement)selectedFragment.getAssociatedNode();
                Expression expression = exprStatement.getExpression();
                this.fSelectedExpression = (IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree(expression);
            } else if (selectedFragment.getAssociatedNode() instanceof Assignment) {
                Assignment assignment = (Assignment)selectedFragment.getAssociatedNode();
                this.fSelectedExpression = (IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree(assignment);
            }
        }
        return this.fSelectedExpression;
    }

    public String guessTempName() {
        String[] proposals = this.guessTempNames();
        if (proposals.length == 0) {
            return this.fTempName;
        }
        return proposals[0];
    }

    public String[] guessTempNames() {
        if (this.fGuessedTempNames == null) {
            try {
                Expression expression = this.getSelectedExpression().getAssociatedExpression();
                if (expression != null) {
                    ITypeBinding binding = expression.resolveTypeBinding();
                    this.fGuessedTempNames = StubUtility.getVariableNameSuggestions(5, this.fCu.getJavaScriptProject(), binding, expression, Arrays.asList(this.getExcludedVariableNames()));
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {}
            if (this.fGuessedTempNames == null) {
                this.fGuessedTempNames = new String[0];
            }
        }
        return this.fGuessedTempNames;
    }

    private boolean isLiteralNodeSelected() throws JavaScriptModelException {
        IExpressionFragment fragment = this.getSelectedExpression();
        if (fragment == null) {
            return false;
        }
        Expression expression = fragment.getAssociatedExpression();
        if (expression == null) {
            return false;
        }
        switch (expression.getNodeType()) {
            case 9: 
            case 13: 
            case 33: 
            case 34: 
            case 87: 
            case 88: {
                return true;
            }
        }
        return false;
    }

    private boolean isUsedInExplicitConstructorCall() throws JavaScriptModelException {
        Expression selectedExpression = this.getSelectedExpression().getAssociatedExpression();
        if (ASTNodes.getParent((ASTNode)selectedExpression, ConstructorInvocation.class) != null) {
            return true;
        }
        return ASTNodes.getParent((ASTNode)selectedExpression, SuperConstructorInvocation.class) != null;
    }

    public boolean replaceAllOccurrences() {
        return this.fReplaceAllOccurrences;
    }

    private void replaceSelectedExpressionWithTempDeclaration() throws CoreException {
        ASTRewrite rewrite = this.fCURewrite.getASTRewrite();
        Expression selectedExpression = this.getSelectedExpression().getAssociatedExpression();
        Expression initializer = (Expression)rewrite.createMoveTarget(selectedExpression);
        Statement replacement = this.createTempDeclaration(initializer);
        ExpressionStatement parent = (ExpressionStatement)selectedExpression.getParent();
        if (ASTNodes.isControlStatementBody(parent.getLocationInParent())) {
            Block block = rewrite.getAST().newBlock();
            block.statements().add(replacement);
            replacement = block;
        }
        rewrite.replace(parent, replacement, this.fCURewrite.createGroupDescription(RefactoringCoreMessages.ExtractTempRefactoring_declare_local_variable));
    }

    public void setDeclareFinal(boolean declareFinal) {
        this.fDeclareFinal = declareFinal;
    }

    public void setReplaceAllOccurrences(boolean replaceAllOccurrences) {
        this.fReplaceAllOccurrences = replaceAllOccurrences;
    }

    public void setTempName(String newName) {
        this.fTempName = newName;
    }

    private boolean shouldReplaceSelectedExpressionWithTempDeclaration() throws JavaScriptModelException {
        IExpressionFragment selectedFragment = this.getSelectedExpression();
        return selectedFragment.getAssociatedNode().getParent() instanceof ExpressionStatement && selectedFragment.matches(ASTFragmentFactory.createFragmentForFullSubtree(selectedFragment.getAssociatedNode()));
    }

    @Override
    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String declareFinal;
        if (arguments instanceof JavaRefactoringArguments) {
            IJavaScriptElement element;
            int length;
            int offset;
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String selection = extended.getAttribute("selection");
            if (selection != null) {
                offset = -1;
                length = -1;
                StringTokenizer tokenizer = new StringTokenizer(selection);
                if (tokenizer.hasMoreTokens()) {
                    offset = Integer.valueOf(tokenizer.nextToken());
                }
                if (tokenizer.hasMoreTokens()) {
                    length = Integer.valueOf(tokenizer.nextToken());
                }
                if (offset < 0 || length < 0) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
            }
            this.fSelectionStart = offset;
            this.fSelectionLength = length;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists() || element.getElementType() != 5) {
                    return this.createInputFatalStatus(element, "org.eclipse.wst.jsdt.ui.extract.temp");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fCu = (IJavaScriptUnit)element;
            String name = extended.getAttribute(KEY_NAME);
            if (name == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, KEY_NAME));
            }
            this.fTempName = name;
            String replace = extended.getAttribute(ATTRIBUTE_REPLACE);
            if (replace == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_REPLACE));
            }
            this.fReplaceAllOccurrences = Boolean.valueOf(replace);
            declareFinal = extended.getAttribute(ATTRIBUTE_FINAL);
            if (declareFinal == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_FINAL));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fDeclareFinal = Boolean.valueOf(declareFinal);
        return new RefactoringStatus();
    }

    private static final class ForStatementChecker
    extends ASTVisitor {
        private final Collection fForInitializerVariables;
        private boolean fReferringToForVariable = false;

        public ForStatementChecker(Collection forInitializerVariables) {
            Assert.isNotNull((Object)forInitializerVariables);
            this.fForInitializerVariables = forInitializerVariables;
        }

        public boolean isReferringToForVariable() {
            return this.fReferringToForVariable;
        }

        @Override
        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (binding != null && this.fForInitializerVariables.contains(binding)) {
                this.fReferringToForVariable = true;
            }
            return false;
        }
    }
}

