/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.internal.ui.search.WorkingSetComparator;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;

public class JavaSearchScopeFactory {
    public static final int JRE = 4;
    public static final int LIBS = 2;
    public static final int PROJECTS = 8;
    public static final int SOURCES = 1;
    public static final int ALL = 15;
    public static final int NO_PROJ = 7;
    public static final int NO_JRE = 11;
    public static final int NO_JRE_NO_PROJ = 11;
    private static JavaSearchScopeFactory fgInstance;
    private final IJavaScriptSearchScope EMPTY_SCOPE = SearchEngine.createJavaSearchScope(new IJavaScriptElement[0]);

    private JavaSearchScopeFactory() {
    }

    public static JavaSearchScopeFactory getInstance() {
        if (fgInstance == null) {
            fgInstance = new JavaSearchScopeFactory();
        }
        return fgInstance;
    }

    public IWorkingSet[] queryWorkingSets() throws JavaScriptModelException, InterruptedException {
        Shell shell = JavaScriptPlugin.getActiveWorkbenchShell();
        if (shell == null) {
            return null;
        }
        IWorkingSetSelectionDialog dialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(shell, true);
        if (dialog.open() != 0) {
            throw new InterruptedException();
        }
        IWorkingSet[] workingSets = dialog.getSelection();
        if (workingSets.length > 0) {
            return workingSets;
        }
        return null;
    }

    public IJavaScriptSearchScope createJavaSearchScope(IWorkingSet[] workingSets, boolean includeJRE) {
        return this.createJavaSearchScope(workingSets, includeJRE ? 15 : 11);
    }

    public IJavaScriptSearchScope createJavaSearchScope(IWorkingSet[] workingSets, int includeMask) {
        if (workingSets == null || workingSets.length < 1) {
            return this.EMPTY_SCOPE;
        }
        HashSet javaElements = new HashSet(workingSets.length * 10);
        int i = 0;
        while (i < workingSets.length) {
            IWorkingSet workingSet = workingSets[i];
            if (workingSet.isEmpty() && workingSet.isAggregateWorkingSet()) {
                return this.createWorkspaceScope(includeMask);
            }
            this.addJavaElements(javaElements, workingSet);
            ++i;
        }
        return this.createJavaSearchScope(javaElements, includeMask);
    }

    public IJavaScriptSearchScope createJavaSearchScope(IWorkingSet workingSet, boolean includeJRE) {
        return this.createJavaSearchScope(workingSet, includeJRE ? 7 : 11);
    }

    public IJavaScriptSearchScope createJavaSearchScope(IWorkingSet workingSet, int includeMask) {
        HashSet javaElements = new HashSet(10);
        if (workingSet.isEmpty() && workingSet.isAggregateWorkingSet()) {
            return this.createWorkspaceScope(includeMask);
        }
        this.addJavaElements(javaElements, workingSet);
        return this.createJavaSearchScope(javaElements, includeMask);
    }

    public IJavaScriptSearchScope createJavaSearchScope(IResource[] resources, boolean includeJRE) {
        return this.createJavaSearchScope(resources, includeJRE ? 7 : 11);
    }

    public IJavaScriptSearchScope createJavaSearchScope(IResource[] resources, int includeMask) {
        if (resources == null) {
            return this.EMPTY_SCOPE;
        }
        HashSet javaElements = new HashSet(resources.length);
        this.addJavaElements(javaElements, resources);
        return this.createJavaSearchScope(javaElements, includeMask);
    }

    public IJavaScriptSearchScope createJavaSearchScope(ISelection selection, boolean includeJRE) {
        return this.createJavaSearchScope(selection, includeJRE ? 7 : 11);
    }

    public IJavaScriptSearchScope createJavaSearchScope(ISelection selection, int includeMask) {
        return this.createJavaSearchScope(this.getJavaElements(selection), includeMask);
    }

    public IJavaScriptSearchScope createJavaProjectSearchScope(String[] projectNames, boolean includeJRE) {
        return this.createJavaProjectSearchScope(projectNames, includeJRE ? 7 : 11);
    }

    public IJavaScriptSearchScope createJavaProjectSearchScope(String[] projectNames, int includeMask) {
        ArrayList<IJavaScriptProject> res = new ArrayList<IJavaScriptProject>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < projectNames.length) {
            IJavaScriptProject project = JavaScriptCore.create(root.getProject(projectNames[i]));
            if (project.exists()) {
                res.add(project);
            }
            ++i;
        }
        return this.createJavaSearchScope(res, includeMask);
    }

    public IJavaScriptSearchScope createJavaProjectSearchScope(IJavaScriptProject project, boolean includeJRE) {
        return this.createJavaProjectSearchScope(project, includeJRE ? 7 : 11);
    }

    public IJavaScriptSearchScope createJavaProjectSearchScope(IJavaScriptProject project, int includeMask) {
        return SearchEngine.createJavaSearchScope(new IJavaScriptElement[]{project}, JavaSearchScopeFactory.getSearchFlags(includeMask));
    }

    public IJavaScriptSearchScope createJavaProjectSearchScope(IEditorInput editorInput, boolean includeJRE) {
        return this.createJavaProjectSearchScope(editorInput, includeJRE ? 15 : 11);
    }

    public IJavaScriptSearchScope createJavaProjectSearchScope(IEditorInput editorInput, int includeMask) {
        IJavaScriptProject project;
        IJavaScriptElement elem = JavaScriptUI.getEditorInputJavaElement(editorInput);
        if (elem != null && (project = elem.getJavaScriptProject()) != null) {
            return this.createJavaProjectSearchScope(project, includeMask);
        }
        return this.EMPTY_SCOPE;
    }

    public String getWorkspaceScopeDescription(boolean includeJRE) {
        return includeJRE ? SearchMessages.WorkspaceScope : SearchMessages.WorkspaceScopeNoJRE;
    }

    public String getWorkspaceScopeDescription(int includeMask) {
        return this.getWorkspaceScopeDescription((includeMask & 4) != 0);
    }

    public String getProjectScopeDescription(String[] projectNames, int includeMask) {
        String scopeDescription;
        boolean includeJRE;
        if (projectNames.length == 0) {
            return SearchMessages.JavaSearchScopeFactory_undefined_projects;
        }
        boolean bl = includeJRE = (includeMask & 4) != 0;
        if (projectNames.length == 1) {
            String label = includeJRE ? SearchMessages.EnclosingProjectScope : SearchMessages.EnclosingProjectScopeNoJRE;
            scopeDescription = Messages.format(label, projectNames[0]);
        } else if (projectNames.length == 2) {
            String label = includeJRE ? SearchMessages.EnclosingProjectsScope2 : SearchMessages.EnclosingProjectsScope2NoJRE;
            scopeDescription = Messages.format(label, new String[]{projectNames[0], projectNames[1]});
        } else {
            String label = includeJRE ? SearchMessages.EnclosingProjectsScope : SearchMessages.EnclosingProjectsScopeNoJRE;
            scopeDescription = Messages.format(label, new String[]{projectNames[0], projectNames[1]});
        }
        return scopeDescription;
    }

    public String getProjectScopeDescription(IJavaScriptProject project, boolean includeJRE) {
        if (includeJRE) {
            return Messages.format(SearchMessages.ProjectScope, project.getElementName());
        }
        return Messages.format(SearchMessages.ProjectScopeNoJRE, project.getElementName());
    }

    public String getProjectScopeDescription(IEditorInput editorInput, boolean includeJRE) {
        IJavaScriptProject project;
        IJavaScriptElement elem = JavaScriptUI.getEditorInputJavaElement(editorInput);
        if (elem != null && (project = elem.getJavaScriptProject()) != null) {
            return this.getProjectScopeDescription(project, includeJRE);
        }
        return Messages.format(SearchMessages.ProjectScope, "");
    }

    public String getHierarchyScopeDescription(IType type) {
        return Messages.format(SearchMessages.HierarchyScope, new String[]{type.getElementName()});
    }

    public String getSelectionScopeDescription(IJavaScriptElement[] javaElements, int includeMask) {
        return this.getSelectionScopeDescription(javaElements, (includeMask & 4) != 0);
    }

    public String getSelectionScopeDescription(IJavaScriptElement[] javaElements, boolean includeJRE) {
        String scopeDescription;
        if (javaElements.length == 0) {
            return SearchMessages.JavaSearchScopeFactory_undefined_selection;
        }
        if (javaElements.length == 1) {
            String label = includeJRE ? SearchMessages.SingleSelectionScope : SearchMessages.SingleSelectionScopeNoJRE;
            scopeDescription = Messages.format(label, javaElements[0].getElementName());
        } else if (javaElements.length == 1) {
            String label = includeJRE ? SearchMessages.DoubleSelectionScope : SearchMessages.DoubleSelectionScopeNoJRE;
            scopeDescription = Messages.format(label, new String[]{javaElements[0].getElementName(), javaElements[1].getElementName()});
        } else {
            String label = includeJRE ? SearchMessages.SelectionScope : SearchMessages.SelectionScopeNoJRE;
            scopeDescription = Messages.format(label, new String[]{javaElements[0].getElementName(), javaElements[1].getElementName()});
        }
        return scopeDescription;
    }

    public String getWorkingSetScopeDescription(IWorkingSet[] workingSets, int includeMask) {
        return this.getWorkingSetScopeDescription(workingSets, (includeMask & 4) != 0);
    }

    public String getWorkingSetScopeDescription(IWorkingSet[] workingSets, boolean includeJRE) {
        if (workingSets.length == 0) {
            return SearchMessages.JavaSearchScopeFactory_undefined_workingsets;
        }
        if (workingSets.length == 1) {
            String label = includeJRE ? SearchMessages.SingleWorkingSetScope : SearchMessages.SingleWorkingSetScopeNoJRE;
            return Messages.format(label, workingSets[0].getLabel());
        }
        Arrays.sort(workingSets, new WorkingSetComparator());
        if (workingSets.length == 2) {
            String label = includeJRE ? SearchMessages.DoubleWorkingSetScope : SearchMessages.DoubleWorkingSetScopeNoJRE;
            return Messages.format(label, new String[]{workingSets[0].getLabel(), workingSets[1].getLabel()});
        }
        String label = includeJRE ? SearchMessages.WorkingSetsScope : SearchMessages.WorkingSetsScopeNoJRE;
        return Messages.format(label, new String[]{workingSets[0].getLabel(), workingSets[1].getLabel()});
    }

    public IProject[] getProjects(IJavaScriptSearchScope scope) {
        IPath[] paths = scope.enclosingProjectsAndJars();
        HashSet<IResource> temp = new HashSet<IResource>();
        int i = 0;
        while (i < paths.length) {
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(paths[i]);
            if (resource != null && resource.getType() == 4) {
                temp.add(resource);
            }
            ++i;
        }
        return temp.toArray(new IProject[temp.size()]);
    }

    public IJavaScriptElement[] getJavaElements(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            return this.getJavaElements(((IStructuredSelection)selection).toArray());
        }
        return new IJavaScriptElement[0];
    }

    private IJavaScriptElement[] getJavaElements(Object[] elements) {
        if (elements.length == 0) {
            return new IJavaScriptElement[0];
        }
        HashSet result = new HashSet(elements.length);
        int i = 0;
        while (i < elements.length) {
            IResource resource;
            Object selectedElement = elements[i];
            if (selectedElement instanceof IJavaScriptElement) {
                this.addJavaElements(result, (IJavaScriptElement)selectedElement);
            } else if (selectedElement instanceof IResource) {
                this.addJavaElements(result, (IResource)selectedElement);
            } else if (selectedElement instanceof LogicalPackage) {
                this.addJavaElements(result, (LogicalPackage)((Object)selectedElement));
            } else if (selectedElement instanceof IWorkingSet) {
                IWorkingSet ws = (IWorkingSet)selectedElement;
                this.addJavaElements(result, ws);
            } else if (selectedElement instanceof IAdaptable && (resource = (IResource)((IAdaptable)selectedElement).getAdapter(IResource.class)) != null) {
                this.addJavaElements(result, resource);
            }
            ++i;
        }
        return result.toArray(new IJavaScriptElement[result.size()]);
    }

    public IJavaScriptSearchScope createJavaSearchScope(IJavaScriptElement[] javaElements, boolean includeJRE) {
        return this.createJavaSearchScope(javaElements, includeJRE ? 7 : 11);
    }

    public IJavaScriptSearchScope createJavaSearchScope(IJavaScriptElement[] javaElements, int includeMask) {
        if (javaElements.length == 0) {
            return this.EMPTY_SCOPE;
        }
        return SearchEngine.createJavaSearchScope(javaElements, JavaSearchScopeFactory.getSearchFlags(includeMask));
    }

    private IJavaScriptSearchScope createJavaSearchScope(Collection javaElements, int includeMask) {
        if (javaElements.isEmpty()) {
            return this.EMPTY_SCOPE;
        }
        IJavaScriptElement[] elementArray = javaElements.toArray(new IJavaScriptElement[javaElements.size()]);
        return SearchEngine.createJavaSearchScope(elementArray, JavaSearchScopeFactory.getSearchFlags(includeMask));
    }

    private static int getSearchFlags(int includeMask) {
        return includeMask;
    }

    private void addJavaElements(Set javaElements, IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            this.addJavaElements(javaElements, resources[i]);
            ++i;
        }
    }

    private void addJavaElements(Set javaElements, IResource resource) {
        IJavaScriptElement javaElement = (IJavaScriptElement)resource.getAdapter(IJavaScriptElement.class);
        if (javaElement == null) {
            return;
        }
        if (javaElement.getElementType() == 4) {
            try {
                this.addJavaElements(javaElements, ((IFolder)resource).members());
            }
            catch (CoreException coreException) {}
        }
        javaElements.add(javaElement);
    }

    private void addJavaElements(Set javaElements, IJavaScriptElement javaElement) {
        javaElements.add(javaElement);
    }

    private void addJavaElements(Set javaElements, IWorkingSet workingSet) {
        if (workingSet == null) {
            return;
        }
        if (workingSet.isAggregateWorkingSet() && workingSet.isEmpty()) {
            try {
                IJavaScriptProject[] projects = JavaScriptCore.create(ResourcesPlugin.getWorkspace().getRoot()).getJavaScriptProjects();
                javaElements.addAll(Arrays.asList(projects));
            }
            catch (JavaScriptModelException e) {
                JavaScriptPlugin.log((Throwable)((Object)e));
            }
            return;
        }
        IAdaptable[] elements = workingSet.getElements();
        int i = 0;
        while (i < elements.length) {
            IJavaScriptElement javaElement = (IJavaScriptElement)elements[i].getAdapter(IJavaScriptElement.class);
            if (javaElement != null) {
                this.addJavaElements(javaElements, javaElement);
            } else {
                IResource resource = (IResource)elements[i].getAdapter(IResource.class);
                if (resource != null) {
                    this.addJavaElements(javaElements, resource);
                }
            }
            ++i;
        }
    }

    private void addJavaElements(Set javaElements, LogicalPackage selectedElement) {
        IPackageFragment[] packages = selectedElement.getFragments();
        int i = 0;
        while (i < packages.length) {
            this.addJavaElements(javaElements, packages[i]);
            ++i;
        }
    }

    public IJavaScriptSearchScope createWorkspaceScope(boolean includeJRE) {
        return this.createWorkspaceScope(includeJRE ? 15 : 11);
    }

    public IJavaScriptSearchScope createWorkspaceScope(int includeMask) {
        if ((includeMask & 7) != 7) {
            try {
                IJavaScriptElement[] projects = JavaScriptCore.create(ResourcesPlugin.getWorkspace().getRoot()).getJavaScriptProjects();
                return SearchEngine.createJavaSearchScope(projects, JavaSearchScopeFactory.getSearchFlags(includeMask));
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        }
        return SearchEngine.createWorkspaceScope();
    }

    public boolean isInsideJRE(IJavaScriptElement element) {
        IPackageFragmentRoot root = (IPackageFragmentRoot)element.getAncestor(3);
        if (root != null) {
            try {
                IIncludePathEntry entry = root.getRawIncludepathEntry();
                if (entry.getEntryKind() == 5) {
                    IJsGlobalScopeContainer container = JavaScriptCore.getJsGlobalScopeContainer(entry.getPath(), root.getJavaScriptProject());
                    return container != null && container.getKind() == 3;
                }
                return false;
            }
            catch (JavaScriptModelException e) {
                JavaScriptPlugin.log((Throwable)((Object)e));
            }
        }
        return true;
    }
}

