/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.util;

import com.ibm.icu.text.BreakIterator;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContext2;
import org.eclipse.help.IHelpResource;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.text.html.HTML2TextReader;
import org.eclipse.wst.jsdt.ui.JSdocContentAccess;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;

public class JavadocHelpContext
implements IContext2 {
    private IHelpResource[] fHelpResources;
    private String fText;
    private String fTitle;
    private static final boolean BUG_85719_FIXED = false;

    public static void displayHelp(String contextId, Object[] selected) throws CoreException {
        Object context = HelpSystem.getContext((String)contextId);
        if (context != null) {
            if (selected != null && selected.length > 0) {
                context = new JavadocHelpContext((IContext)context, selected);
            }
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(context);
        }
    }

    public JavadocHelpContext(IContext context, Object[] elements) throws JavaScriptModelException {
        IHelpResource[] resources;
        Assert.isNotNull((Object)elements);
        if (context instanceof IContext2) {
            this.fTitle = ((IContext2)context).getTitle();
        }
        ArrayList<IHelpResource> helpResources = new ArrayList<IHelpResource>();
        Object javadocSummary = null;
        int i = 0;
        while (i < elements.length) {
            IJavaScriptElement element;
            if (elements[i] instanceof IJavaScriptElement && ActionUtil.isOnBuildPath(element = (IJavaScriptElement)elements[i])) {
                IPackageFragmentRoot root;
                URL url = JavaScriptUI.getJSdocLocation(element, true);
                if ((url == null || this.doesNotExist(url)) && (root = JavaModelUtil.getPackageFragmentRoot(element)) != null) {
                    url = JavaScriptUI.getJSdocBaseLocation(element);
                    element = root.getKind() == 1 ? element.getJavaScriptProject() : root;
                    url = JavaScriptUI.getJSdocLocation(element, false);
                }
                if (url != null) {
                    JavaUIHelpResource javaResource = new JavaUIHelpResource(element, this.getURLString(url));
                    helpResources.add(javaResource);
                }
            }
            ++i;
        }
        if (context != null && (resources = context.getRelatedTopics()) != null) {
            int j = 0;
            while (j < resources.length) {
                helpResources.add(resources[j]);
                ++j;
            }
        }
        this.fHelpResources = helpResources.toArray(new IHelpResource[helpResources.size()]);
        if (context != null) {
            this.fText = context.getText();
        }
        if (this.fText == null) {
            this.fText = "";
        }
    }

    private String getURLString(URL url) {
        int anchorIdx;
        String location = url.toExternalForm();
        if (url.getRef() != null && (anchorIdx = location.lastIndexOf(35)) != -1) {
            return String.valueOf(location.substring(0, anchorIdx)) + "?noframes=true" + location.substring(anchorIdx);
        }
        return String.valueOf(location) + "?noframes=true";
    }

    private boolean doesNotExist(URL url) {
        if (url.getProtocol().equals("file")) {
            File file = new File(url.getFile());
            return !file.exists();
        }
        return false;
    }

    private String retrieveText(IJavaScriptElement elem) throws JavaScriptModelException {
        if (elem instanceof IMember) {
            Reader reader = JSdocContentAccess.getHTMLContentReader((IMember)elem, true, true);
            if (reader != null) {
                reader = new HTML2TextReader(reader, null);
            }
            if (reader != null) {
                String str = JavadocHelpContext.getString(reader);
                BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                breakIterator.setText(str);
                return str.substring(0, breakIterator.next());
            }
        }
        return "";
    }

    private static String getString(Reader reader) {
        StringBuffer buf = new StringBuffer();
        char[] buffer = new char[1024];
        try {
            int count;
            while ((count = reader.read(buffer)) != -1) {
                buf.append(buffer, 0, count);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return buf.toString();
    }

    public IHelpResource[] getRelatedTopics() {
        return this.fHelpResources;
    }

    public String getText() {
        return this.fText;
    }

    public String getStyledText() {
        return this.fText;
    }

    public String getCategory(IHelpResource topic) {
        if (topic instanceof JavaUIHelpResource) {
            return JavaUIMessages.JavaUIHelpContext_javaHelpCategory_label;
        }
        return null;
    }

    public String getTitle() {
        return this.fTitle;
    }

    private static class JavaUIHelpResource
    implements IHelpResource {
        private IJavaScriptElement fElement;
        private String fUrl;

        public JavaUIHelpResource(IJavaScriptElement element, String url) {
            this.fElement = element;
            this.fUrl = url;
        }

        public String getHref() {
            return this.fUrl;
        }

        public String getLabel() {
            String label = JavaScriptElementLabels.getTextLabel(this.fElement, 2235683898506L);
            return Messages.format(JavaUIMessages.JavaUIHelp_link_label, label);
        }
    }
}

