/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal;

import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.events.AboutToBeChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.IModelAboutToBeChangedListener;
import org.eclipse.wst.sse.core.internal.provisional.events.IStructuredDocumentListener;
import org.eclipse.wst.sse.core.internal.provisional.events.NewDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.NoChangeEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentRegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.util.Debug;
import org.eclipse.wst.xml.core.internal.IDebugAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class EveryNodeDebugAdapter
implements IDebugAdapter {
    private static EveryNodeDebugAdapter singletonInstance;
    InternalDocumentListener fInternalDocumentListener = new InternalDocumentListener();
    InternalModelStateListener fInternalModelStateListener;
    InternalStructuredDocumentAboutToChange fInternalStructuredDocumentAboutToChange = new InternalStructuredDocumentAboutToChange();
    InternalStructuredDocumentListener fInternalStructuredDocumentListener = new InternalStructuredDocumentListener();
    IStructuredModel fModel;

    public static EveryNodeDebugAdapter getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new EveryNodeDebugAdapter();
        }
        return singletonInstance;
    }

    public EveryNodeDebugAdapter() {
        this.fInternalModelStateListener = new InternalModelStateListener();
    }

    public EveryNodeDebugAdapter(INodeNotifier target) {
        this();
    }

    @Override
    public boolean isAdapterForType(Object type) {
        return type == IDebugAdapter.class;
    }

    @Override
    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (notifier instanceof IDOMNode) {
            this.setModel(((IDOMNode)notifier).getModel());
        }
        Debug.println("notifier: " + notifier + " " + INodeNotifier.EVENT_TYPE_STRINGS[eventType] + " changedFeature: " + changedFeature + " oldValue: " + oldValue + " newValue: " + newValue + " pos: " + pos);
    }

    private void setModel(IStructuredModel structuredModel) {
        IStructuredDocument structuredDocument;
        if (this.fModel == structuredModel) {
            return;
        }
        if (this.fModel != null) {
            this.fModel.removeModelStateListener(this.fInternalModelStateListener);
            structuredDocument = this.fModel.getStructuredDocument();
            if (structuredDocument != null) {
                structuredDocument.removeDocumentListener(this.fInternalDocumentListener);
                structuredDocument.removeDocumentAboutToChangeListener(this.fInternalStructuredDocumentAboutToChange);
                structuredDocument.removeDocumentChangedListener(this.fInternalStructuredDocumentListener);
            }
        }
        this.fModel = structuredModel;
        if (this.fModel != null) {
            this.fModel.addModelStateListener(this.fInternalModelStateListener);
            structuredDocument = this.fModel.getStructuredDocument();
            if (structuredDocument != null) {
                structuredDocument.addDocumentListener(this.fInternalDocumentListener);
                structuredDocument.addDocumentAboutToChangeListener(this.fInternalStructuredDocumentAboutToChange);
                structuredDocument.addDocumentChangedListener(this.fInternalStructuredDocumentListener);
            }
        }
    }

    static class InternalDocumentListener
    implements IDocumentListener {
        InternalDocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            Debug.println("IdocumentAboutToBeChanged: " + event);
        }

        public void documentChanged(DocumentEvent event) {
            Debug.println("IdocumentChanged: " + event);
        }
    }

    static class InternalModelStateListener
    implements IModelStateListener {
        InternalModelStateListener() {
        }

        @Override
        public void modelAboutToBeChanged(IStructuredModel model) {
            Debug.println("modelAboutToBeChanged: " + model);
        }

        @Override
        public void modelChanged(IStructuredModel model) {
            Debug.println("modelChanged: " + model);
        }

        @Override
        public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
            Debug.println("modelDirtyStateChanged: " + model);
        }

        @Override
        public void modelResourceDeleted(IStructuredModel model) {
            Debug.println("modelResourceDeleted: " + model);
        }

        @Override
        public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
            Debug.println("modelResourceMoved: oldModel: " + oldModel + "newModel: " + newModel);
        }

        @Override
        public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
            Debug.println("modelAboutToBeReinitialized: structuredModel: " + structuredModel);
        }

        @Override
        public void modelReinitialized(IStructuredModel structuredModel) {
            Debug.println("modelReinitialized: structuredModel: " + structuredModel);
        }
    }

    static class InternalStructuredDocumentAboutToChange
    implements IModelAboutToBeChangedListener {
        InternalStructuredDocumentAboutToChange() {
        }

        @Override
        public void modelAboutToBeChanged(AboutToBeChangedEvent structuredDocumentEvent) {
            Debug.println("structuredDocumentAboutToBeChanged: " + (Object)((Object)structuredDocumentEvent));
        }
    }

    static class InternalStructuredDocumentListener
    implements IStructuredDocumentListener {
        InternalStructuredDocumentListener() {
        }

        @Override
        public void newModel(NewDocumentEvent structuredDocumentEvent) {
            Debug.println("structuredDocumentChanged - newModel: " + (Object)((Object)structuredDocumentEvent));
        }

        @Override
        public void noChange(NoChangeEvent structuredDocumentEvent) {
            Debug.println("structuredDocumentChanged - noChange: " + (Object)((Object)structuredDocumentEvent));
        }

        @Override
        public void nodesReplaced(StructuredDocumentRegionsReplacedEvent structuredDocumentEvent) {
            Debug.println("structuredDocumentChanged - nodesReplaced: " + (Object)((Object)structuredDocumentEvent));
        }

        @Override
        public void regionChanged(RegionChangedEvent structuredDocumentEvent) {
            Debug.println("structuredDocumentChanged - regionChanged: " + (Object)((Object)structuredDocumentEvent));
        }

        @Override
        public void regionsReplaced(RegionsReplacedEvent structuredDocumentEvent) {
            Debug.println("structuredDocumentChanged - regionsReplaced: " + (Object)((Object)structuredDocumentEvent));
        }
    }
}

