/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document;

import java.util.Iterator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.document.DOMMessages;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.document.StructuredDocumentRegionUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocumentType;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DocumentTypeImpl
extends NodeImpl
implements IDOMDocumentType {
    private String internalSubset = null;
    private String name = null;
    private String publicId = null;
    private String systemId = null;

    protected DocumentTypeImpl() {
    }

    protected DocumentTypeImpl(DocumentTypeImpl that) {
        super(that);
        if (that != null) {
            this.name = that.name;
        }
    }

    @Override
    public Node cloneNode(boolean deep) {
        DocumentTypeImpl cloned = new DocumentTypeImpl(this);
        this.notifyUserDataHandlers((short)1, cloned);
        return cloned;
    }

    @Override
    public NamedNodeMap getEntities() {
        return null;
    }

    @Override
    public String getInternalSubset() {
        IStructuredDocumentRegion region;
        if (this.internalSubset == null && (region = this.getFirstStructuredDocumentRegion()) != null) {
            Iterator it = region.getRegions().iterator();
            while (it.hasNext()) {
                ITextRegion text;
                Object next = it.next();
                if (!(next instanceof ITextRegion) || (text = (ITextRegion)next).getType() != "XML_DOCTYPE_INTERNAL_SUBSET") continue;
                String regionText = region.getText(text);
                if (regionText.length() <= 0 || regionText.charAt(0) != '[' || regionText.charAt(regionText.length() - 1) != ']') break;
                this.internalSubset = regionText.substring(1, regionText.length() - 1);
                break;
            }
        }
        return this.internalSubset;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public short getNodeType() {
        return 10;
    }

    @Override
    public NamedNodeMap getNotations() {
        return null;
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public boolean isClosed() {
        IStructuredDocumentRegion flatNode = this.getStructuredDocumentRegion();
        if (flatNode == null) {
            return true;
        }
        String regionType = StructuredDocumentRegionUtil.getLastRegionType(flatNode);
        return regionType == "XML_DOCTYPE_DECLARATION_CLOSE" || regionType == "XML_DECLARATION_CLOSE";
    }

    public void setInternalSubset(String internalSubset) {
        if (!this.isDataEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        this.internalSubset = internalSubset;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public void setPublicId(String publicId) {
        if (!this.isDataEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        this.publicId = publicId;
        this.notifyValueChanged();
    }

    @Override
    public void setSystemId(String systemId) {
        if (!this.isDataEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        this.systemId = systemId;
        this.notifyValueChanged();
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getName());
        buffer.append('(');
        buffer.append(this.getPublicId());
        buffer.append(')');
        buffer.append('(');
        buffer.append(this.getSystemId());
        buffer.append(')');
        IStructuredDocumentRegion flatNode = this.getStructuredDocumentRegion();
        if (flatNode != null) {
            buffer.append('@');
            buffer.append(flatNode.toString());
        }
        return buffer.toString();
    }
}

