/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.callhierarchy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CalleeMethodWrapper;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallerMethodWrapper;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.Implementors;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.MethodCall;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.util.StringMatcher;

public class CallHierarchy {
    private static final String PREF_USE_IMPLEMENTORS = "PREF_USE_IMPLEMENTORS";
    private static final String PREF_USE_FILTERS = "PREF_USE_FILTERS";
    private static final String PREF_FILTERS_LIST = "PREF_FILTERS_LIST";
    private static final String DEFAULT_IGNORE_FILTERS = "java.*,javax.*";
    private static CallHierarchy fgInstance;
    private IJavaScriptSearchScope fSearchScope;
    private StringMatcher[] fFilters;

    public static CallHierarchy getDefault() {
        if (fgInstance == null) {
            fgInstance = new CallHierarchy();
        }
        return fgInstance;
    }

    public boolean isSearchUsingImplementorsEnabled() {
        IPreferenceStore settings = JavaScriptPlugin.getDefault().getPreferenceStore();
        return settings.getBoolean(PREF_USE_IMPLEMENTORS);
    }

    public void setSearchUsingImplementorsEnabled(boolean enabled) {
        IPreferenceStore settings = JavaScriptPlugin.getDefault().getPreferenceStore();
        settings.setValue(PREF_USE_IMPLEMENTORS, enabled);
    }

    public Collection getImplementingMethods(IFunction method) {
        IJavaScriptElement[] result;
        if (this.isSearchUsingImplementorsEnabled() && (result = Implementors.getInstance().searchForImplementors(new IJavaScriptElement[]{method}, (IProgressMonitor)new NullProgressMonitor())) != null && result.length > 0) {
            return Arrays.asList(result);
        }
        return new ArrayList(0);
    }

    public MethodWrapper getCallerRoot(IFunction method) {
        return new CallerMethodWrapper(null, new MethodCall(method));
    }

    public MethodWrapper getCalleeRoot(IFunction method) {
        return new CalleeMethodWrapper(null, new MethodCall(method));
    }

    public static CallLocation getCallLocation(Object element) {
        CallLocation callLocation = null;
        if (element instanceof MethodWrapper) {
            MethodWrapper methodWrapper = (MethodWrapper)((Object)element);
            MethodCall methodCall = methodWrapper.getMethodCall();
            if (methodCall != null) {
                callLocation = methodCall.getFirstCallLocation();
            }
        } else if (element instanceof CallLocation) {
            callLocation = (CallLocation)element;
        }
        return callLocation;
    }

    public IJavaScriptSearchScope getSearchScope() {
        if (this.fSearchScope == null) {
            this.fSearchScope = SearchEngine.createWorkspaceScope();
        }
        return this.fSearchScope;
    }

    public void setSearchScope(IJavaScriptSearchScope searchScope) {
        this.fSearchScope = searchScope;
    }

    public boolean isIgnored(String fullyQualifiedName) {
        if (this.getIgnoreFilters() != null && this.getIgnoreFilters().length > 0) {
            int i = 0;
            while (i < this.getIgnoreFilters().length) {
                String fullyQualifiedName1 = fullyQualifiedName;
                if (this.getIgnoreFilters()[i].match(fullyQualifiedName1)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isFilterEnabled() {
        IPreferenceStore settings = JavaScriptPlugin.getDefault().getPreferenceStore();
        return settings.getBoolean(PREF_USE_FILTERS);
    }

    public void setFilterEnabled(boolean filterEnabled) {
        IPreferenceStore settings = JavaScriptPlugin.getDefault().getPreferenceStore();
        settings.setValue(PREF_USE_FILTERS, filterEnabled);
    }

    public String getFilters() {
        IPreferenceStore settings = JavaScriptPlugin.getDefault().getPreferenceStore();
        return settings.getString(PREF_FILTERS_LIST);
    }

    public void setFilters(String filters) {
        this.fFilters = null;
        IPreferenceStore settings = JavaScriptPlugin.getDefault().getPreferenceStore();
        settings.setValue(PREF_FILTERS_LIST, filters);
    }

    private StringMatcher[] getIgnoreFilters() {
        if (this.fFilters == null) {
            String filterString = null;
            if (this.isFilterEnabled() && (filterString = this.getFilters()) == null) {
                filterString = DEFAULT_IGNORE_FILTERS;
            }
            this.fFilters = filterString != null ? CallHierarchy.parseList(filterString) : null;
        }
        return this.fFilters;
    }

    private static StringMatcher[] parseList(String listString) {
        ArrayList<StringMatcher> list = new ArrayList<StringMatcher>(10);
        StringTokenizer tokenizer = new StringTokenizer(listString, ",");
        while (tokenizer.hasMoreTokens()) {
            String textFilter = tokenizer.nextToken().trim();
            list.add(new StringMatcher(textFilter, false, false));
        }
        return list.toArray(new StringMatcher[list.size()]);
    }

    static JavaScriptUnit getCompilationUnitNode(IMember member, boolean resolveBindings) {
        ITypeRoot typeRoot = member.getTypeRoot();
        try {
            if (typeRoot.exists() && typeRoot.getBuffer() != null) {
                ASTParser parser = ASTParser.newParser(3);
                parser.setSource(typeRoot);
                parser.setResolveBindings(resolveBindings);
                return (JavaScriptUnit)parser.createAST(null);
            }
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log((Throwable)((Object)e));
        }
        return null;
    }
}

