/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.wst.jsdt.internal.corext.util.JavaElementResourceMapping;

abstract class PackageReorgChange
extends JDTChange {
    private String fPackageHandle;
    private String fDestinationHandle;
    private INewNameQuery fNameQuery;

    PackageReorgChange(IPackageFragment pack, IPackageFragmentRoot dest, INewNameQuery nameQuery) {
        this.fPackageHandle = pack.getHandleIdentifier();
        this.fDestinationHandle = dest.getHandleIdentifier();
        this.fNameQuery = nameQuery;
    }

    abstract Change doPerformReorg(IProgressMonitor var1) throws JavaScriptModelException, OperationCanceledException;

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return this.isValid(pm, 0);
    }

    public final Change perform(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.beginTask(this.getName(), 1);
        try {
            IPackageFragment pack = this.getPackage();
            ResourceMapping mapping = JavaElementResourceMapping.create(pack);
            Change result = this.doPerformReorg(pm);
            this.markAsExecuted(pack, mapping);
            Change change = result;
            return change;
        }
        finally {
            pm.done();
        }
    }

    public Object getModifiedElement() {
        return this.getPackage();
    }

    IPackageFragmentRoot getDestination() {
        return (IPackageFragmentRoot)JavaScriptCore.create(this.fDestinationHandle);
    }

    IPackageFragment getPackage() {
        return (IPackageFragment)JavaScriptCore.create(this.fPackageHandle);
    }

    String getNewName() throws OperationCanceledException {
        if (this.fNameQuery == null) {
            return null;
        }
        return this.fNameQuery.getNewName();
    }

    private void markAsExecuted(IPackageFragment pack, ResourceMapping mapping) {
        ReorgExecutionLog log = (ReorgExecutionLog)this.getAdapter(ReorgExecutionLog.class);
        if (log != null) {
            log.markAsProcessed((Object)pack);
            log.markAsProcessed((Object)mapping);
        }
    }
}

