/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.validate;

import org.eclipse.wst.html.core.internal.validate.AbstractErrorInfo;
import org.eclipse.wst.html.core.internal.validate.Segment;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

final class ErrorInfoImpl
extends AbstractErrorInfo {
    private Node target = null;
    private String[] fPreTargetMsgArgs;
    private String[] fPostTargetMsgArgs;

    public ErrorInfoImpl(int state, Segment errorSeg, Node target) {
        super(state, errorSeg);
        this.target = target;
        this.fPreTargetMsgArgs = new String[0];
        this.fPostTargetMsgArgs = new String[0];
    }

    public ErrorInfoImpl(int state, Segment errorSeg, Node target, String[] preTargetMsgArgs, String[] postTargetMsgInjections) {
        super(state, errorSeg);
        this.target = target;
        this.fPreTargetMsgArgs = preTargetMsgArgs;
        this.fPostTargetMsgArgs = postTargetMsgInjections;
    }

    @Override
    public String getHint() {
        switch (this.target.getNodeType()) {
            case 2: {
                switch (this.getState()) {
                    case 12: 
                    case 13: 
                    case 113: 
                    case 114: {
                        return ((Attr)this.target).getValue();
                    }
                }
                return this.target.getNodeName();
            }
            case 3: {
                return ((Text)this.target).getData();
            }
        }
        return this.target.getNodeName();
    }

    @Override
    public String[] getMessageArguments() {
        String[] messageInjections = new String[this.fPreTargetMsgArgs.length + 1 + this.fPostTargetMsgArgs.length];
        System.arraycopy(this.fPreTargetMsgArgs, 0, messageInjections, 0, this.fPreTargetMsgArgs.length);
        int nextIndex = this.fPreTargetMsgArgs.length;
        block0 : switch (this.target.getNodeType()) {
            case 2: {
                switch (this.getState()) {
                    case 12: 
                    case 13: 
                    case 113: 
                    case 114: {
                        messageInjections[nextIndex] = ((Attr)this.target).getValue();
                        break block0;
                    }
                }
                messageInjections[nextIndex] = this.target.getNodeName();
                break;
            }
            case 3: {
                messageInjections[nextIndex] = ((Text)this.target).getData();
                break;
            }
            default: {
                messageInjections[nextIndex] = this.target.getNodeName();
            }
        }
        System.arraycopy(this.fPostTargetMsgArgs, 0, messageInjections, nextIndex + 1, this.fPostTargetMsgArgs.length);
        return messageInjections;
    }

    @Override
    public short getTargetType() {
        return this.target.getNodeType();
    }
}

